/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.object.bodytext.control.form.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kr.dogfoot.hwplib.object.bodytext.control.form.properties.Property;
import kr.dogfoot.hwplib.object.bodytext.control.form.properties.PropertyNormal;
import kr.dogfoot.hwplib.object.bodytext.control.form.properties.PropertyType;
import kr.dogfoot.hwplib.object.etc.HWPString;

public class PropertySet
extends Property {
    private HashMap<String, Property> propertyMap;

    public PropertySet(String name) {
        this.setName(name);
        this.propertyMap = new HashMap();
    }

    public PropertyNormal addNewNormalProperty(String name, String type) {
        PropertyNormal propertyNormal = new PropertyNormal(name);
        propertyNormal.setType(PropertyType.fromString(type));
        this.propertyMap.put(name, propertyNormal);
        return propertyNormal;
    }

    public PropertySet addNewPropertySet(String name) {
        PropertySet propertySet = new PropertySet(name);
        this.propertyMap.put(name, propertySet);
        return propertySet;
    }

    public Property getProperty(String name) {
        return this.propertyMap.get(name);
    }

    public Set<String> getNames() {
        return this.propertyMap.keySet();
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Set;
    }

    public void copy(PropertySet from) {
        this.setName(from.getName());
        this.propertyMap.clear();
        for (Map.Entry<String, Property> entry : from.propertyMap.entrySet()) {
            this.propertyMap.put(entry.getKey(), entry.getValue().clone());
        }
    }

    @Override
    public Property clone() {
        PropertySet cloned = new PropertySet(this.getName());
        for (Map.Entry<String, Property> entry : this.propertyMap.entrySet()) {
            cloned.propertyMap.put(entry.getKey(), entry.getValue().clone());
        }
        return cloned;
    }

    public void parse(String data) {
        while (data.length() > 0) {
            int position = data.indexOf(":");
            String name = data.substring(0, position);
            data = data.substring(position + 1);
            position = data.indexOf(":");
            String type = data.substring(0, position);
            data = data.substring(position + 1);
            if (type.equals("set")) {
                position = data.indexOf(":");
                int length = Integer.parseInt(data.substring(0, position));
                data = data.substring(position + 1);
                String setData = data.substring(0, length);
                data = data.substring(length + 1);
                this.addNewPropertySet(name).parse(setData);
                continue;
            }
            if (type.equals("wstring")) {
                position = data.indexOf(":");
                int length = Integer.parseInt(data.substring(0, position));
                data = data.substring(position + 1);
                String value = data.substring(0, length);
                data = data.substring(length + 1);
                this.addNewNormalProperty(name, type).setValue(value);
                continue;
            }
            position = data.indexOf(" ");
            String value = data.substring(0, position);
            data = data.substring(position + 1);
            this.addNewNormalProperty(name, type).setValue(value);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getName() != null && this.getName().length() > 0) {
            StringBuffer sb2 = new StringBuffer();
            for (Property property : this.propertyMap.values()) {
                sb2.append(property.toString()).append(" ");
            }
            sb.append(this.getName()).append(":").append((Object)this.getType()).append(":").append(sb2.length()).append(":").append(sb2);
        } else {
            for (Property property : this.propertyMap.values()) {
                sb.append(property.toString()).append(" ");
            }
        }
        return sb.toString();
    }

    public HWPString toHWPString() {
        HWPString ret = new HWPString();
        ret.fromUTF16LEString(this.toString());
        return ret;
    }
}

