/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.object.bodytext.paragraph.text;

import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharType;

public abstract class HWPChar {
    protected int code;

    public abstract HWPCharType getType();

    public static HWPCharType type(int code) {
        if (code > 31) {
            return HWPCharType.Normal;
        }
        switch (code) {
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                return HWPCharType.ControlExtend;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                return HWPCharType.ControlInline;
            }
            case 0: 
            case 10: 
            case 13: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return HWPCharType.ControlChar;
            }
        }
        return HWPCharType.Normal;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public abstract HWPChar clone();

    public abstract int getCharSize();

    public boolean isSpace() {
        return this.code == 32;
    }

    public boolean isHangul() {
        return 44032 <= this.code && this.code <= 55215 || 12593 <= this.code && this.code <= 12686;
    }

    public boolean isLineBreak() {
        return this.code == 10;
    }

    public boolean isParaBreak() {
        return this.code == 13;
    }
}

