/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.object.bodytext.paragraph.text;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlExtend;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlInline;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharNormal;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharType;

public class ParaText {
    private ArrayList<HWPChar> charList = new ArrayList();

    public HWPCharNormal addNewNormalChar() {
        HWPCharNormal nc = new HWPCharNormal();
        this.charList.add(nc);
        return nc;
    }

    public HWPCharNormal insertNewNormalChar(int position) {
        HWPCharNormal nc = new HWPCharNormal();
        this.charList.add(position, nc);
        return nc;
    }

    public HWPCharControlChar addNewCharControlChar() {
        HWPCharControlChar ccc = new HWPCharControlChar();
        this.charList.add(ccc);
        return ccc;
    }

    public HWPCharControlInline addNewInlineControlChar() {
        HWPCharControlInline icc = new HWPCharControlInline();
        this.charList.add(icc);
        return icc;
    }

    public HWPCharControlExtend addNewExtendControlChar() {
        HWPCharControlExtend ecc = new HWPCharControlExtend();
        this.charList.add(ecc);
        return ecc;
    }

    public ArrayList<HWPChar> getCharList() {
        return this.charList;
    }

    public int getCharIndexFromExtendCharIndex(int extendCharIndex) {
        int extendCharIndex2 = 0;
        int count = this.charList.size();
        for (int index = 0; index < count; ++index) {
            if (this.charList.get(index).getType() != HWPCharType.ControlExtend) continue;
            if (extendCharIndex == extendCharIndex2) {
                return index;
            }
            ++extendCharIndex2;
        }
        return -1;
    }

    public int getInlineCharIndex(int startIndex, short charCode) {
        int count = this.charList.size();
        for (int index = startIndex; index < count; ++index) {
            HWPChar ch = this.charList.get(index);
            if (ch.getType() != HWPCharType.ControlInline || ch.getCode() != charCode) continue;
            return index;
        }
        return -1;
    }

    public String getNormalString(int startIndex, int endIndex) throws UnsupportedEncodingException {
        if (startIndex == endIndex) {
            return "";
        }
        if (startIndex > endIndex) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int index = startIndex; index <= endIndex; ++index) {
            HWPChar ch = this.charList.get(index);
            if (ch.getType() != HWPCharType.Normal) continue;
            HWPCharNormal chn = (HWPCharNormal)ch;
            sb.append(chn.getCh());
        }
        return sb.toString();
    }

    public String getNormalString(int startIndex) throws UnsupportedEncodingException {
        return this.getNormalString(startIndex, this.charList.size() - 1);
    }

    public void addString(String str) throws UnsupportedEncodingException {
        int len = str.length();
        for (int index = 0; index < len; ++index) {
            HWPCharNormal ch = this.addNewNormalChar();
            ch.setCode((short)str.codePointAt(index));
        }
        this.processEndOfParagraph();
    }

    public int insertString(int position, String str) throws UnsupportedEncodingException {
        int oldCharSize = this.getCharSize();
        int len = str.length();
        for (int index = 0; index < len; ++index) {
            HWPCharNormal ch = this.insertNewNormalChar(position + index);
            ch.setCode((short)str.codePointAt(index));
        }
        this.processEndOfParagraph();
        return this.getCharSize() - oldCharSize;
    }

    public void addExtendCharForSectionDefine() {
        HWPCharControlExtend chExtend = this.addNewExtendControlChar();
        chExtend.setCode(2);
        byte[] addition = new byte[12];
        addition[3] = 115;
        addition[2] = 101;
        addition[1] = 99;
        addition[0] = 100;
        try {
            chExtend.setAddition(addition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processEndOfParagraph();
    }

    private void processEndOfParagraph() {
        for (HWPChar ch : this.charList) {
            if (ch.getCode() != 13) continue;
            this.charList.remove(ch);
            break;
        }
        HWPCharNormal ch2 = this.addNewNormalChar();
        ch2.setCode(13);
    }

    public void addExtendCharForColumnDefine() {
        HWPCharControlExtend chExtend = this.addNewExtendControlChar();
        chExtend.setCode(2);
        byte[] addition = new byte[12];
        addition[3] = 99;
        addition[2] = 111;
        addition[1] = 108;
        addition[0] = 100;
        try {
            chExtend.setAddition(addition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processEndOfParagraph();
    }

    public void addExtendCharForTable() {
        HWPCharControlExtend chExtend = this.addNewExtendControlChar();
        chExtend.setCode(11);
        byte[] addition = new byte[12];
        addition[3] = 116;
        addition[2] = 98;
        addition[1] = 108;
        addition[0] = 32;
        try {
            chExtend.setAddition(addition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processEndOfParagraph();
    }

    public void addExtendCharForGSO() {
        HWPCharControlExtend chExtend = this.addNewExtendControlChar();
        chExtend.setCode(11);
        byte[] addition = new byte[12];
        addition[3] = 103;
        addition[2] = 115;
        addition[1] = 111;
        addition[0] = 32;
        try {
            chExtend.setAddition(addition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processEndOfParagraph();
    }

    public void addExtendCharForHyperlinkStart() {
        HWPCharControlExtend chExtend = this.addNewExtendControlChar();
        chExtend.setCode(3);
        byte[] addition = new byte[12];
        addition[3] = 37;
        addition[2] = 104;
        addition[1] = 108;
        addition[0] = 107;
        try {
            chExtend.setAddition(addition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processEndOfParagraph();
    }

    public void addExtendCharForHyperlinkEnd() {
        HWPCharControlInline chExtend = this.addNewInlineControlChar();
        chExtend.setCode(4);
        byte[] addition = new byte[12];
        addition[3] = 37;
        addition[2] = 104;
        addition[1] = 108;
        addition[0] = 107;
        try {
            chExtend.setAddition(addition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processEndOfParagraph();
    }

    public void addExtendCharForHeader() {
        HWPCharControlExtend chExtend = this.addNewExtendControlChar();
        chExtend.setCode(16);
        byte[] addition = new byte[12];
        addition[3] = 104;
        addition[2] = 101;
        addition[1] = 97;
        addition[0] = 100;
        try {
            chExtend.setAddition(addition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processEndOfParagraph();
    }

    public void addExtendCharForFooter() {
        HWPCharControlExtend chExtend = this.addNewExtendControlChar();
        chExtend.setCode(16);
        byte[] addition = new byte[12];
        addition[3] = 102;
        addition[2] = 111;
        addition[1] = 111;
        addition[0] = 116;
        try {
            chExtend.setAddition(addition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processEndOfParagraph();
    }

    public ParaText clone() {
        ParaText cloned = new ParaText();
        for (HWPChar hwpChar : this.charList) {
            cloned.charList.add(hwpChar.clone());
        }
        return cloned;
    }

    public int getCharSize() {
        int length = 0;
        for (HWPChar hwpChar : this.charList) {
            length += hwpChar.getCharSize();
        }
        return length;
    }
}

