/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.org.apache.poi.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import kr.dogfoot.hwplib.org.apache.poi.util.LittleEndianInput;

public class LittleEndianInputStream
extends FilterInputStream
implements LittleEndianInput {
    public LittleEndianInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int available() {
        try {
            return super.available();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte readByte() {
        return (byte)this.readUByte();
    }

    @Override
    public int readUByte() {
        int ch;
        try {
            ch = this.in.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LittleEndianInputStream.checkEOF(ch);
        return ch;
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int readInt() {
        int ch4;
        int ch3;
        int ch2;
        int ch1;
        try {
            ch1 = this.in.read();
            ch2 = this.in.read();
            ch3 = this.in.read();
            ch4 = this.in.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LittleEndianInputStream.checkEOF(ch1 | ch2 | ch3 | ch4);
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    @Override
    public long readLong() {
        int b7;
        int b6;
        int b5;
        int b4;
        int b3;
        int b2;
        int b1;
        int b0;
        try {
            b0 = this.in.read();
            b1 = this.in.read();
            b2 = this.in.read();
            b3 = this.in.read();
            b4 = this.in.read();
            b5 = this.in.read();
            b6 = this.in.read();
            b7 = this.in.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LittleEndianInputStream.checkEOF(b0 | b1 | b2 | b3 | b4 | b5 | b6 | b7);
        return ((long)b7 << 56) + ((long)b6 << 48) + ((long)b5 << 40) + ((long)b4 << 32) + ((long)b3 << 24) + (long)(b2 << 16) + (long)(b1 << 8) + (long)(b0 << 0);
    }

    @Override
    public short readShort() {
        return (short)this.readUShort();
    }

    @Override
    public int readUShort() {
        int ch2;
        int ch1;
        try {
            ch1 = this.in.read();
            ch2 = this.in.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LittleEndianInputStream.checkEOF(ch1 | ch2);
        return (ch2 << 8) + (ch1 << 0);
    }

    private static void checkEOF(int value) {
        if (value < 0) {
            throw new RuntimeException("Unexpected end-of-file");
        }
    }

    @Override
    public void readFully(byte[] buf) {
        this.readFully(buf, 0, buf.length);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) {
        int max = off + len;
        for (int i = off; i < max; ++i) {
            int ch;
            try {
                ch = this.in.read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            LittleEndianInputStream.checkEOF(ch);
            buf[i] = (byte)ch;
        }
    }
}

