/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader;

import java.io.IOException;
import java.util.Arrays;
import kr.dogfoot.hwplib.object.fileheader.FileHeader;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.util.binary.BitFlag;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForFileHeader {
    public static void read(FileHeader fh, StreamReader sr) throws Exception {
        ForFileHeader.signature(sr);
        ForFileHeader.fileVersion(fh.getVersion(), sr);
        ForFileHeader.properties(fh, sr);
    }

    private static void signature(StreamReader sr) throws Exception {
        byte[] sign = new byte[32];
        sr.readBytes(sign);
        if (!Arrays.equals(FileHeader.getFileSignature(), sign)) {
            throw new Exception("this is not hwp file.");
        }
    }

    private static void fileVersion(FileVersion fv, StreamReader sr) throws IOException {
        fv.setVersion(sr.readUInt4());
    }

    private static void properties(FileHeader fh, StreamReader sr) throws IOException {
        long flag = sr.readUInt4();
        fh.setCompressed(BitFlag.get(flag, 0));
        fh.setHasPassword(BitFlag.get(flag, 1));
        fh.setDistribution(BitFlag.get(flag, 2));
        fh.setSaveScript(BitFlag.get(flag, 3));
        fh.setDRMDocument(BitFlag.get(flag, 4));
        fh.setHasXMLTemplate(BitFlag.get(flag, 5));
        fh.setHasDocumentHistory(BitFlag.get(flag, 6));
        fh.setHasSignature(BitFlag.get(flag, 7));
        fh.setEncryptPublicCertification(BitFlag.get(flag, 8));
        fh.setSavePrepareSignature(BitFlag.get(flag, 9));
        fh.setPublicCertificationDRMDocument(BitFlag.get(flag, 10));
        fh.setCCLDocument(BitFlag.get(flag, 11));
    }
}

