/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph.control;

import java.io.IOException;
import kr.dogfoot.hwplib.object.RecordHeader;
import kr.dogfoot.hwplib.object.bodytext.control.ControlFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderFootnote;
import kr.dogfoot.hwplib.object.bodytext.control.footnoteendnote.ListHeaderForFootnodeEndnote;
import kr.dogfoot.hwplib.object.bodytext.control.sectiondefine.NumberShape;
import kr.dogfoot.hwplib.reader.bodytext.ForParagraphList;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForControlFootnote {
    private ControlFootnote fn;
    private StreamReader sr;

    public void read(ControlFootnote fn, StreamReader sr) throws Exception {
        this.fn = fn;
        this.sr = sr;
        this.ctrlHeader();
        this.listHeader();
        this.paragraphList();
    }

    private void ctrlHeader() throws IOException {
        CtrlHeaderFootnote h = this.fn.getHeader();
        h.setNumber(this.sr.readUInt4());
        h.getBeforeDecorationLetter().setBytes(this.sr.readWChar());
        h.getAfterDecorationLetter().setBytes(this.sr.readWChar());
        h.setNumberShape(NumberShape.valueOf((short)this.sr.readUInt4()));
        if (this.sr.isEndOfRecord()) {
            return;
        }
        h.setInstanceId(this.sr.readUInt4());
    }

    private void listHeader() throws Exception {
        RecordHeader rh = this.sr.readRecordHeader();
        if (rh.getTagID() != 72) {
            throw new Exception("List header must be located.");
        }
        ListHeaderForFootnodeEndnote lh = this.fn.getListHeader();
        lh.setParaCount(this.sr.readSInt4());
        lh.getProperty().setValue(this.sr.readUInt4());
        this.sr.skipToEndRecord();
    }

    private void paragraphList() throws Exception {
        ForParagraphList.read(this.fn.getParagraphList(), this.sr);
    }
}

