/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.FactoryForControl;
import kr.dogfoot.hwplib.object.bodytext.control.bookmark.CtrlData;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderGso;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlLine;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlOLE;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlObjectLinkLine;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPicture;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlTextArt;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.caption.Caption;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.bookmark.ForCtrlData;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlArc;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlContainer;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlCurve;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlEllipse;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlLine;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlOLE;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlObjectLinkLine;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlPicture;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlPolygon;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlRectangle;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.ForControlTextArt;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.part.ForCaption;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.part.ForCtrlHeaderGso;
import kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.part.ForShapeComponent;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForGsoControl {
    private Paragraph paragraph;
    private StreamReader sr;
    private GsoControl gsoControl;
    private CtrlHeaderGso header;
    private Caption caption;
    private CtrlData ctrlData;

    public void read(Paragraph paragraph, StreamReader sr) throws Exception {
        this.paragraph = paragraph;
        this.sr = sr;
        this.ctrlHeader();
        this.captionAndCtrlData(sr);
        long gsoId = this.gsoIDFromShapeComponent();
        this.gsoControl = this.createGsoControl(gsoId);
        this.restPartOfShapeComponent();
        this.restPartOfControl();
    }

    private void ctrlHeader() throws IOException {
        this.header = new CtrlHeaderGso();
        ForCtrlHeaderGso.read(this.header, this.sr);
    }

    private void captionAndCtrlData(StreamReader sr) throws Exception {
        this.caption = null;
        this.ctrlData = null;
        sr.readRecordHeader();
        while (sr.getCurrentRecordHeader().getTagID() != 76) {
            if (sr.getCurrentRecordHeader().getTagID() == 72) {
                this.caption = new Caption();
                ForCaption.read(this.caption, sr);
                if (sr.isImmediatelyAfterReadingHeader()) continue;
                sr.readRecordHeader();
                continue;
            }
            if (sr.getCurrentRecordHeader().getTagID() != 87) continue;
            this.ctrlData = new CtrlData();
            ForCtrlData.read(this.ctrlData, sr);
            if (sr.isImmediatelyAfterReadingHeader()) continue;
            sr.readRecordHeader();
        }
    }

    private long gsoIDFromShapeComponent() throws Exception {
        if (!this.sr.isImmediatelyAfterReadingHeader()) {
            this.sr.readRecordHeader();
        }
        if (this.sr.getCurrentRecordHeader().getTagID() == 76) {
            long id = this.sr.readUInt4();
            this.sr.skip(4);
            return id;
        }
        throw new Exception("Shape Component must come after CtrlHeader for gso control.");
    }

    private GsoControl createGsoControl(long gsoId) {
        GsoControl gc = this.paragraph.addNewGsoControl(gsoId, this.header);
        gc.setCaption(this.caption);
        gc.setCtrlData(this.ctrlData);
        return gc;
    }

    private void restPartOfShapeComponent() throws IOException {
        ForShapeComponent.read(this.gsoControl, this.sr);
    }

    private void restPartOfControl() throws Exception {
        switch (this.gsoControl.getGsoType()) {
            case Line: {
                ForControlLine.readRest((ControlLine)this.gsoControl, this.sr);
                break;
            }
            case Rectangle: {
                ForControlRectangle.readRest((ControlRectangle)this.gsoControl, this.sr);
                break;
            }
            case Ellipse: {
                ForControlEllipse.readRest((ControlEllipse)this.gsoControl, this.sr);
                break;
            }
            case Arc: {
                ForControlArc.readRest((ControlArc)this.gsoControl, this.sr);
                break;
            }
            case Polygon: {
                ForControlPolygon.readRest((ControlPolygon)this.gsoControl, this.sr);
                break;
            }
            case Curve: {
                ForControlCurve.readRest((ControlCurve)this.gsoControl, this.sr);
                break;
            }
            case Picture: {
                ForControlPicture.readRest((ControlPicture)this.gsoControl, this.sr);
                break;
            }
            case OLE: {
                ForControlOLE.readRest((ControlOLE)this.gsoControl, this.sr);
                break;
            }
            case Container: {
                ForControlContainer.readRest((ControlContainer)this.gsoControl, this.sr);
                break;
            }
            case ObjectLinkLine: {
                ForControlObjectLinkLine.readRest((ControlObjectLinkLine)this.gsoControl, this.sr);
                break;
            }
            case TextArt: {
                ForControlTextArt.readRest((ControlTextArt)this.gsoControl, this.sr);
            }
        }
    }

    public GsoControl readInContainer(StreamReader sr) throws Exception {
        this.sr = sr;
        this.shapeComponentInContainer();
        this.restPartOfControl();
        return this.gsoControl;
    }

    private void shapeComponentInContainer() throws Exception {
        this.sr.readRecordHeader();
        if (this.sr.getCurrentRecordHeader().getTagID() != 76) {
            throw new Exception("Shape Component must come after CtrlHeader for gso control.");
        }
        long id = this.sr.readUInt4();
        this.gsoControl = FactoryForControl.createGso(id, null);
        ForShapeComponent.read(this.gsoControl, this.sr);
    }
}

