/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.reader.bodytext.paragraph.control.gso.part;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.ColorEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.ColorEffectSort;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.ColorWithEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.NeonEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.PictureEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.ReflectionEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.ShadowEffect;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponenteach.picture.SoftEdgeEffect;
import kr.dogfoot.hwplib.util.compoundFile.reader.StreamReader;

public class ForPictureEffect {
    public static void read(PictureEffect pe, StreamReader sr) throws Exception {
        pe.getProperty().setValue(sr.readUInt4());
        if (pe.getProperty().hasShadowEffect()) {
            pe.createShadowEffect();
            ForPictureEffect.shadowEffect(pe.getShadowEffect(), sr);
        }
        if (pe.getProperty().hasNeonEffect()) {
            pe.createNeonEffect();
            ForPictureEffect.neonEffect(pe.getNeonEffect(), sr);
        }
        if (pe.getProperty().hasSoftBorderEffect()) {
            pe.createSoftEdgeEffect();
            ForPictureEffect.softEdgeEffect(pe.getSoftEdgeEffect(), sr);
        }
        if (pe.getProperty().hasReflectionEffect()) {
            pe.createReflectionEffect();
            ForPictureEffect.reflectionEffect(pe.getReflectionEffect(), sr);
        }
    }

    private static void shadowEffect(ShadowEffect se, StreamReader sr) throws Exception {
        se.setStyle(sr.readSInt4());
        se.setTransparency(sr.readFloat());
        se.setCloudy(sr.readFloat());
        se.setDirection(sr.readFloat());
        se.setDistance(sr.readFloat());
        se.setSort(sr.readSInt4());
        se.setTiltAngleX(sr.readFloat());
        se.setTiltAngleY(sr.readFloat());
        se.setZoomRateX(sr.readFloat());
        se.setZoomRateY(sr.readFloat());
        se.setRotateWithShape(sr.readSInt4());
        ForPictureEffect.colorProperty(se.getColor(), sr);
    }

    private static void colorProperty(ColorWithEffect cp, StreamReader sr) throws Exception {
        cp.setType(sr.readSInt4());
        if (cp.getType() != 0) {
            throw new Exception("not supported color type !!!");
        }
        byte[] color = new byte[4];
        sr.readBytes(color);
        cp.setColor(color);
        int colorEffectCount = (int)sr.readUInt4();
        for (int index = 0; index < colorEffectCount; ++index) {
            ColorEffect ce = cp.addNewColorEffect();
            ce.setSort(ColorEffectSort.valueOf(sr.readSInt4()));
            ce.setValue(sr.readFloat());
        }
    }

    private static void neonEffect(NeonEffect ne, StreamReader sr) throws Exception {
        ne.setTransparency(sr.readFloat());
        ne.setRadius(sr.readFloat());
        ForPictureEffect.colorProperty(ne.getColor(), sr);
    }

    private static void softEdgeEffect(SoftEdgeEffect see, StreamReader sr) throws IOException {
        see.setRadius(sr.readFloat());
    }

    private static void reflectionEffect(ReflectionEffect re, StreamReader sr) throws IOException {
        re.setStyle(sr.readSInt4());
        re.setRadius(sr.readFloat());
        re.setDirection(sr.readFloat());
        re.setDistance(sr.readFloat());
        re.setTiltAngleX(sr.readFloat());
        re.setTiltAngleY(sr.readFloat());
        re.setZoomRateX(sr.readFloat());
        re.setZoomRateY(sr.readFloat());
        re.setRotationStyle(sr.readSInt4());
        re.setStartTransparency(sr.readFloat());
        re.setStartPosition(sr.readFloat());
        re.setEndTransparency(sr.readFloat());
        re.setEndPosition(sr.readFloat());
        re.setOffsetDirection(sr.readFloat());
    }
}

