/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool;

import java.util.Vector;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.ListHeaderForCell;
import kr.dogfoot.hwplib.object.bodytext.control.table.Row;

public class TableCellMerger {
    private ControlTable table;
    private int startRow;
    private int startCol;
    private int rowSpan;
    private int colSpan;
    private boolean check;

    public static boolean mergeCell(ControlTable table, int startRow, int startCol, int rowSpan, int colSpan) {
        TableCellMerger merger = new TableCellMerger(table, startRow, startCol, rowSpan, colSpan, true);
        return merger.merge();
    }

    public static boolean mergeCellWithoutCheck(ControlTable table, int startRow, int startCol, int rowSpan, int colSpan) {
        TableCellMerger merger = new TableCellMerger(table, startRow, startCol, rowSpan, colSpan, false);
        return merger.merge();
    }

    private TableCellMerger(ControlTable table, int startRow, int startCol, int rowSpan, int colSpan, boolean check) {
        this.table = table;
        this.startRow = startRow;
        this.startCol = startCol;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.check = check;
    }

    private boolean merge() {
        boolean possible = !this.check ? true : this.possible();
        if (possible) {
            this.resetMergedCell();
            this.removeRestCell();
            this.resetCellCountOfRow();
            return true;
        }
        return false;
    }

    private boolean possible() {
        return this.isInTable() && this.checkAreaLeft() && this.checkAreaTop() && this.checkAreaRight() && this.checkAreaBottom();
    }

    private boolean isInTable() {
        return 0 <= this.startRow && this.getEndRow() < this.table.getTable().getRowCount() && 0 <= this.startCol && this.getEndCol() < this.table.getTable().getColumnCount();
    }

    private int getEndRow() {
        return this.startRow + this.rowSpan - 1;
    }

    private int getEndCol() {
        return this.startCol + this.colSpan - 1;
    }

    private boolean checkAreaLeft() {
        for (int rowIndex = this.startRow; rowIndex <= this.getEndRow(); ++rowIndex) {
            Cell cell = this.findCell(rowIndex, this.startCol);
            if (cell == null) {
                return false;
            }
            ListHeaderForCell lhc = cell.getListHeader();
            if (lhc.getColIndex() == this.startCol) continue;
            return false;
        }
        return true;
    }

    private Cell findCell(int rowIndex, int colIndex) {
        for (Row row : this.table.getRowList()) {
            for (Cell cell : row.getCellList()) {
                ListHeaderForCell lhc = cell.getListHeader();
                if (lhc.getRowIndex() > rowIndex || rowIndex > lhc.getRowIndex() + lhc.getRowSpan() - 1 || lhc.getColIndex() > colIndex || colIndex > lhc.getColIndex() + lhc.getColSpan() - 1) continue;
                return cell;
            }
        }
        return null;
    }

    private boolean checkAreaTop() {
        for (int colIndex = this.startCol; colIndex <= this.getEndCol(); ++colIndex) {
            Cell cell = this.findCell(this.startRow, colIndex);
            if (cell == null) {
                return false;
            }
            ListHeaderForCell lhc = cell.getListHeader();
            if (lhc.getRowIndex() == this.startRow) continue;
            return false;
        }
        return true;
    }

    private boolean checkAreaRight() {
        for (int rowIndex = this.startRow; rowIndex <= this.getEndRow(); ++rowIndex) {
            Cell cell = this.findCell(rowIndex, this.getEndCol());
            if (cell == null) {
                return false;
            }
            ListHeaderForCell lhc = cell.getListHeader();
            if (lhc.getColIndex() + lhc.getRowSpan() - 1 == this.getEndCol()) continue;
            return false;
        }
        return true;
    }

    private boolean checkAreaBottom() {
        for (int colIndex = this.startCol; colIndex <= this.getEndCol(); ++colIndex) {
            Cell cell = this.findCell(this.getEndRow(), colIndex);
            if (cell == null) {
                return false;
            }
            ListHeaderForCell lhc = cell.getListHeader();
            if (lhc.getRowIndex() + lhc.getRowSpan() - 1 == this.getEndRow()) continue;
            return false;
        }
        return true;
    }

    private void resetMergedCell() {
        Cell cell = this.findCell(this.startRow, this.startCol);
        ListHeaderForCell lhc = cell.getListHeader();
        lhc.setRowSpan(this.rowSpan);
        lhc.setColSpan(this.colSpan);
        lhc.setWidth(this.getMergedWidth());
        lhc.setHeight(this.getMergedHeight());
    }

    private long getMergedWidth() {
        int width = 0;
        Row row = this.table.getRowList().get(this.startRow);
        for (Cell cell : row.getCellList()) {
            ListHeaderForCell lhc = cell.getListHeader();
            if (this.startCol > lhc.getColIndex() || lhc.getColIndex() > this.getEndCol()) continue;
            width = (int)((long)width + lhc.getWidth());
        }
        return width;
    }

    private int getMergedHeight() {
        int height = 0;
        for (int rowIndex = this.startRow; rowIndex <= this.getEndRow(); ++rowIndex) {
            Row row = this.table.getRowList().get(rowIndex);
            for (Cell cell : row.getCellList()) {
                ListHeaderForCell lhc = cell.getListHeader();
                if (lhc.getColIndex() != this.startCol) continue;
                height = (int)((long)height + lhc.getHeight());
            }
        }
        return height;
    }

    private void removeRestCell() {
        Vector<Cell> removeCells = new Vector<Cell>();
        for (int rowIndex = this.startRow; rowIndex <= this.getEndRow(); ++rowIndex) {
            Row row = this.table.getRowList().get(rowIndex);
            for (Cell cell : row.getCellList()) {
                ListHeaderForCell lhc = cell.getListHeader();
                if (lhc.getRowIndex() == this.startRow && lhc.getColIndex() == this.startCol || lhc.getColIndex() < this.startCol || lhc.getColIndex() + lhc.getColSpan() - 1 > this.getEndCol()) continue;
                removeCells.add(cell);
            }
            for (Cell c : removeCells) {
                row.getCellList().remove(c);
            }
            removeCells.clear();
        }
    }

    private void resetCellCountOfRow() {
        this.table.getTable().getCellCountOfRowList().clear();
        int rowCount = this.table.getRowList().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            int cellCount = this.table.getRowList().get(rowIndex).getCellList().size();
            this.table.getTable().addCellCountOfRow(cellCount);
        }
    }
}

