/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.blankfilemaker;

import kr.dogfoot.hwplib.object.HWPFile;
import kr.dogfoot.hwplib.object.bodytext.Section;
import kr.dogfoot.hwplib.object.docinfo.DocInfo;
import kr.dogfoot.hwplib.object.docinfo.DocumentProperties;
import kr.dogfoot.hwplib.object.docinfo.LayoutCompatibility;
import kr.dogfoot.hwplib.object.docinfo.compatibledocument.CompatibleDocumentSort;
import kr.dogfoot.hwplib.object.docinfo.documentproperties.CaretPosition;
import kr.dogfoot.hwplib.object.docinfo.documentproperties.StartNumber;
import kr.dogfoot.hwplib.object.fileheader.FileHeader;
import kr.dogfoot.hwplib.tool.blankfilemaker.BorderFillAdder;
import kr.dogfoot.hwplib.tool.blankfilemaker.CharShapeAdder;
import kr.dogfoot.hwplib.tool.blankfilemaker.EmptyParagraphAdder;
import kr.dogfoot.hwplib.tool.blankfilemaker.FaceNameAdder;
import kr.dogfoot.hwplib.tool.blankfilemaker.NumberingAdder;
import kr.dogfoot.hwplib.tool.blankfilemaker.ParaShapeAdder;
import kr.dogfoot.hwplib.tool.blankfilemaker.StyleAdder;
import kr.dogfoot.hwplib.tool.blankfilemaker.TabDefAdder;

public class BlankFileMaker {
    public static HWPFile make() {
        HWPFile hwpFile = new HWPFile();
        BlankFileMaker.setFileHeader(hwpFile.getFileHeader());
        DocInfo docInfo = hwpFile.getDocInfo();
        BlankFileMaker.setDocumentProperties(docInfo.getDocumentProperties());
        FaceNameAdder.add(docInfo);
        BorderFillAdder.add(docInfo);
        CharShapeAdder.add(docInfo);
        TabDefAdder.add(docInfo);
        NumberingAdder.add(docInfo);
        ParaShapeAdder.add(docInfo);
        StyleAdder.add(docInfo);
        BlankFileMaker.compatibleDocument(docInfo);
        BlankFileMaker.layoutCompatibility(docInfo);
        Section section = hwpFile.getBodyText().addNewSection();
        EmptyParagraphAdder.add(section);
        BlankFileMaker.setScript(hwpFile);
        return hwpFile;
    }

    private static void setFileHeader(FileHeader fileHeader) {
        fileHeader.getVersion().setVersion((short)5, (short)0, (short)3, (short)4);
        fileHeader.setCompressed(true);
        fileHeader.setHasPassword(false);
        fileHeader.setDistribution(false);
        fileHeader.setSaveScript(false);
        fileHeader.setDRMDocument(false);
        fileHeader.setHasXMLTemplate(false);
        fileHeader.setHasDocumentHistory(false);
        fileHeader.setHasSignature(false);
        fileHeader.setEncryptPublicCertification(false);
        fileHeader.setSavePrepareSignature(false);
        fileHeader.setPublicCertificationDRMDocument(false);
        fileHeader.setCCLDocument(false);
    }

    private static void setDocumentProperties(DocumentProperties documentProperties) {
        documentProperties.setSectionCount(1);
        StartNumber startNumber = documentProperties.getStartNumber();
        startNumber.setPage(1);
        startNumber.setFootnote(1);
        startNumber.setEndnote(1);
        startNumber.setPicture(1);
        startNumber.setTable(1);
        startNumber.setEquation(1);
        CaretPosition caretPosition = documentProperties.getCaretPosition();
        caretPosition.setListID(0L);
        caretPosition.setParagraphID(0L);
        caretPosition.setPositionInParagraph(0L);
    }

    private static void compatibleDocument(DocInfo docInfo) {
        docInfo.createCompatibleDocument();
        docInfo.getCompatibleDocument().setTargetProgream(CompatibleDocumentSort.HWPCurrent);
    }

    private static void layoutCompatibility(DocInfo docInfo) {
        docInfo.createLayoutCompatibility();
        LayoutCompatibility layoutCompatibility = docInfo.getLayoutCompatibility();
        layoutCompatibility.setLetterLevelFormat(0L);
        layoutCompatibility.setParagraphLevelFormat(0L);
        layoutCompatibility.setSectionLevelFormat(0L);
        layoutCompatibility.setObjectLevelFormat(0L);
        layoutCompatibility.setFieldLevelFormat(0L);
    }

    private static void setScript(HWPFile hwpFile) {
        byte[] compressed_jsVersion = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
        hwpFile.getScripts().setJScriptVersion(compressed_jsVersion);
        byte[] compressed_defaultJScript = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1};
        hwpFile.getScripts().setDefaultJScript(compressed_defaultJScript);
    }
}

