/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder.fieldform;

import java.util.ArrayList;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlForm;
import kr.dogfoot.hwplib.object.bodytext.control.ControlTable;
import kr.dogfoot.hwplib.object.bodytext.control.form.FormObjectType;
import kr.dogfoot.hwplib.object.bodytext.control.form.properties.PropertyNormal;
import kr.dogfoot.hwplib.object.bodytext.control.form.properties.PropertySet;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.textbox.TextBox;
import kr.dogfoot.hwplib.object.bodytext.control.table.Cell;
import kr.dogfoot.hwplib.object.bodytext.control.table.Row;
import kr.dogfoot.hwplib.object.bodytext.paragraph.ParagraphList;
import kr.dogfoot.hwplib.tool.objectfinder.fieldform.FieldData;
import kr.dogfoot.hwplib.tool.objectfinder.fieldform.FieldFormFinder;
import kr.dogfoot.hwplib.tool.objectfinder.fieldform.FieldType;
import kr.dogfoot.hwplib.tool.objectfinder.fieldform.FormData;

public class ForControl {
    public static void findInControlList(ArrayList<Control> controlList, FieldFormFinder.Result result, FieldFormFinder.Option option) throws FieldFormFinder.StopFindException {
        if (option.nameToFind() != null && option.onlyFirst() && result.added()) {
            throw new FieldFormFinder.StopFindException();
        }
        for (Control control : controlList) {
            ForControl.findInControl(control, result, option);
        }
    }

    private static void findInControl(Control control, FieldFormFinder.Result result, FieldFormFinder.Option option) throws FieldFormFinder.StopFindException {
        switch (control.getType()) {
            case Table: {
                ForControl.findInTable((ControlTable)control, result, option);
                break;
            }
            case Gso: {
                ForControl.findInGso((GsoControl)control, result, option);
                break;
            }
            case Form: {
                if (!option.findForm()) break;
                ForControl.findInForm((ControlForm)control, result, option);
            }
        }
    }

    private static void findInTable(ControlTable table, FieldFormFinder.Result result, FieldFormFinder.Option option) throws FieldFormFinder.StopFindException {
        for (Row row : table.getRowList()) {
            for (Cell cell : row.getCellList()) {
                String fieldName;
                if (option.findCell() && (fieldName = cell.getListHeader().getFieldName()) != null && fieldName.length() > 0) {
                    if (option.nameToFind() != null) {
                        if (option.nameToFind().equals(fieldName)) {
                            result.addFieldData(ForControl.fieldDataForAllParagraphs(fieldName, FieldType.Cell, cell, cell.getParagraphList()));
                            if (option.onlyFirst()) {
                                throw new FieldFormFinder.StopFindException();
                            }
                        }
                    } else {
                        result.addFieldData(ForControl.fieldDataForAllParagraphs(fieldName, FieldType.Cell, cell, cell.getParagraphList()));
                    }
                }
                FieldFormFinder.findInParagraphList(cell.getParagraphList(), result, option);
            }
        }
    }

    private static FieldData fieldDataForAllParagraphs(String fieldName, FieldType fieldType, Object parent, ParagraphList paragraphList) {
        FieldData fieldData = new FieldData(fieldName, fieldType, parent, paragraphList);
        fieldData.setStartPosition(0, 0);
        fieldData.setEndPosition(paragraphList.getParagraphCount() - 1, 65535);
        return fieldData;
    }

    private static void findInGso(GsoControl control, FieldFormFinder.Result result, FieldFormFinder.Option option) throws FieldFormFinder.StopFindException {
        switch (control.getGsoType()) {
            case Rectangle: {
                ForControl.findInTextBox(control, ((ControlRectangle)control).getTextBox(), result, option);
                break;
            }
            case Ellipse: {
                ForControl.findInTextBox(control, ((ControlEllipse)control).getTextBox(), result, option);
                break;
            }
            case Arc: {
                ForControl.findInTextBox(control, ((ControlArc)control).getTextBox(), result, option);
                break;
            }
            case Polygon: {
                ForControl.findInTextBox(control, ((ControlPolygon)control).getTextBox(), result, option);
                break;
            }
            case Curve: {
                ForControl.findInTextBox(control, ((ControlCurve)control).getTextBox(), result, option);
                break;
            }
            case Container: {
                ForControl.findInContainer((ControlContainer)control, result, option);
            }
        }
    }

    private static void findInTextBox(GsoControl control, TextBox textBox, FieldFormFinder.Result result, FieldFormFinder.Option option) throws FieldFormFinder.StopFindException {
        String fieldName;
        if (textBox == null) {
            return;
        }
        if (option.findGso() && (fieldName = textBox.getListHeader().getFieldName()) != null && fieldName.length() > 0) {
            if (option.nameToFind() != null) {
                if (option.nameToFind().equals(fieldName)) {
                    result.addFieldData(ForControl.fieldDataForAllParagraphs(fieldName, FieldType.Gso, control, textBox.getParagraphList()));
                    if (option.onlyFirst()) {
                        throw new FieldFormFinder.StopFindException();
                    }
                }
            } else {
                result.addFieldData(ForControl.fieldDataForAllParagraphs(fieldName, FieldType.Gso, control, textBox.getParagraphList()));
            }
        }
        FieldFormFinder.findInParagraphList(textBox.getParagraphList(), result, option);
    }

    private static void findInContainer(ControlContainer container, FieldFormFinder.Result result, FieldFormFinder.Option option) throws FieldFormFinder.StopFindException {
        for (GsoControl childControl : container.getChildControlList()) {
            ForControl.findInGso(childControl, result, option);
        }
    }

    private static void findInForm(ControlForm form, FieldFormFinder.Result result, FieldFormFinder.Option option) throws FieldFormFinder.StopFindException {
        if (form.getFormObject().getType() == FormObjectType.RadioButton || form.getFormObject().getType() == FormObjectType.CheckBox) {
            PropertySet commonSet = (PropertySet)form.getFormObject().getProperties().getProperty("CommonSet");
            PropertyNormal name = (PropertyNormal)commonSet.getProperty("Name");
            PropertySet buttonSet = (PropertySet)form.getFormObject().getProperties().getProperty("ButtonSet");
            PropertyNormal value = (PropertyNormal)buttonSet.getProperty("Value");
            if (option.nameToFind() != null) {
                if (option.nameToFind().equals(name.getValue())) {
                    result.addFormData(new FormData(name.getValue(), form.getFormObject().getType(), value.getValue()));
                    if (option.onlyFirst()) {
                        throw new FieldFormFinder.StopFindException();
                    }
                }
            } else {
                result.addFormData(new FormData(name.getValue(), form.getFormObject().getType(), value.getValue()));
            }
        }
    }
}

