/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder.forField;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import kr.dogfoot.hwplib.object.bodytext.ParagraphListInterface;
import kr.dogfoot.hwplib.object.bodytext.control.Control;
import kr.dogfoot.hwplib.object.bodytext.control.ControlField;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.tool.objectfinder.SetFieldResult;
import kr.dogfoot.hwplib.tool.objectfinder.TextBuffer;
import kr.dogfoot.hwplib.tool.objectfinder.forField.gettext.ForControlWithAllField;
import kr.dogfoot.hwplib.tool.objectfinder.forField.settext.ForControl;
import kr.dogfoot.hwplib.tool.paragraphadder.ParaTextSetter;
import kr.dogfoot.hwplib.tool.textextractor.ForParagraph;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractMethod;

public class ForParagraphList {
    public static String getFieldText(ParagraphListInterface paragraphList, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        if (paragraphList == null) {
            return null;
        }
        ArrayList<FindPosition> results = ForParagraphList.getFieldStartPosition(paragraphList, fieldType, fieldName, false);
        if (results.size() > 0 && ForParagraphList.getFieldEndPosition(paragraphList, results.get(0))) {
            return ForParagraphList.getText(paragraphList, results.get(0), temInField);
        }
        return ForParagraphList.getFieldTextForControl(paragraphList, fieldType, fieldName, temInField);
    }

    private static ArrayList<FindPosition> getFieldStartPosition(ParagraphListInterface paragraphList, ControlType fieldType, String fieldName, boolean allField) {
        ArrayList<FindPosition> results = new ArrayList<FindPosition>();
        int paraCount = paragraphList.getParagraphCount();
        for (int paraIndex = 0; paraIndex < paraCount; ++paraIndex) {
            Paragraph p = paragraphList.getParagraph(paraIndex);
            int fieldCharIndex = ForParagraphList.findFieldCharIndex(p, fieldType, fieldName, -1);
            if (fieldCharIndex == -1) continue;
            results.add(new FindPosition(paraIndex, fieldCharIndex));
            if (allField) continue;
            return results;
        }
        return results;
    }

    private static FindPosition getFieldStartPosition(ParagraphListInterface paragraphList, ControlType fieldType, String fieldName, int startParaIndex, int startCharIndex) {
        int paraCount = paragraphList.getParagraphCount();
        for (int paraIndex = startParaIndex; paraIndex < paraCount; ++paraIndex) {
            int fieldCharIndex;
            Paragraph p = paragraphList.getParagraph(paraIndex);
            int sci = startCharIndex;
            if (paraIndex != startParaIndex) {
                sci = 0;
            }
            if ((fieldCharIndex = ForParagraphList.findFieldCharIndex(p, fieldType, fieldName, sci)) == -1) continue;
            return new FindPosition(paraIndex, fieldCharIndex);
        }
        return null;
    }

    private static int findFieldCharIndex(Paragraph p, ControlType fieldType, String fieldName, int startCharIndex) {
        if (p.getControlList() == null) {
            return -1;
        }
        int ctrlCount = p.getControlList().size();
        for (int ctrlIndex = 0; ctrlIndex < ctrlCount; ++ctrlIndex) {
            ControlField cf;
            Control c = p.getControlList().get(ctrlIndex);
            if (c.getType() != fieldType || (cf = (ControlField)c).getName() == null || !cf.getName().equals(fieldName)) continue;
            int charIndex = p.getText().getCharIndexFromExtendCharIndex(ctrlIndex);
            if (charIndex == -1) {
                return charIndex;
            }
            if (startCharIndex >= 0 && charIndex < startCharIndex) continue;
            return charIndex;
        }
        return -1;
    }

    private static boolean getFieldEndPosition(ParagraphListInterface paragraphList, FindPosition position) {
        int depth = 0;
        int paraCount = paragraphList.getParagraphCount();
        for (int paraIndex = position.startParaIndex; paraIndex < paraCount; ++paraIndex) {
            Paragraph p = paragraphList.getParagraph(paraIndex);
            if (p.getText() == null) continue;
            int startIndex = paraIndex == position.startParaIndex ? position.startCharIndex + 1 : 0;
            int charCount = p.getText().getCharList().size();
            for (int charIndex = startIndex; charIndex < charCount; ++charIndex) {
                HWPChar hwpChar = p.getText().getCharList().get(charIndex);
                if (hwpChar.getCode() == 3) {
                    ++depth;
                    continue;
                }
                if (hwpChar.getCode() != 4) continue;
                if (depth == 0) {
                    position.endPosition(paraIndex, charIndex);
                    return true;
                }
                --depth;
            }
        }
        return false;
    }

    private static String getText(ParagraphListInterface paragraphList, FindPosition position, TextExtractMethod temInField) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        for (int paraIndex = position.startParaIndex; paraIndex <= position.endParaIndex; ++paraIndex) {
            int startCharIndex;
            int n = startCharIndex = paraIndex == position.startParaIndex ? position.startCharIndex : 0;
            int endCharIndex = paraIndex == position.endParaIndex ? position.endCharIndex : (paragraphList.getParagraph(paraIndex).getText() == null ? 0 : paragraphList.getParagraph(paraIndex).getText().getCharList().size());
            ForParagraph.extract(paragraphList.getParagraph(paraIndex), startCharIndex, endCharIndex, temInField, null, sb);
        }
        return sb.toString();
    }

    private static String getFieldTextForControl(ParagraphListInterface paragraphList, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        for (Paragraph p : paragraphList) {
            ArrayList<Control> controlList = p.getControlList();
            if (controlList == null) continue;
            for (Control c : controlList) {
                String text = kr.dogfoot.hwplib.tool.objectfinder.forField.gettext.ForControl.getFieldText(c, fieldType, fieldName, temInField);
                if (text == null) continue;
                return text;
            }
        }
        return null;
    }

    public static void getAllFieldText(ParagraphListInterface paragraphList, ControlType fieldType, String fieldName, TextExtractMethod temInField, ArrayList<String> textList) throws UnsupportedEncodingException {
        if (paragraphList == null) {
            return;
        }
        ArrayList<FindPosition> results = ForParagraphList.getFieldStartPosition(paragraphList, fieldType, fieldName, true);
        for (FindPosition result : results) {
            if (!ForParagraphList.getFieldEndPosition(paragraphList, result)) continue;
            textList.add(ForParagraphList.getText(paragraphList, result, temInField));
        }
        ForParagraphList.getAllFieldTextForControl(paragraphList, fieldType, fieldName, temInField, textList);
    }

    private static void getAllFieldTextForControl(ParagraphListInterface paragraphList, ControlType fieldType, String fieldName, TextExtractMethod temInField, ArrayList<String> textList) throws UnsupportedEncodingException {
        for (Paragraph p : paragraphList) {
            ArrayList<Control> controlList = p.getControlList();
            if (controlList == null) continue;
            for (Control c : controlList) {
                ForControlWithAllField.getFieldText(c, fieldType, fieldName, temInField, textList);
            }
        }
    }

    public static SetFieldResult setFieldText(ParagraphListInterface paragraphList, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        if (paragraphList == null) {
            return SetFieldResult.InProcess;
        }
        FindPosition result = ForParagraphList.getFieldStartPosition(paragraphList, fieldType, fieldName, 0, 0);
        while (result != null) {
            if (ForParagraphList.getFieldEndPosition(paragraphList, result)) {
                if (textBuffer.hasNext()) {
                    ForParagraphList.changeText(paragraphList, result, textBuffer.nextText());
                    ForParagraphList.deleteLineSeg(paragraphList, result);
                } else {
                    return SetFieldResult.NotEnoughText;
                }
            }
            result = ForParagraphList.getFieldStartPosition(paragraphList, fieldType, fieldName, result.endParaIndex, result.endCharIndex + 1);
        }
        return ForParagraphList.setFieldTextForControls(paragraphList, fieldType, fieldName, textBuffer);
    }

    private static void changeText(ParagraphListInterface paragraphList, FindPosition position, String text) throws UnsupportedEncodingException {
        if (position.startParaIndex != position.endParaIndex) {
            Paragraph startPara = paragraphList.getParagraph(position.startParaIndex);
            ParaTextSetter.deleteParaTextFrom(startPara, position.startCharIndex + 1);
            startPara.getText().addString(text);
            Paragraph endPara = paragraphList.getParagraph(position.endParaIndex);
            ParaTextSetter.deleteParaTextTo(endPara, position.endCharIndex - 1);
            ParaTextSetter.mergeParagraph(startPara, endPara);
            paragraphList.deleteParagraph(position.endParaIndex);
            if (position.endParaIndex - position.startParaIndex >= 2) {
                for (int deleteIndex = 0; deleteIndex < position.endParaIndex - position.startParaIndex - 1; ++deleteIndex) {
                    paragraphList.deleteParagraph(position.startParaIndex + 1);
                }
            }
        } else {
            Paragraph para = paragraphList.getParagraph(position.startParaIndex);
            ParaTextSetter.changeText(para, position.startCharIndex + 1, position.endCharIndex - 1, text);
        }
        FindPosition nextPosition = new FindPosition(position.startParaIndex, position.startCharIndex + 1);
        if (ForParagraphList.getFieldEndPosition(paragraphList, nextPosition)) {
            position.endPosition(nextPosition.endParaIndex, nextPosition.endCharIndex);
        }
    }

    private static void deleteLineSeg(ParagraphListInterface paragraphList, FindPosition result) {
        for (int paraIndex = result.startParaIndex; paraIndex <= result.endParaIndex; ++paraIndex) {
            paragraphList.getParagraph(paraIndex).deleteLineSeg();
        }
    }

    private static SetFieldResult setFieldTextForControls(ParagraphListInterface paragraphList, ControlType fieldType, String fieldName, TextBuffer textBuffer) throws UnsupportedEncodingException {
        for (Paragraph p : paragraphList) {
            ArrayList<Control> controlList = p.getControlList();
            if (controlList == null) continue;
            for (Control c : controlList) {
                if (ForControl.setFieldText(c, fieldType, fieldName, textBuffer) != SetFieldResult.NotEnoughText) continue;
                return SetFieldResult.NotEnoughText;
            }
        }
        return SetFieldResult.InProcess;
    }

    private static class FindPosition {
        int startParaIndex;
        int startCharIndex;
        int endParaIndex;
        int endCharIndex;

        public FindPosition(int startParaIndex, int startCharIndex) {
            this.startParaIndex = startParaIndex;
            this.startCharIndex = startCharIndex;
        }

        public void endPosition(int endParaIndex, int endCharIndex) {
            this.endParaIndex = endParaIndex;
            this.endCharIndex = endCharIndex;
        }

        public String toString() {
            return this.startParaIndex + ":" + this.startCharIndex + " ~ " + this.endParaIndex + ":" + this.endCharIndex;
        }
    }
}

