/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.objectfinder.forField.gettext;

import java.io.UnsupportedEncodingException;
import kr.dogfoot.hwplib.object.bodytext.control.ControlType;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlArc;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlContainer;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlCurve;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlEllipse;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlPolygon;
import kr.dogfoot.hwplib.object.bodytext.control.gso.ControlRectangle;
import kr.dogfoot.hwplib.object.bodytext.control.gso.GsoControl;
import kr.dogfoot.hwplib.object.bodytext.control.gso.textbox.TextBox;
import kr.dogfoot.hwplib.tool.objectfinder.forField.ForParagraphList;
import kr.dogfoot.hwplib.tool.textextractor.TextExtractMethod;

public class ForGso {
    public static String getFieldText(GsoControl gc, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        switch (gc.getGsoType()) {
            case Line: {
                break;
            }
            case Rectangle: {
                return ForGso.rectangle((ControlRectangle)gc, fieldType, fieldName, temInField);
            }
            case Ellipse: {
                return ForGso.ellipse((ControlEllipse)gc, fieldType, fieldName, temInField);
            }
            case Arc: {
                return ForGso.arc((ControlArc)gc, fieldType, fieldName, temInField);
            }
            case Polygon: {
                return ForGso.polygon((ControlPolygon)gc, fieldType, fieldName, temInField);
            }
            case Curve: {
                return ForGso.curve((ControlCurve)gc, fieldType, fieldName, temInField);
            }
            case Picture: {
                break;
            }
            case OLE: {
                break;
            }
            case Container: {
                return ForGso.container((ControlContainer)gc, fieldType, fieldName, temInField);
            }
        }
        return null;
    }

    private static String rectangle(ControlRectangle rectangle, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForGso.textBox(rectangle.getTextBox(), fieldType, fieldName, temInField);
    }

    private static String textBox(TextBox textBox, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        if (textBox == null) {
            return null;
        }
        return ForParagraphList.getFieldText(textBox.getParagraphList(), fieldType, fieldName, temInField);
    }

    private static String ellipse(ControlEllipse ellipse, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForGso.textBox(ellipse.getTextBox(), fieldType, fieldName, temInField);
    }

    private static String arc(ControlArc arc, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForGso.textBox(arc.getTextBox(), fieldType, fieldName, temInField);
    }

    private static String polygon(ControlPolygon polygon, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForGso.textBox(polygon.getTextBox(), fieldType, fieldName, temInField);
    }

    private static String curve(ControlCurve curve, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        return ForGso.textBox(curve.getTextBox(), fieldType, fieldName, temInField);
    }

    private static String container(ControlContainer container, ControlType fieldType, String fieldName, TextExtractMethod temInField) throws UnsupportedEncodingException {
        for (GsoControl child : container.getChildControlList()) {
            String text = ForGso.getFieldText(child, fieldType, fieldName, temInField);
            if (text == null) continue;
            return text;
        }
        return null;
    }
}

