/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder;

import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlExtend;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlInline;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharNormal;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.ParaText;

public class ParaTextCopier {
    public static boolean copy(ParaText source, ParaText target, boolean includingSectionDefine) throws Exception {
        boolean excludedSectionDefine = false;
        for (HWPChar hwpChar : source.getCharList()) {
            switch (hwpChar.getType()) {
                case Normal: {
                    ParaTextCopier.copyNormalChar((HWPCharNormal)hwpChar, target.addNewNormalChar());
                    break;
                }
                case ControlChar: {
                    ParaTextCopier.copyControlChar((HWPCharControlChar)hwpChar, target.addNewCharControlChar());
                    break;
                }
                case ControlInline: {
                    ParaTextCopier.copyInlineChar((HWPCharControlInline)hwpChar, target.addNewInlineControlChar());
                    break;
                }
                case ControlExtend: {
                    HWPCharControlExtend ec = (HWPCharControlExtend)hwpChar;
                    if (includingSectionDefine) {
                        ParaTextCopier.copyExtendChar(ec, target.addNewExtendControlChar());
                        break;
                    }
                    if (ParaTextCopier.notSectionDefine(ec)) {
                        ParaTextCopier.copyExtendChar(ec, target.addNewExtendControlChar());
                        break;
                    }
                    excludedSectionDefine = true;
                    break;
                }
            }
        }
        return excludedSectionDefine;
    }

    private static boolean notSectionDefine(HWPCharControlExtend ec) {
        return ec.isColumnDefine() || ec.getCode() == 3 || ec.getCode() == 11 || ec.getCode() == 15 || ec.getCode() == 17 || ec.getCode() == 18 || ec.getCode() == 21 || ec.getCode() == 22 || ec.getCode() == 23;
    }

    private static void copyNormalChar(HWPCharNormal source, HWPCharNormal target) {
        target.setCode(source.getCode());
    }

    private static void copyControlChar(HWPCharControlChar source, HWPCharControlChar target) {
        target.setCode(source.getCode());
    }

    private static void copyInlineChar(HWPCharControlInline source, HWPCharControlInline target) throws Exception {
        target.setCode(source.getCode());
        target.setAddition((byte[])source.getAddition().clone());
    }

    private static void copyExtendChar(HWPCharControlExtend source, HWPCharControlExtend target) throws Exception {
        target.setCode(source.getCode());
        target.setAddition((byte[])source.getAddition().clone());
    }
}

