/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder.docinfo;

import java.util.ArrayList;
import java.util.HashMap;
import kr.dogfoot.hwplib.object.docinfo.BorderFill;
import kr.dogfoot.hwplib.object.docinfo.borderfill.EachBorder;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.ForFillInfo;

public class BorderFillAdder {
    private DocInfoAdder docInfoAdder;
    private HashMap<Integer, Integer> idMatchingMap;

    public BorderFillAdder(DocInfoAdder docInfoAdder) {
        this.docInfoAdder = docInfoAdder;
        this.idMatchingMap = new HashMap();
    }

    public int processById(int sourceId) {
        if (this.docInfoAdder.getSourceHWPFile() == this.docInfoAdder.getTargetHWPFile()) {
            return sourceId;
        }
        if (this.idMatchingMap.containsKey(sourceId)) {
            return this.idMatchingMap.get(sourceId);
        }
        BorderFill source = null;
        try {
            source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getBorderFillList().get(sourceId - 1);
        }
        catch (Exception e) {
            return sourceId;
        }
        int id = this.findFromTarget(source);
        if (id == -1) {
            id = this.addAndCopy(source);
        }
        this.idMatchingMap.put(sourceId, id);
        return id;
    }

    private int findFromTarget(BorderFill source) {
        int count = this.docInfoAdder.getTargetHWPFile().getDocInfo().getBorderFillList().size();
        for (int index = 0; index < count; ++index) {
            BorderFill target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getBorderFillList().get(index);
            if (!this.equal(source, target)) continue;
            return index + 1;
        }
        return -1;
    }

    private boolean equal(BorderFill source, BorderFill target) {
        if (source == null || target == null) {
            return source == target;
        }
        return source.getProperty().getValue() == target.getProperty().getValue() && this.equalEachBorder(source.getLeftBorder(), target.getLeftBorder()) && this.equalEachBorder(source.getRightBorder(), target.getRightBorder()) && this.equalEachBorder(source.getTopBorder(), target.getTopBorder()) && this.equalEachBorder(source.getBottomBorder(), target.getBottomBorder()) && this.equalEachBorder(source.getDiagonalBorder(), target.getDiagonalBorder()) && ForFillInfo.equal(source.getFillInfo(), target.getFillInfo());
    }

    private boolean equalEachBorder(EachBorder source, EachBorder target) {
        return source.getType() == target.getType() && source.getThickness() == target.getThickness() && source.getColor().getValue() == target.getColor().getValue();
    }

    private int addAndCopy(BorderFill source) {
        BorderFill target = this.docInfoAdder.getTargetHWPFile().getDocInfo().addNewBorderFill();
        target.getProperty().setValue(source.getProperty().getValue());
        this.copyEachBorder(source.getLeftBorder(), target.getLeftBorder());
        this.copyEachBorder(source.getRightBorder(), target.getRightBorder());
        this.copyEachBorder(source.getTopBorder(), target.getTopBorder());
        this.copyEachBorder(source.getBottomBorder(), target.getBottomBorder());
        this.copyEachBorder(source.getDiagonalBorder(), target.getDiagonalBorder());
        ForFillInfo.copy(source.getFillInfo(), target.getFillInfo(), this.docInfoAdder);
        return this.docInfoAdder.getTargetHWPFile().getDocInfo().getBorderFillList().size();
    }

    private void copyEachBorder(EachBorder source, EachBorder target) {
        target.setType(source.getType());
        target.setThickness(source.getThickness());
        target.getColor().setValue(source.getColor().getValue());
    }

    public boolean equalById(int sourceId, int targetId) {
        if (sourceId == 0 || targetId == 0) {
            return sourceId == targetId;
        }
        BorderFill source = this.getBorderFill(this.docInfoAdder.getSourceHWPFile().getDocInfo().getBorderFillList(), sourceId - 1);
        BorderFill target = this.getBorderFill(this.docInfoAdder.getTargetHWPFile().getDocInfo().getBorderFillList(), targetId - 1);
        return this.equal(source, target);
    }

    private BorderFill getBorderFill(ArrayList<BorderFill> borderFillList, int index) {
        int count = borderFillList.size();
        if (count == 0) {
            return null;
        }
        if (index >= count) {
            return borderFillList.get(count - 1);
        }
        if (index < 0) {
            return borderFillList.get(0);
        }
        return borderFillList.get(index);
    }
}

