/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.tool.paragraphadder.docinfo;

import java.util.HashMap;
import kr.dogfoot.hwplib.object.docinfo.Style;
import kr.dogfoot.hwplib.tool.paragraphadder.docinfo.DocInfoAdder;
import kr.dogfoot.hwplib.util.StringUtil;

public class StyleAdder {
    private DocInfoAdder docInfoAdder;
    private HashMap<Integer, Integer> idMatchingMap;

    public StyleAdder(DocInfoAdder docInfoAdder) {
        this.docInfoAdder = docInfoAdder;
        this.idMatchingMap = new HashMap();
    }

    public int processById(int sourceId) {
        Style source;
        if (this.docInfoAdder.getSourceHWPFile() == this.docInfoAdder.getTargetHWPFile()) {
            return sourceId;
        }
        if (this.idMatchingMap.containsKey(sourceId)) {
            return this.idMatchingMap.get(sourceId);
        }
        try {
            source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getStyleList().get(sourceId);
        }
        catch (Exception e) {
            return sourceId;
        }
        int id = this.findFromTarget(source, sourceId);
        if (id == -1) {
            id = this.addAndCopy(source, sourceId);
        }
        this.idMatchingMap.put(sourceId, id);
        return id;
    }

    private int findFromTarget(Style source, int sourceId) {
        int count = this.docInfoAdder.getTargetHWPFile().getDocInfo().getStyleList().size();
        for (int index = 0; index < count; ++index) {
            Style target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getStyleList().get(index);
            if (!this.equal(source, target, sourceId, index)) continue;
            return index;
        }
        return -1;
    }

    private boolean equal(Style source, Style target, int sourceId, int targetId) {
        return StringUtil.equals(source.getHangulName(), target.getHangulName()) && StringUtil.equals(source.getEnglishName(), target.getEnglishName()) && source.getProeprty().getValue() == target.getProeprty().getValue() && this.equalNextStyleId(source.getNextStyleId(), target.getNextStyleId(), sourceId, targetId) && source.getLanguageId() == target.getLanguageId() && this.docInfoAdder.forParaShape().equalById(source.getParaShapeId(), target.getParaShapeId()) && this.docInfoAdder.forCharShape().equalById(source.getCharShapeId(), target.getCharShapeId());
    }

    private boolean equalNextStyleId(short sourceNextStyleId, short targetNextStyleId, int sourceId, int targetId) {
        if (sourceNextStyleId == sourceId && targetNextStyleId == targetId) {
            return true;
        }
        if (sourceNextStyleId == sourceId || targetNextStyleId == targetId) {
            return false;
        }
        return this.equalById(sourceNextStyleId, targetNextStyleId);
    }

    private int addAndCopy(Style source, int sourceId) {
        Style target = this.docInfoAdder.getTargetHWPFile().getDocInfo().addNewStyle();
        int targetId = this.docInfoAdder.getTargetHWPFile().getDocInfo().getStyleList().size() - 1;
        target.setHangulName(source.getHangulName());
        target.setEnglishName(source.getEnglishName());
        target.getProeprty().setValue(source.getProeprty().getValue());
        if (source.getNextStyleId() == sourceId) {
            target.setNextStyleId((short)targetId);
        } else {
            target.setNextStyleId((short)this.processById(source.getNextStyleId()));
        }
        target.setLanguageId(source.getLanguageId());
        target.setParaShapeId(this.docInfoAdder.forParaShape().processById(source.getParaShapeId()));
        target.setCharShapeId(this.docInfoAdder.forCharShape().processById(source.getCharShapeId()));
        return targetId;
    }

    public boolean equalById(short sourceId, short targetId) {
        Style source = this.docInfoAdder.getSourceHWPFile().getDocInfo().getStyleList().get(sourceId);
        Style target = this.docInfoAdder.getTargetHWPFile().getDocInfo().getStyleList().get(targetId);
        return this.equal(source, target, sourceId, targetId);
    }
}

