/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.util.compoundFile.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.DirectoryEntry;
import kr.dogfoot.hwplib.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class CompoundFileWriter {
    protected POIFSFileSystem fs = new POIFSFileSystem();
    protected DirectoryEntry currentStorage = this.fs.getRoot();
    protected StreamWriter currentStreamWriter;

    public void write(String filepath) throws IOException {
        FileOutputStream os = new FileOutputStream(filepath);
        this.fs.writeFilesystem(os);
        ((OutputStream)os).close();
    }

    public void write(OutputStream os) throws IOException {
        this.fs.writeFilesystem(os);
        os.close();
    }

    public void close() throws IOException {
        this.fs = null;
    }

    public void openCurrentStorage(String name) throws IOException {
        this.currentStorage = this.currentStorage.createDirectory(name);
    }

    public void closeCurrentStorage() {
        this.currentStorage = this.currentStorage.getParent();
    }

    public StreamWriter openCurrentStream(String name, boolean compress, FileVersion fileVersion) {
        this.currentStreamWriter = new StreamWriter(name, compress, fileVersion);
        return this.currentStreamWriter;
    }

    public void saveToStream(String name, InputStream is) throws IOException {
        this.currentStorage.createDocument(name, is);
        is.close();
    }

    public void closeCurrentStream() throws IOException {
        InputStream is = this.currentStreamWriter.getDataStream();
        this.currentStorage.createDocument(this.currentStreamWriter.getName(), is);
        is.close();
        this.currentStreamWriter.close();
        this.currentStreamWriter = null;
    }

    public void gotoRootStorage() {
        this.currentStorage = this.fs.getRoot();
    }
}

