/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import kr.dogfoot.hwplib.object.bodytext.paragraph.Paragraph;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlChar;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlExtend;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharControlInline;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.HWPCharNormal;
import kr.dogfoot.hwplib.object.bodytext.paragraph.text.ParaText;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForParaText {
    public static void write(Paragraph p, StreamWriter sw) throws IOException {
        if (ForParaText.emptyText(p)) {
            return;
        }
        ForParaText.recordHeader(p, sw);
        for (HWPChar hc : p.getText().getCharList()) {
            ForParaText.hwpChar(hc, sw);
        }
    }

    private static boolean emptyText(Paragraph p) {
        if (p.getHeader().getCharacterCount() <= 1L) {
            HWPChar hwpChar;
            ParaText paraText = p.getText();
            if (paraText == null) {
                return true;
            }
            if (paraText.getCharList().size() <= 1 && (hwpChar = paraText.getCharList().get(0)).getCode() == 13) {
                return true;
            }
        }
        return false;
    }

    private static void recordHeader(Paragraph p, StreamWriter sw) throws IOException {
        long size = p.getHeader().getCharacterCount() * 2L;
        sw.writeRecordHeader(67, (int)size);
    }

    private static void hwpChar(HWPChar hc, StreamWriter sw) throws UnsupportedEncodingException, IOException {
        switch (hc.getType()) {
            case Normal: {
                ForParaText.normal((HWPCharNormal)hc, sw);
                break;
            }
            case ControlChar: {
                ForParaText.controlChar((HWPCharControlChar)hc, sw);
                break;
            }
            case ControlInline: {
                ForParaText.controlInline((HWPCharControlInline)hc, sw);
                break;
            }
            case ControlExtend: {
                ForParaText.controlExtend((HWPCharControlExtend)hc, sw);
            }
        }
    }

    private static void normal(HWPCharNormal hc, StreamWriter sw) throws UnsupportedEncodingException, IOException {
        sw.writeUInt2(hc.getCode());
    }

    private static void controlChar(HWPCharControlChar hc, StreamWriter sw) throws IOException {
        sw.writeUInt2(hc.getCode());
    }

    private static void controlInline(HWPCharControlInline hc, StreamWriter sw) throws IOException {
        sw.writeUInt2(hc.getCode());
        sw.writeBytes(hc.getAddition());
        sw.writeUInt2(hc.getCode());
    }

    private static void controlExtend(HWPCharControlExtend hc, StreamWriter sw) throws IOException {
        sw.writeUInt2(hc.getCode());
        sw.writeBytes(hc.getAddition());
        sw.writeUInt2(hc.getCode());
    }
}

