/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.ControlSectionDefine;
import kr.dogfoot.hwplib.object.bodytext.control.ctrlheader.CtrlHeaderSectionDefine;
import kr.dogfoot.hwplib.object.bodytext.control.sectiondefine.BatangPageInfo;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.bookmark.ForCtrlData;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.secd.ForBatangPageInfo;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.secd.ForFootEndNoteShape;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.secd.ForPageBorderFill;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.secd.ForPageDef;

public class ForControlSectionDefine {
    public static void write(ControlSectionDefine sd, StreamWriter sw) throws Exception {
        ForControlSectionDefine.ctrlHeader(sd.getHeader(), sw);
        sw.upRecordLevel();
        ForControlSectionDefine.ctrlData(sd, sw);
        ForPageDef.write(sd.getPageDef(), sw);
        ForFootEndNoteShape.write(sd.getFootNoteShape(), sw);
        ForFootEndNoteShape.write(sd.getEndNoteShape(), sw);
        ForPageBorderFill.write(sd.getBothPageBorderFill(), sw);
        ForPageBorderFill.write(sd.getEvenPageBorderFill(), sw);
        ForPageBorderFill.write(sd.getOddPageBorderFill(), sw);
        ForControlSectionDefine.batangPageInfoList(sd, sw);
        sw.downRecordLevel();
    }

    private static void ctrlHeader(CtrlHeaderSectionDefine h, StreamWriter sw) throws IOException {
        ForControlSectionDefine.recordHeader(h, sw);
        sw.writeUInt4(h.getCtrlId());
        sw.writeUInt4(h.getProperty().getValue());
        sw.writeUInt2(h.getColumnGap());
        sw.writeUInt2(h.getVerticalLineAlign());
        sw.writeUInt2(h.getHorizontalLineAlign());
        sw.writeUInt4(h.getDefaultTabGap());
        sw.writeUInt2(sw.correctParaShapeId(sw.correctParaShapeId(h.getNumberParaShapeId())));
        sw.writeUInt2(h.getPageStartNumber());
        sw.writeUInt2(h.getImageStartNumber());
        sw.writeUInt2(h.getTableStartNumber());
        sw.writeUInt2(h.getEquationStartNumber());
        if (sw.getFileVersion().isOver(5, 0, 1, 2)) {
            sw.writeUInt2(h.getDefaultLanguage());
        }
        sw.writeZero(8);
    }

    private static void recordHeader(CtrlHeaderSectionDefine h, StreamWriter sw) throws IOException {
        int size = sw.getFileVersion().isOver(5, 0, 1, 2) ? 38 : 36;
        sw.writeRecordHeader(71, size);
    }

    private static void batangPageInfoList(ControlSectionDefine sd, StreamWriter sw) throws Exception {
        for (BatangPageInfo bpi : sd.getBatangPageInfoList()) {
            ForBatangPageInfo.write(bpi, sw);
        }
    }

    private static void ctrlData(ControlSectionDefine sd, StreamWriter sw) throws IOException {
        if (sd.getCtrlData() != null) {
            ForCtrlData.write(sd.getCtrlData(), sw);
        }
    }
}

