/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.part.shapecomponent;

import java.io.IOException;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.ShapeComponentNormal;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.lineinfo.LineInfo;
import kr.dogfoot.hwplib.object.bodytext.control.gso.shapecomponent.shadowinfo.ShadowInfo;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.FillInfo;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;
import kr.dogfoot.hwplib.writer.bodytext.paragraph.control.gso.part.shapecomponent.CommonPart;
import kr.dogfoot.hwplib.writer.docinfo.borderfill.ForFillInfo;

public class ForShapeComponentForNormal {
    public static void write(ShapeComponentNormal scn, StreamWriter sw) throws IOException {
        ForShapeComponentForNormal.recordHeader(scn, sw);
        ForShapeComponentForNormal.gsoCtrlId(scn, sw);
        CommonPart.write(scn, sw);
        ForShapeComponentForNormal.lineInfo(scn.getLineInfo(), sw);
        ForShapeComponentForNormal.fillInfo(scn.getFillInfo(), sw);
        ForShapeComponentForNormal.shadowInfo(scn.getShadowInfo(), sw);
        ForShapeComponentForNormal.rest(scn, sw);
    }

    private static void recordHeader(ShapeComponentNormal scn, StreamWriter sw) throws IOException {
        sw.writeRecordHeader(76, ForShapeComponentForNormal.getSize(scn));
    }

    private static int getSize(ShapeComponentNormal scn) {
        int size = 0;
        size += 8;
        size += CommonPart.getSize(scn);
        if (scn.getLineInfo() != null) {
            size += 13;
        }
        if (scn.getFillInfo() != null) {
            size += ForFillInfo.getSize(scn.getFillInfo());
        }
        if (scn.getShadowInfo() != null) {
            size += 22;
        }
        return size;
    }

    private static void gsoCtrlId(ShapeComponentNormal scn, StreamWriter sw) throws IOException {
        sw.writeUInt4(scn.getGsoId());
        sw.writeUInt4(scn.getGsoId());
    }

    private static void lineInfo(LineInfo li, StreamWriter sw) throws IOException {
        if (li != null) {
            sw.writeUInt4(li.getColor().getValue());
            sw.writeSInt4(li.getThickness());
            sw.writeUInt4(li.getProperty().getValue());
            sw.writeUInt1(li.getOutlineStyle().getValue());
        }
    }

    private static void fillInfo(FillInfo fi, StreamWriter sw) throws IOException {
        if (fi != null) {
            ForFillInfo.write(fi, sw);
        }
    }

    private static void shadowInfo(ShadowInfo si, StreamWriter sw) throws IOException {
        if (si != null) {
            sw.writeUInt4(si.getType().getValue());
            sw.writeUInt4(si.getColor().getValue());
            sw.writeSInt4(si.getOffsetX());
            sw.writeSInt4(si.getOffsetY());
        }
    }

    private static void rest(ShapeComponentNormal scn, StreamWriter sw) throws IOException {
        if (scn.getShadowInfo() != null) {
            sw.writeUInt4(scn.getInstid());
            sw.writeZero(1);
            sw.writeUInt1(scn.getShadowInfo().getTransparent());
        }
    }

    public static void writeInContainer(ShapeComponentNormal scn, StreamWriter sw) throws IOException {
        ForShapeComponentForNormal.recordHeaderInContainer(scn, sw);
        ForShapeComponentForNormal.gsoCtrlIdInContainer(scn, sw);
        CommonPart.write(scn, sw);
        ForShapeComponentForNormal.lineInfo(scn.getLineInfo(), sw);
        ForShapeComponentForNormal.fillInfo(scn.getFillInfo(), sw);
        ForShapeComponentForNormal.shadowInfo(scn.getShadowInfo(), sw);
        ForShapeComponentForNormal.rest(scn, sw);
    }

    private static void recordHeaderInContainer(ShapeComponentNormal scn, StreamWriter sw) throws IOException {
        sw.writeRecordHeader(76, ForShapeComponentForNormal.getSize(scn) - 4);
    }

    private static void gsoCtrlIdInContainer(ShapeComponentNormal scn, StreamWriter sw) throws IOException {
        sw.writeUInt4(scn.getGsoId());
    }
}

