/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.docinfo;

import java.io.IOException;
import kr.dogfoot.hwplib.object.docinfo.Numbering;
import kr.dogfoot.hwplib.object.docinfo.numbering.LevelNumbering;
import kr.dogfoot.hwplib.object.docinfo.numbering.ParagraphHeadInfo;
import kr.dogfoot.hwplib.object.fileheader.FileVersion;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForNumbering {
    public static void write(Numbering n, StreamWriter sw) throws Exception {
        ForNumbering.recordHeader(n, sw);
        ForNumbering.levelNumberings1To7(n, sw);
        sw.writeUInt2(n.getStartNumber());
        if (sw.getFileVersion().isOver(5, 0, 2, 5)) {
            ForNumbering.startNumbersFor1To7(n, sw);
            ForNumbering.levelNumberings8To10(n, sw);
            ForNumbering.startNumbersFor8To10(n, sw);
        }
    }

    private static void recordHeader(Numbering n, StreamWriter sw) throws Exception {
        sw.writeRecordHeader(23, ForNumbering.getSize(n, sw.getFileVersion()));
    }

    private static int getSize(Numbering n, FileVersion version) throws Exception {
        LevelNumbering ln;
        int level;
        int size = 0;
        for (level = 1; level <= 7; ++level) {
            ln = n.getLevelNumbering(level);
            size += 12 + ln.getNumberFormat().getWCharsSize();
        }
        size += 2;
        if (version.isOver(5, 0, 2, 5)) {
            size += 28;
            for (level = 8; level <= 10; ++level) {
                ln = n.getLevelNumbering(level);
                size += 12 + ln.getNumberFormat().getWCharsSize();
            }
            size += 12;
        }
        return size;
    }

    private static void levelNumberings1To7(Numbering n, StreamWriter sw) throws Exception {
        for (int level = 1; level <= 7; ++level) {
            ForNumbering.levelNumbering(n.getLevelNumbering(level), sw);
        }
    }

    private static void levelNumbering(LevelNumbering ln, StreamWriter sw) throws IOException {
        ForNumbering.paragraphHeadInfo(ln.getParagraphHeadInfo(), sw);
        sw.writeHWPString(ln.getNumberFormat());
    }

    public static void paragraphHeadInfo(ParagraphHeadInfo phi, StreamWriter sw) throws IOException {
        sw.writeUInt4(phi.getProperty().getValue());
        sw.writeUInt2(phi.getCorrectionValueForWidth());
        sw.writeUInt2(phi.getDistanceFromBody());
        sw.writeUInt4(phi.getCharShapeID());
    }

    private static void startNumbersFor1To7(Numbering n, StreamWriter sw) throws Exception {
        for (int level = 1; level <= 7; ++level) {
            sw.writeUInt4(n.getLevelNumbering(level).getStartNumber());
        }
    }

    private static void levelNumberings8To10(Numbering n, StreamWriter sw) throws Exception {
        for (int level = 8; level <= 10; ++level) {
            ForNumbering.levelNumbering(n.getLevelNumbering(level), sw);
        }
    }

    private static void startNumbersFor8To10(Numbering n, StreamWriter sw) throws Exception {
        for (int level = 8; level <= 10; ++level) {
            sw.writeUInt4(n.getLevelNumbering(level).getStartNumber());
        }
    }
}

