/*
 * Decompiled with CFR 0.152.
 */
package kr.dogfoot.hwplib.writer.docinfo.borderfill;

import java.io.IOException;
import java.util.Iterator;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.FillInfo;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.GradientFill;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.ImageFill;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.PatternFill;
import kr.dogfoot.hwplib.object.docinfo.borderfill.fillinfo.PictureInfo;
import kr.dogfoot.hwplib.object.etc.Color4Byte;
import kr.dogfoot.hwplib.util.compoundFile.writer.StreamWriter;

public class ForFillInfo {
    public static void write(FillInfo fi, StreamWriter sw) throws IOException {
        sw.writeUInt4(fi.getType().getValue());
        if (fi.getType().getValue() != 0L) {
            if (fi.getType().hasPatternFill()) {
                ForFillInfo.writePatternFill(fi.getPatternFill(), sw);
            }
            if (fi.getType().hasGradientFill()) {
                ForFillInfo.writeGradientFill(fi.getGradientFill(), sw);
            }
            if (fi.getType().hasImageFill()) {
                ForFillInfo.writeImageFill(fi.getImageFill(), sw);
            }
            ForFillInfo.additionalProperty(fi, sw);
            ForFillInfo.unknownBytes(fi, sw);
        } else {
            sw.writeZero(4);
        }
    }

    private static void writePatternFill(PatternFill pf, StreamWriter sw) throws IOException {
        sw.writeUInt4(pf.getBackColor().getValue());
        sw.writeUInt4(pf.getPatternColor().getValue());
        sw.writeUInt4(pf.getPatternType().getValue());
    }

    private static void writeGradientFill(GradientFill gf, StreamWriter sw) throws IOException {
        sw.writeSInt1(gf.getGradientType().getValue());
        sw.writeUInt4(gf.getStartAngle());
        sw.writeUInt4(gf.getCenterX());
        sw.writeUInt4(gf.getCenterY());
        sw.writeUInt4(gf.getBlurringDegree());
        long colorCount = gf.getColorList().size();
        sw.writeUInt4(colorCount);
        if (colorCount > 2L) {
            Iterator<Object> iterator = gf.getChangePointList().iterator();
            while (iterator.hasNext()) {
                int cp = (Integer)iterator.next();
                sw.writeSInt4(cp);
            }
        }
        for (Color4Byte c : gf.getColorList()) {
            sw.writeUInt4(c.getValue());
        }
    }

    private static void writeImageFill(ImageFill imf, StreamWriter sw) throws IOException {
        sw.writeUInt1(imf.getImageFillType().getValue());
        ForFillInfo.pictureInfo(imf.getPictureInfo(), sw);
    }

    public static void pictureInfo(PictureInfo pi, StreamWriter sw) throws IOException {
        sw.writeSInt1(pi.getBrightness());
        sw.writeSInt1(pi.getContrast());
        sw.writeUInt1(pi.getEffect().getValue());
        sw.writeUInt2(pi.getBinItemID());
    }

    private static void additionalProperty(FillInfo fi, StreamWriter sw) throws IOException {
        if (fi.getType().hasGradientFill()) {
            sw.writeUInt4(1L);
            sw.writeUInt1(fi.getGradientFill().getBlurringCenter());
        } else {
            sw.writeUInt4(0L);
        }
    }

    private static void unknownBytes(FillInfo fi, StreamWriter sw) throws IOException {
        if (fi.getType().hasPatternFill()) {
            sw.writeZero(1);
        }
        if (fi.getType().hasGradientFill()) {
            sw.writeZero(1);
        }
        if (fi.getType().hasImageFill()) {
            sw.writeZero(1);
        }
    }

    public static int getSize(FillInfo fi) {
        int size = 0;
        size += 4;
        if (fi.getType().getValue() != 0L) {
            if (fi.getType().hasPatternFill()) {
                size += 12;
            }
            if (fi.getType().hasGradientFill()) {
                size += 17;
                size += 4;
                long colorCount = fi.getGradientFill().getColorList().size();
                if (colorCount > 2L) {
                    size = (int)((long)size + colorCount * 4L);
                }
                size = (int)((long)size + colorCount * 4L);
            }
            if (fi.getType().hasImageFill()) {
                size += 6;
            }
            if (fi.getType().hasGradientFill()) {
                size += 4;
                ++size;
            } else {
                size += 4;
            }
            if (fi.getType().hasPatternFill()) {
                ++size;
            }
            if (fi.getType().hasGradientFill()) {
                ++size;
            }
            if (fi.getType().hasImageFill()) {
                ++size;
            }
        } else {
            size += 4;
        }
        return size;
    }
}

