/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.List;
import java.util.Map;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CData;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

public class JDomSerializer {
    private static final String CSS_COMMENT_START = "/*";
    private static final String CSS_COMMENT_END = "*/";
    private static final String NEW_LINE = "\n";
    private DefaultJDOMFactory factory;
    protected CleanerProperties props;
    protected boolean escapeXml = true;

    public JDomSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public JDomSerializer(CleanerProperties props) {
        this(props, true);
    }

    public Document createJDom(TagNode rootNode) {
        this.factory = new DefaultJDOMFactory();
        if (rootNode.getName() == null) {
            return null;
        }
        Element rootElement = this.createElement(rootNode);
        Document document = this.factory.document(rootElement);
        this.setAttributes(rootNode, rootElement);
        this.createSubnodes(rootElement, rootNode.getAllChildren());
        return document;
    }

    private Element createElement(TagNode node) {
        Element element;
        String name = node.getName();
        name = Utils.sanitizeXmlIdentifier(name);
        boolean nsAware = this.props.isNamespacesAware();
        String prefix = Utils.getXmlNSPrefix(name);
        Map<String, String> nsDeclarations = node.getNamespaceDeclarations();
        String nsURI = null;
        if (prefix != null) {
            name = Utils.getXmlName(name);
            if (nsAware) {
                if (nsDeclarations != null) {
                    nsURI = nsDeclarations.get(prefix);
                }
                if (nsURI == null) {
                    nsURI = node.getNamespaceURIOnPath(prefix);
                }
                if (nsURI == null) {
                    nsURI = prefix;
                }
            }
        } else if (nsAware) {
            if (nsDeclarations != null) {
                nsURI = nsDeclarations.get("");
            }
            if (nsURI == null) {
                nsURI = node.getNamespaceURIOnPath(prefix);
            }
        }
        if (nsAware && nsURI != null) {
            Namespace ns = prefix == null ? Namespace.getNamespace((String)nsURI) : Namespace.getNamespace((String)prefix, (String)nsURI);
            element = this.factory.element(name, ns);
        } else {
            element = this.factory.element(name);
        }
        if (nsAware) {
            this.defineNamespaceDeclarations(node, element);
        }
        return element;
    }

    private void defineNamespaceDeclarations(TagNode node, Element element) {
        Map<String, String> nsDeclarations = node.getNamespaceDeclarations();
        if (nsDeclarations != null) {
            for (Map.Entry<String, String> nsEntry : nsDeclarations.entrySet()) {
                String nsPrefix = nsEntry.getKey();
                String nsURI = nsEntry.getValue();
                Namespace ns = nsPrefix == null || "".equals(nsPrefix) ? Namespace.getNamespace((String)nsURI) : Namespace.getNamespace((String)nsPrefix, (String)nsURI);
                element.addNamespaceDeclaration(ns);
            }
        }
    }

    private void setAttributes(TagNode node, Element element) {
        for (Map.Entry<String, String> entry : node.getAttributes().entrySet()) {
            String attrName = entry.getKey();
            String attrValue = entry.getValue();
            if (this.escapeXml) {
                attrValue = Utils.deserializeEntities(attrValue, this.props.isRecognizeUnicodeChars());
                attrValue = Utils.escapeXml(attrValue, this.props, true);
            }
            if (!this.props.isAllowInvalidAttributeNames()) {
                attrName = Utils.sanitizeXmlIdentifier(attrName, this.props.getInvalidXmlAttributeNamePrefix(), "");
            }
            if (attrName == null || !Utils.isValidXmlIdentifier(attrName)) continue;
            String attPrefix = Utils.getXmlNSPrefix(attrName);
            Namespace ns = null;
            if (attPrefix != null) {
                attrName = Utils.getXmlName(attrName);
                if (this.props.isNamespacesAware()) {
                    String nsURI = node.getNamespaceURIOnPath(attPrefix);
                    if (nsURI == null) {
                        nsURI = attPrefix;
                    }
                    if (!attPrefix.startsWith("xml")) {
                        ns = Namespace.getNamespace((String)attPrefix, (String)nsURI);
                    }
                }
            }
            if (attrName.equals("xmlns")) continue;
            if (ns == null) {
                element.setAttribute(attrName, attrValue);
                continue;
            }
            element.setAttribute(attrName, attrValue, ns);
        }
    }

    private void createSubnodes(Element element, List<? extends BaseToken> tagChildren) {
        if (tagChildren != null) {
            CDATA cdata = null;
            if (this.props.isUseCdataFor(element.getName())) {
                cdata = this.factory.cdata("");
                element.addContent((Content)this.factory.text(CSS_COMMENT_START));
                element.addContent((Content)cdata);
            }
            for (BaseToken baseToken : tagChildren) {
                if (baseToken instanceof CommentNode) {
                    CommentNode commentNode = (CommentNode)baseToken;
                    Comment comment = this.factory.comment(commentNode.getContent().toString());
                    element.addContent((Content)comment);
                    continue;
                }
                if (baseToken instanceof ContentNode) {
                    String nodeName = element.getName();
                    String content = baseToken.toString();
                    boolean specialCase = this.props.isUseCdataFor(nodeName);
                    if (this.escapeXml && !specialCase) {
                        content = Utils.escapeXml(content, this.props, true);
                    }
                    if (specialCase && baseToken instanceof CData) {
                        content = ((CData)baseToken).getContentWithoutStartAndEndTokens();
                    }
                    if (cdata != null) {
                        cdata.append(content);
                        continue;
                    }
                    Text text = this.factory.text(content);
                    element.addContent((Content)text);
                    continue;
                }
                if (baseToken instanceof TagNode) {
                    TagNode subTagNode = (TagNode)baseToken;
                    Element subelement = this.createElement(subTagNode);
                    this.setAttributes(subTagNode, subelement);
                    this.createSubnodes(subelement, subTagNode.getAllChildren());
                    element.addContent((Content)subelement);
                    continue;
                }
                if (!(baseToken instanceof List)) continue;
                List sublist = (List)((Object)baseToken);
                this.createSubnodes(element, sublist);
            }
            if (cdata != null) {
                if (!cdata.getText().startsWith(NEW_LINE)) {
                    cdata.setText("*/\n" + cdata.getText());
                } else {
                    cdata.setText(CSS_COMMENT_END + cdata.getText());
                }
                if (!cdata.getText().endsWith(NEW_LINE)) {
                    cdata.append(NEW_LINE);
                }
                cdata.append(CSS_COMMENT_START);
                element.addContent((Content)this.factory.text(CSS_COMMENT_END));
            }
        }
    }
}

