/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class AiStartUtil {
    private static final String OLLAMA_STATUS_URL = "http://localhost:11434/api/tags";

    public static void ensureAiStarted() {
        if (AiStartUtil.isRunning()) {
            System.out.println("\u2705 Ai already running.");
            return;
        }
        try {
            System.out.println("\ud83d\udd04 Ai not running. Starting...");
            ProcessBuilder pb = new ProcessBuilder("ollama", "start");
            pb.redirectErrorStream(true);
            pb.start();
            Thread.sleep(2000L);
            if (AiStartUtil.isRunning()) {
                System.out.println("\u2705 Ai started successfully.");
            } else {
                System.err.println("\u274c Ai failed to start.");
            }
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to start Ollama: " + e.getMessage());
        }
    }

    public static void stopAi() {
        String os = System.getProperty("os.name").toLowerCase();
        ProcessBuilder pb = os.contains("win") ? new ProcessBuilder("taskkill", "/F", "/IM", "ollama.exe") : new ProcessBuilder("pkill", "-f", "ollama");
        pb.redirectErrorStream(true);
        try {
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                System.out.println("\ud83d\uded1 Ai \uc11c\ubc84 \uc885\ub8cc \uc644\ub8cc");
            } else {
                System.err.println("\u26a0\ufe0f Ai \uc885\ub8cc \uc2e4\ud328 (exitCode: " + exitCode + ")");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean isRunning() {
        try {
            URL url = new URL(OLLAMA_STATUS_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(1000);
            conn.setReadTimeout(1000);
            conn.setRequestMethod("GET");
            int responseCode = conn.getResponseCode();
            return responseCode == 200;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

