/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class LlamaChatView
extends ViewPart {
    public static final String ID = "kr.co.goms.epub.view.llamachatview";
    private ScrolledComposite scrolled;
    private Composite chatContainer;
    private Text inputText;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.scrolled = new ScrolledComposite(parent, 2560);
        this.scrolled.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chatContainer = new Composite((Composite)this.scrolled, 0);
        this.chatContainer.setLayout((Layout)new GridLayout(1, false));
        this.scrolled.setContent((Control)this.chatContainer);
        this.scrolled.setExpandHorizontal(true);
        this.scrolled.setExpandVertical(true);
        this.scrolled.setMinSize(this.chatContainer.computeSize(-1, -1));
        Composite inputArea = new Composite(parent, 0);
        inputArea.setLayoutData((Object)new GridData(4, 1024, true, false));
        inputArea.setLayout((Layout)new GridLayout(2, false));
        this.inputText = new Text(inputArea, 2048);
        this.inputText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button sendBtn = new Button(inputArea, 8);
        sendBtn.setText("\uc804\uc1a1");
        sendBtn.addListener(13, e -> this.sendPrompt());
    }

    private void sendPrompt() {
        String prompt = this.inputText.getText().trim();
        if (prompt.isEmpty()) {
            return;
        }
        this.addMessage("\ud83e\uddd1", prompt);
        this.inputText.setText("");
        new Thread(() -> {
            try {
                String response = this.sendToOllama(prompt);
                Display.getDefault().asyncExec(() -> this.addMessage("\ud83e\udd16", response));
            }
            catch (IOException | InterruptedException ex) {
                Display.getDefault().asyncExec(() -> this.addMessage("\u26a0\ufe0f", "\ubaa8\ub378 \uc751\ub2f5 \uc624\ub958: " + ex.getMessage()));
                ex.printStackTrace();
            }
        }).start();
    }

    private void addMessage(String sender, String text) {
        Label message = new Label(this.chatContainer, 64);
        message.setText(sender + " " + text);
        message.setLayoutData((Object)new GridData(4, 128, true, false));
        this.chatContainer.layout();
        this.chatContainer.pack();
        this.scrolled.setMinSize(this.chatContainer.computeSize(-1, -1));
        this.scrolled.setOrigin(0, this.scrolled.getVerticalBar().getMaximum());
    }

    private String sendToOllama(String prompt) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        String requestBody = "{\n  \"model\": \"korean-bllossom-8b\",\n  \"prompt\": \"%s\",\n  \"stream\": false\n}\n".formatted(prompt.replace("\"", "\\\""));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://localhost:11434/api/generate")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        JsonObject json = JsonParser.parseString((String)response.body()).getAsJsonObject();
        return json.has("response") ? json.get("response").getAsString().trim() : "(\uc751\ub2f5 \uc5c6\uc74c)";
    }

    public void setFocus() {
        this.inputText.setFocus();
    }
}

