/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class OllamaStreamCaller {
    private static final String OLLAMA_URL = "http://localhost:11434/api/chat";
    private static final Gson gson = new Gson();

    public static void call(String userPrompt, StreamCallback callback) {
        new Thread(() -> {
            try {
                JsonObject message = new JsonObject();
                message.addProperty("role", "user");
                message.addProperty("content", userPrompt);
                JsonObject request = new JsonObject();
                request.addProperty("model", "llama3-korean-bllossom");
                request.add("messages", gson.toJsonTree((Object)new JsonObject[]{message}));
                request.addProperty("stream", Boolean.valueOf(true));
                URL url = new URL(OLLAMA_URL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoOutput(true);
                Throwable throwable = null;
                Object var7_10 = null;
                try (OutputStream os = conn.getOutputStream();){
                    os.write(gson.toJson((JsonElement)request).getBytes("UTF-8"));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var7_10 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        JsonObject lineJson;
                        JsonObject lineMessage;
                        if (line.trim().isEmpty() || (lineMessage = (lineJson = (JsonObject)gson.fromJson(line, JsonObject.class)).getAsJsonObject("message")) == null || !lineMessage.has("content")) continue;
                        String content = lineMessage.get("content").getAsString();
                        callback.onMessage(content);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                callback.onComplete();
            }
            catch (Exception e) {
                callback.onError(e);
            }
        }).start();
    }

    public static interface StreamCallback {
        public void onMessage(String var1);

        public void onComplete();

        public void onError(Exception var1);
    }
}

