/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.ai;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kr.co.goms.epub.ai.OllamaClient;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XhtmlMemoryService
implements AutoCloseable {
    private Connection conn;
    private String modelName = "mxbai-embed-large";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void initIfNeeded() {
        Throwable c;
        StringBuilder sb;
        if (this.conn != null) {
            return;
        }
        try {
            block20: {
                String jdbcUrl = XhtmlMemoryService.defaultJdbcUrl();
                Class.forName("org.sqlite.JDBC");
                this.ensureDbDir(jdbcUrl);
                this.conn = DriverManager.getConnection(jdbcUrl);
                this.exec("PRAGMA foreign_keys=ON");
                this.exec("PRAGMA busy_timeout=5000");
                this.exec("PRAGMA synchronous=NORMAL");
                String jm = this.scalar("PRAGMA journal_mode=WAL");
                System.out.println("[DB] journal_mode \u2192 " + jm);
                System.out.println("[DB] sqlite_version = " + this.scalar("select sqlite_version()"));
                Throwable throwable = null;
                Object var4_8 = null;
                try {
                    Statement s = this.conn.createStatement();
                    try {
                        try (ResultSet rs = s.executeQuery("PRAGMA compile_options");){
                            StringBuilder co = new StringBuilder();
                            while (true) {
                                if (!rs.next()) {
                                    System.out.println("[DB] compile_options = " + String.valueOf(co));
                                    break;
                                }
                                co.append(rs.getString(1)).append(", ");
                            }
                        }
                        if (s == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (s == null) throw throwable;
                        s.close();
                        throw throwable;
                    }
                    s.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            this.createSchemaIfAbsent();
            return;
        }
        catch (Throwable e) {
            sb = new StringBuilder("Init DB failed: ").append(e);
            c = e.getCause();
        }
        while (true) {
            if (c == null) {
                System.err.println(sb);
                throw new RuntimeException(sb.toString(), e);
            }
            sb.append(" | cause: ").append(c);
            c = c.getCause();
        }
    }

    private static String defaultJdbcUrl() {
        String userHome = System.getProperty("user.home");
        Path dbPath = Paths.get(userHome, ".goms", "gomsbook.db");
        return "jdbc:sqlite:" + String.valueOf(dbPath.toAbsolutePath());
    }

    /*
     * Loose catch block
     */
    private String scalar(String sql) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            String string;
            ResultSet rs;
            Statement st;
            block16: {
                block15: {
                    st = this.conn.createStatement();
                    rs = st.executeQuery(sql);
                    string = rs.next() ? rs.getString(1) : null;
                    if (rs == null) break block15;
                    rs.close();
                }
                if (st == null) break block16;
                st.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (st != null) {
                            st.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void ensureDbDir(String jdbcUrl) throws IOException {
        if (!jdbcUrl.startsWith("jdbc:sqlite:")) {
            throw new IllegalArgumentException("Invalid SQLite JDBC URL: " + jdbcUrl);
        }
        String path = jdbcUrl.substring("jdbc:sqlite:".length());
        if (path.isBlank() || path.startsWith(":memory:")) {
            throw new IllegalArgumentException("WAL/\ud30c\uc77c IO\ub97c \uc4f0\ub824\uba74 \ud30c\uc77c \uae30\ubc18 \uc808\ub300 \uacbd\ub85c\uac00 \ud544\uc694\ud569\ub2c8\ub2e4. url=" + jdbcUrl);
        }
        Path p = Paths.get(path, new String[0]).toAbsolutePath();
        Path parent = p.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (parent != null && !Files.isWritable(parent)) {
            throw new IOException("DB \uc0c1\uc704 \ud3f4\ub354\uc5d0 \uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4: " + String.valueOf(parent));
        }
    }

    private void exec(String sql) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement st = this.conn.createStatement();){
            st.execute(sql);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createSchemaIfAbsent() throws SQLException {
        this.conn.createStatement().execute("    CREATE TABLE IF NOT EXISTS xhtml_snippets (\n      id INTEGER PRIMARY KEY AUTOINCREMENT,\n      file_path TEXT NOT NULL,\n      anchor TEXT,\n      text TEXT NOT NULL,\n      vec BLOB NOT NULL,\n      dim INTEGER NOT NULL,\n      created_at DATETIME DEFAULT CURRENT_TIMESTAMP\n    );\n");
        this.conn.createStatement().execute("    CREATE VIRTUAL TABLE IF NOT EXISTS xhtml_snippets_fts\n    USING fts5(text, content='xhtml_snippets', content_rowid='id');\n");
        this.conn.createStatement().execute("    CREATE TRIGGER IF NOT EXISTS xhtml_snippets_ai AFTER INSERT ON xhtml_snippets BEGIN\n      INSERT INTO xhtml_snippets_fts(rowid, text) VALUES (new.id, new.text);\n    END;\n");
        this.conn.createStatement().execute("    CREATE TRIGGER IF NOT EXISTS xhtml_snippets_ad AFTER DELETE ON xhtml_snippets BEGIN\n      INSERT INTO xhtml_snippets_fts(xhtml_snippets_fts, rowid, text) VALUES('delete', old.id, old.text);\n    END;\n");
        this.conn.createStatement().execute("    CREATE TRIGGER IF NOT EXISTS xhtml_snippets_au AFTER UPDATE ON xhtml_snippets BEGIN\n      INSERT INTO xhtml_snippets_fts(xhtml_snippets_fts, rowid, text) VALUES('delete', old.id, old.text);\n      INSERT INTO xhtml_snippets_fts(rowid, text) VALUES (new.id, new.text);\n    END;\n");
        this.conn.createStatement().execute("    CREATE TABLE IF NOT EXISTS xhtml_file_state (\n      file_path TEXT PRIMARY KEY,\n      sha1 TEXT NOT NULL,\n      updated_at DATETIME DEFAULT CURRENT_TIMESTAMP\n    );\n");
        this.conn.createStatement().execute("    CREATE INDEX IF NOT EXISTS idx_file_state_sha ON xhtml_file_state(sha1);\n");
    }

    /*
     * Loose catch block
     */
    public long addSnippet(String text, String filePath, String anchor) throws Exception {
        this.check();
        float[] vec = OllamaClient.embedding(this.modelName, text);
        Throwable throwable = null;
        Object var6_7 = null;
        try (PreparedStatement ps = this.conn.prepareStatement("INSERT INTO xhtml_snippets(file_path, anchor, text, vec, dim) VALUES(?,?,?,?,?)", 1);){
            long l;
            ResultSet rs;
            Throwable throwable2;
            block19: {
                ps.setString(1, filePath);
                ps.setString(2, anchor);
                ps.setString(3, text);
                ps.setBytes(4, XhtmlMemoryService.floatsToBlob(vec));
                ps.setInt(5, vec.length);
                ps.executeUpdate();
                throwable2 = null;
                Object var9_12 = null;
                rs = ps.getGeneratedKeys();
                l = rs.next() ? rs.getLong(1) : -1L;
                if (rs == null) break block19;
                rs.close();
            }
            return l;
            {
                catch (Throwable throwable3) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public List<Result> searchSimilarFts(String query, int prefilterN, int topK) throws Exception {
        ResultSet rs;
        Object var10_18;
        Throwable throwable;
        PreparedStatement ps;
        this.check();
        float[] q = OllamaClient.embedding(this.modelName, query);
        q = XhtmlMemoryService.normalize(q);
        ArrayList<Long> candidateIds = new ArrayList<Long>();
        Throwable throwable2 = null;
        Object var7_9 = null;
        try {
            ps = this.conn.prepareStatement("    SELECT rowid FROM xhtml_snippets_fts\n    WHERE xhtml_snippets_fts MATCH ?\n    LIMIT ?\n");
            try {
                ps.setString(1, XhtmlMemoryService.normalizeFtsQuery(query));
                ps.setInt(2, Math.max(prefilterN, topK * 3));
                throwable = null;
                var10_18 = null;
                try {
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            candidateIds.add(rs.getLong(1));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        if (candidateIds.isEmpty()) {
            throwable2 = null;
            var7_9 = null;
            try {
                ps = this.conn.prepareStatement("    SELECT id FROM xhtml_snippets ORDER BY created_at DESC LIMIT ?\n");
                try {
                    ps.setInt(1, Math.max(prefilterN, topK * 3));
                    throwable = null;
                    var10_18 = null;
                    try {
                        rs = ps.executeQuery();
                        try {
                            while (rs.next()) {
                                candidateIds.add(rs.getLong(1));
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Throwable throwable6) {
                if (throwable2 == null) {
                    throwable2 = throwable6;
                } else if (throwable2 != throwable6) {
                    throwable2.addSuppressed(throwable6);
                }
                throw throwable2;
            }
        }
        if (candidateIds.isEmpty()) {
            return List.of();
        }
        String placeholders = candidateIds.stream().map(id -> "?").collect(Collectors.joining(","));
        HashMap<Long, Item> items = new HashMap<Long, Item>();
        Throwable throwable7 = null;
        throwable = null;
        try (PreparedStatement ps2 = this.conn.prepareStatement("SELECT id, file_path, anchor, text, vec, dim\nFROM xhtml_snippets WHERE id IN (" + placeholders + ")");){
            int idx = 1;
            for (Long id2 : candidateIds) {
                ps2.setLong(idx++, id2);
            }
            Throwable throwable8 = null;
            Iterator iterator = null;
            try (ResultSet rs2 = ps2.executeQuery();){
                while (rs2.next()) {
                    long id3 = rs2.getLong("id");
                    String file = rs2.getString("file_path");
                    String anchor = rs2.getString("anchor");
                    String txt = rs2.getString("text");
                    byte[] blob = rs2.getBytes("vec");
                    int dim = rs2.getInt("dim");
                    float[] v = XhtmlMemoryService.blobToFloats(blob, dim);
                    float score = XhtmlMemoryService.dot(q, v);
                    items.put(id3, new Item(id3, file, anchor, txt, score));
                }
            }
            catch (Throwable throwable9) {
                if (throwable8 == null) {
                    throwable8 = throwable9;
                } else if (throwable8 != throwable9) {
                    throwable8.addSuppressed(throwable9);
                }
                throw throwable8;
            }
        }
        catch (Throwable throwable10) {
            if (throwable7 == null) {
                throwable7 = throwable10;
            } else if (throwable7 != throwable10) {
                throwable7.addSuppressed(throwable10);
            }
            throw throwable7;
        }
        return items.values().stream().sorted((a, b) -> Float.compare(b.score, a.score)).limit(topK).map(i -> new Result(i.id, i.filePath, i.anchor, i.text, i.score)).collect(Collectors.toList());
    }

    private static String normalizeFtsQuery(String q) {
        String s = q.replaceAll("[^\\p{L}\\p{N}\\s]", " ").trim();
        if (s.isEmpty()) {
            return "*";
        }
        return String.join((CharSequence)" AND ", s.split("\\s+"));
    }

    private void check() {
        if (this.conn == null) {
            throw new IllegalStateException("XhtmlMemoryService not initialized. Call initIfNeeded().");
        }
    }

    private static byte[] floatsToBlob(float[] v) {
        ByteBuffer bb = ByteBuffer.allocate(v.length * 4).order(ByteOrder.LITTLE_ENDIAN);
        float[] fArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            float x = fArray[n2];
            bb.putFloat(x);
            ++n2;
        }
        return bb.array();
    }

    private static float[] blobToFloats(byte[] b, int dim) {
        int need = dim * 4;
        if (b == null || b.length < need) {
            throw new IllegalStateException("Invalid vector blob length: need=" + need + ", got=" + (b == null ? 0 : b.length));
        }
        FloatBuffer fb = ByteBuffer.wrap(b, 0, need).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        float[] out = new float[dim];
        fb.get(out);
        return out;
    }

    private static float dot(float[] a, float[] b) {
        float s = 0.0f;
        int i = 0;
        while (i < a.length) {
            s += a[i] * b[i];
            ++i;
        }
        return s;
    }

    @Override
    public void close() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (Exception exception) {}
    }

    public void deleteSnippetsByFile(String filePath) {
        this.check();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PreparedStatement ps = this.conn.prepareStatement("DELETE FROM xhtml_snippets WHERE file_path = ?");){
                ps.setString(1, filePath);
                ps.executeUpdate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("deleteSnippetsByFile \uc2e4\ud328: " + e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     */
    public String getStoredSha1(String filePath) {
        this.check();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PreparedStatement ps = this.conn.prepareStatement("SELECT sha1 FROM xhtml_file_state WHERE file_path = ?");){
                String string;
                ResultSet rs;
                Throwable throwable2;
                block21: {
                    ps.setString(1, filePath);
                    throwable2 = null;
                    Object var6_10 = null;
                    rs = ps.executeQuery();
                    string = rs.next() ? rs.getString(1) : null;
                    if (rs == null) break block21;
                    rs.close();
                }
                return string;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("getStoredSha1 \uc2e4\ud328: " + e.getMessage(), e);
        }
    }

    public void upsertFileSha1(String filePath, String sha1) {
        this.check();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PreparedStatement ps = this.conn.prepareStatement("    INSERT INTO xhtml_file_state(file_path, sha1, updated_at)\n    VALUES(?, ?, CURRENT_TIMESTAMP)\n    ON CONFLICT(file_path) DO UPDATE SET sha1=excluded.sha1, updated_at=CURRENT_TIMESTAMP\n");){
                ps.setString(1, filePath);
                ps.setString(2, sha1);
                ps.executeUpdate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("upsertFileSha1 \uc2e4\ud328: " + e.getMessage(), e);
        }
    }

    private static float[] normalize(float[] v) {
        double ss = 0.0;
        float[] fArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            float x = fArray[n2];
            ss += (double)x * (double)x;
            ++n2;
        }
        double norm = Math.sqrt(ss);
        if (norm == 0.0) {
            return v;
        }
        float inv = (float)(1.0 / norm);
        float[] out = new float[v.length];
        int i = 0;
        while (i < v.length) {
            out[i] = v[i] * inv;
            ++i;
        }
        return out;
    }

    private static class Item {
        long id;
        String filePath;
        String anchor;
        String text;
        float score;

        Item(long id, String filePath, String anchor, String text, float score) {
            this.id = id;
            this.filePath = filePath;
            this.anchor = anchor;
            this.text = text;
            this.score = score;
        }
    }

    public static class Result {
        public final long id;
        public final String filePath;
        public final String anchor;
        public final String text;
        public final float score;

        public Result(long id, String filePath, String anchor, String text, float score) {
            this.id = id;
            this.filePath = filePath;
            this.anchor = anchor;
            this.text = text;
            this.score = score;
        }

        public String toString() {
            return "score=%.4f | %s#%s%n%s".formatted(Float.valueOf(this.score), this.filePath, this.anchor == null ? "" : this.anchor, this.text);
        }
    }
}

