/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.managers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;

public class ContentOpfManager {
    private static ContentOpfManager instance;
    private static IFile fileContentOpf;
    private static final String[] REQUIRED_METADATA;

    static {
        REQUIRED_METADATA = new String[]{"<meta property=\"schema:accessMode\">textual</meta>", "<meta property=\"schema:accessModeSufficient\">textual</meta>", "<meta property=\"schema:accessibilitySummary\">\uc774 \uc804\uc790\ucc45\uc740 \uad6c\uc870\uc801 \ud0d0\uc0c9 \ubc0f \ud14d\uc2a4\ud2b8 \uae30\ubc18 \uc811\uadfc\uc774 \uac00\ub2a5\ud569\ub2c8\ub2e4.</meta>", "<meta property=\"schema:accessibilityFeature\">tableOfContents</meta>", "<meta property=\"schema:accessibilityHazard\">none</meta>", "<meta property=\"schema:accessibilityFeature\">structuralNavigation</meta>"};
    }

    private ContentOpfManager() {
    }

    public static ContentOpfManager getInstance() {
        if (instance == null) {
            instance = new ContentOpfManager();
        }
        ContentOpfManager.setContentOpf();
        return instance;
    }

    public static void setContentOpf() {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Text");
        fileContentOpf = iFolder.getProject().getFile("OEBPS/content.opf");
    }

    public void updateMenifestAndSpine(String fileName) {
        System.out.println("updateMenifestAndSpine()");
        System.out.println("updateMenifestAndSpine() fileName : " + fileName);
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        System.out.println("updateMenifestAndSpine() projectName : " + projectName);
        boolean isXhtml = fileName.toLowerCase().endsWith(".xhtml");
        boolean addToScripted = false;
        boolean addLinearNo = false;
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Text");
        String href = iFolder.getProjectRelativePath().append(fileName).toString().substring("OEBPS/".length());
        String id = fileName.replaceAll("[^a-zA-Z0-9]", "_");
        OpfNcxUpdater.addFileToOpf(fileContentOpf, id, href, OpfNcxUpdater.getMediaType(fileName), isXhtml, addToScripted, addLinearNo);
    }

    public void updateMetadata(String chapter, String totalDurationStr) {
        OpfNcxUpdater.addMetadataToOpf(fileContentOpf, chapter, totalDurationStr);
    }

    public void updateMetadataDuration() {
        OpfNcxUpdater.setTotalDuration(fileContentOpf);
    }

    public void addImage(String imgName) {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Images");
        String fullPath = iFolder.getProjectRelativePath().append(imgName).toString();
        String href = fullPath.startsWith("OEBPS/") ? fullPath.substring("OEBPS/".length()) : fullPath;
        String id = imgName.replaceAll("[^a-zA-Z0-9\uac00-\ud7a3]", "_");
        boolean isXhtml = imgName.toLowerCase().endsWith(".xhtml");
        boolean addToScripted = isXhtml;
        boolean addLinearNo = false;
        OpfNcxUpdater.addFileToOpf(fileContentOpf, id, href, OpfNcxUpdater.getMediaType(imgName), isXhtml, addToScripted, addLinearNo);
    }

    public static void ensureAccessibilityMetadata(File opfFile) {
        try {
            String content = Files.readString(opfFile.toPath());
            int metadataStart = content.indexOf("<metadata");
            int metadataEnd = content.indexOf("</metadata>");
            if (metadataStart == -1 || metadataEnd == -1) {
                System.err.println("\u274c metadata \ud0dc\uadf8\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return;
            }
            Object before = content.substring(0, metadataEnd);
            String after = content.substring(metadataEnd);
            String[] stringArray = REQUIRED_METADATA;
            int n = REQUIRED_METADATA.length;
            int n2 = 0;
            while (n2 < n) {
                String meta = stringArray[n2];
                if (!((String)before).contains(meta)) {
                    before = (String)before + "\n    " + meta;
                    System.out.println("\u2795 \uba54\ud0c0\ub370\uc774\ud130 \ucd94\uac00: " + meta);
                } else {
                    System.out.println("\u2705 \uc774\ubbf8 \uc874\uc7ac: " + meta);
                }
                ++n2;
            }
            String updated = (String)before + after;
            Files.writeString(opfFile.toPath(), (CharSequence)updated, StandardOpenOption.TRUNCATE_EXISTING);
            System.out.println("\u2705 OPF \uba54\ud0c0\ub370\uc774\ud130 \uc5c5\ub370\uc774\ud2b8 \uc644\ub8cc: " + opfFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("\u274c \ud30c\uc77c \ucc98\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
        }
    }
}

