/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.managers;

import kr.co.goms.epub.managers.ExplorerNodeManager;
import kr.co.goms.epub.menu.ExplorerNode;
import kr.co.goms.epub.solution.lifecycle.EpubE4Application;
import kr.co.goms.epub.solution.parts.EpubPreviewPart;
import kr.co.goms.epub.solution.parts.ProjectExplorerPart;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Display;

public class EpubPartManager {
    private static EpubPartManager instance;
    private EpubE4Application ePubApp;

    private EpubPartManager() {
    }

    public static EpubPartManager getInstance() {
        if (instance == null) {
            instance = new EpubPartManager();
        }
        return instance;
    }

    public void setApp(EpubE4Application app) {
        this.ePubApp = app;
    }

    public void setProgress(int value) {
        if (this.ePubApp != null) {
            this.ePubApp.setProgress(value);
        }
    }

    public void setMessage(String msg) {
        if (this.ePubApp != null) {
            this.ePubApp.setMessage(msg);
        }
    }

    public void moveSmilPart(MApplication application, EPartService partService, EModelService modelService, ExplorerNode selectedNode) {
        MPartSashContainer container = (MPartSashContainer)modelService.find("kr.co.goms.epub.solution.partsashcontainer.main", (MUIElement)application);
        if (container == null) {
            System.err.println("PartSashContainer not found");
            return;
        }
        String label = selectedNode.name + " \uc74c\uc131";
        String editorId = "kr.co.goms.epub.solution.parts.smiltreeviewer";
        String stack = "kr.co.goms.epub.solution.parts.editpartstack";
        MPartStack partStack = (MPartStack)modelService.find(stack, (MUIElement)application);
        if (partStack == null) {
            System.err.println("PartStack not found");
            return;
        }
        for (MPart part : partService.getParts()) {
            if (!editorId.equals(part.getElementId()) || !label.equals(part.getLabel())) continue;
            partService.showPart(part, EPartService.PartState.ACTIVATE);
            return;
        }
        String uri = "bundleclass://epubtest03/kr.co.goms.epub.solution.parts.PageElementViewPart";
        MPart epubPart = (MPart)modelService.createModelElement(MPart.class);
        epubPart.setElementId(editorId);
        epubPart.setLabel(label);
        epubPart.setContributionURI(uri);
        epubPart.setCloseable(true);
        epubPart.getPersistedState().put("xhtmlName", selectedNode.name);
        partStack.getChildren().add(epubPart);
        partService.showPart(epubPart, EPartService.PartState.ACTIVATE);
    }

    public void movePreviewPart(MApplication application, EPartService partService, EModelService modelService, ExplorerNode selectedNode) {
        Object object;
        MPartSashContainer container = (MPartSashContainer)modelService.find("kr.co.goms.epub.solution.partsashcontainer.main", (MUIElement)application);
        if (container == null) {
            System.err.println("PartSashContainer not found");
            return;
        }
        String label = selectedNode.name;
        String editorId = "kr.co.goms.epub.solution.parts.previewpartstack";
        for (MPart part : partService.getParts()) {
            if (!editorId.equals(part.getElementId()) || !label.equals(part.getLabel())) continue;
            partService.showPart(part, EPartService.PartState.ACTIVATE);
            return;
        }
        MPart aiPart = partService.showPart("kr.co.goms.epub.solution.parts.aihtmlviewerpart", EPartService.PartState.VISIBLE);
        IFile file = selectedNode.getIFile();
        String filePath = null;
        if (file != null && file.exists()) {
            filePath = file.getLocation().toOSString();
        }
        if (aiPart != null && (object = aiPart.getObject()) instanceof EpubPreviewPart) {
            EpubPreviewPart preview = (EpubPreviewPart)object;
            if (this.isImgExtension(selectedNode)) {
                preview.setImage(filePath);
            } else if (file != null && file.exists()) {
                preview.setPreviewContent(filePath);
            }
        }
    }

    public void addPreviewPart(MApplication application, EPartService partService, EModelService modelService, String targetContributionURI, String title, String message) {
        Display.getDefault().asyncExec(() -> {
            String contributionURI = this.getContributionURI(targetContributionURI);
            MPart epubPart = (MPart)modelService.createModelElement(MPart.class);
            epubPart.setElementId("kr.co.goms.epub.solution.parts.epubcheckresultpart_new");
            epubPart.setLabel("EPUB\uac80\uc99d>" + title);
            epubPart.setContributionURI(contributionURI);
            epubPart.setCloseable(true);
            epubPart.getTransientData().put("title", title);
            epubPart.getTransientData().put("message", message);
            String partStack = "kr.co.goms.epub.solution.parts.previewpartstack";
            MPartStack previewPartStack = (MPartStack)modelService.find(partStack, (MUIElement)application);
            previewPartStack.getChildren().add(epubPart);
            partService.showPart(epubPart, EPartService.PartState.ACTIVATE);
            IEclipseContext partContext = epubPart.getContext();
            if (partContext != null) {
                partContext.set("title", (Object)title);
                partContext.set("message", (Object)message);
            }
        });
    }

    public void addAiHtmlViewerPart(MApplication application, EPartService partService, EModelService modelService, String targetContributionURI, String title, String message) {
        Display.getDefault().asyncExec(() -> {
            String contributionURI = this.getContributionURI(targetContributionURI);
            System.out.println("contributionURI : " + contributionURI);
            MPart epubPart = (MPart)modelService.createModelElement(MPart.class);
            epubPart.setElementId("kr.co.goms.epub.solution.parts.aihtmlviewer_new");
            epubPart.setLabel("AI > " + title);
            epubPart.setContributionURI(contributionURI);
            epubPart.setCloseable(true);
            epubPart.getTransientData().put("title", title);
            epubPart.getTransientData().put("message", message);
            String partStack = "kr.co.goms.epub.solution.parts.previewpartstack";
            MPartStack previewPartStack = (MPartStack)modelService.find(partStack, (MUIElement)application);
            previewPartStack.getChildren().add(epubPart);
            partService.showPart(epubPart, EPartService.PartState.CREATE);
            partService.showPart(epubPart, EPartService.PartState.ACTIVATE);
            IEclipseContext partContext = epubPart.getContext();
            if (partContext != null) {
                partContext.set("title", (Object)title);
                partContext.set("message", (Object)message);
            }
        });
    }

    public void refreshProjectExplorer(EPartService partService, String menuName) {
        Object object;
        ExplorerNode explorerNode = ExplorerNodeManager.getInstance().getNode(menuName);
        MPart part = partService.findPart("kr.co.goms.epub.solution.parts.projectexplorer");
        if (part != null && (object = part.getObject()) instanceof ProjectExplorerPart) {
            ProjectExplorerPart explorerPart = (ProjectExplorerPart)object;
            explorerPart.refreshProjectExplorer(explorerNode);
        }
    }

    public void refreshProjectExplorer(EPartService partService) {
        Object object;
        MPart part = partService.findPart("kr.co.goms.epub.solution.parts.projectexplorer");
        if (part != null && (object = part.getObject()) instanceof ProjectExplorerPart) {
            ProjectExplorerPart explorerPart = (ProjectExplorerPart)object;
            explorerPart.refreshProjectExplorer(null);
        }
    }

    private boolean isImgExtension(ExplorerNode node) {
        String name = node.name.toLowerCase();
        return name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif") || name.endsWith(".bmp");
    }

    private String getContributionURI(String part) {
        System.out.println("getContributionURI() > part : " + part);
        String resultPart = "";
        if ("EpubCheckResultPart".equals(part)) {
            resultPart = "bundleclass://epubtest03/kr.co.goms.epub.solution.parts.EpubCheckResultPart";
        } else if ("AiHtmlChatViewPart".equals(part)) {
            resultPart = "bundleclass://epubtest03/kr.co.goms.epub.solution.parts.AiHtmlChatViewPart";
        }
        return resultPart;
    }
}

