/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.pdf;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CssColorUpdater {
    private static final String[] HEADING_SELECTORS = new String[]{"h1", "h2", "h3", "h4", "h5"};
    private static final String[] BODY_SELECTORS = new String[]{"p"};

    public static void updateColors(Path cssPath, String headingColor, String bodyColor) throws IOException {
        String sel;
        String css = Files.readString(cssPath);
        String[] stringArray = HEADING_SELECTORS;
        int n = HEADING_SELECTORS.length;
        int n2 = 0;
        while (n2 < n) {
            sel = stringArray[n2];
            css = CssColorUpdater.upsertColor(css, sel, headingColor);
            ++n2;
        }
        stringArray = BODY_SELECTORS;
        n = BODY_SELECTORS.length;
        n2 = 0;
        while (n2 < n) {
            sel = stringArray[n2];
            css = CssColorUpdater.upsertColor(css, sel, bodyColor);
            ++n2;
        }
        Files.writeString(cssPath, (CharSequence)css, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String upsertColor(String css, String selector, String colorHex) {
        String blockRegex = "(?s)(\\b" + Pattern.quote(selector) + "\\b\\s*\\{)(.*?)(\\})";
        Pattern block = Pattern.compile(blockRegex);
        Pattern colorProp = Pattern.compile("(?i)\\bcolor\\s*:\\s*[^;]*;?");
        Matcher m = block.matcher(css);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String open = m.group(1);
            Object body = m.group(2);
            String close = m.group(3);
            Matcher cm = colorProp.matcher((CharSequence)body);
            body = cm.find() ? cm.replaceFirst("color:" + colorHex + ";") : "color:" + colorHex + ";" + (String)(((String)body).trim().isEmpty() ? "" : " " + (String)body);
            String replacement = open + (String)body + close;
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

