/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.pdf;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.state.PDGraphicsState;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PdfFontSizeAnalyzer
extends PDFTextStripper {
    private final List<LineInfo> lines = new ArrayList<LineInfo>();
    private LineInfo current;
    private final float yMergeThreshold = 2.0f;
    private float pageWidth = 595.0f;

    public PdfFontSizeAnalyzer() throws IOException {
        this.setSortByPosition(true);
    }

    protected void startPage(PDPage page) throws IOException {
        super.startPage(page);
        this.current = null;
        if (page != null && page.getMediaBox() != null) {
            this.pageWidth = page.getMediaBox().getWidth();
        }
    }

    protected void processTextPosition(TextPosition tp) {
        try {
            float fs = tp.getFontSizeInPt();
            String fn = "unknown";
            boolean bold = false;
            PDFont font = tp.getFont();
            if (font != null) {
                PDFontDescriptor desc;
                String name = font.getName();
                if (name != null) {
                    fn = name;
                }
                if ((desc = font.getFontDescriptor()) != null && desc.getFontWeight() >= 600.0f) {
                    bold = true;
                }
            }
            if (fn.toLowerCase().contains("bold")) {
                bold = true;
            }
            float x = tp.getXDirAdj();
            float y = tp.getYDirAdj();
            String colorHex = null;
            try {
                PDColor pdColor;
                PDGraphicsState gs = this.getGraphicsState();
                if (gs != null && (pdColor = gs.getNonStrokingColor()) != null) {
                    int rgb = pdColor.toRGB();
                    Color awt = new Color(rgb, true);
                    colorHex = PdfFontSizeAnalyzer.toHex(awt);
                }
            }
            catch (Exception exception) {}
            if (this.current == null || Math.abs(this.current.y() - y) > 2.0f) {
                this.current = new LineInfo();
                this.lines.add(this.current);
            }
            this.current.chars.add(new CharInfo(tp.getUnicode(), x, y, fs, fn, bold, colorHex));
        }
        catch (Exception exception) {}
    }

    private static String toHex(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    protected void writeString(String text, List<TextPosition> positions) throws IOException {
        for (TextPosition tp : positions) {
            float fs = tp.getFontSizeInPt();
            String fn = tp.getFont() != null && tp.getFont().getName() != null ? tp.getFont().getName() : "unknown";
            boolean bold = fn.toLowerCase().contains("bold") || tp.getFont() != null && tp.getFont().getFontDescriptor() != null && tp.getFont().getFontDescriptor().getFontWeight() >= 600.0f;
            float x = tp.getXDirAdj();
            float y = tp.getYDirAdj();
            String colorHex = null;
            try {
                PDColor pdColor;
                PDGraphicsState gs = this.getGraphicsState();
                if (gs != null && (pdColor = gs.getNonStrokingColor()) != null) {
                    int rgb = pdColor.toRGB();
                    Color awt = new Color(rgb, true);
                    colorHex = PdfFontSizeAnalyzer.toHex(awt);
                }
            }
            catch (Exception exception) {}
            if (this.current == null || Math.abs(this.current.y() - y) > 2.0f) {
                this.current = new LineInfo();
                this.lines.add(this.current);
            }
            this.current.chars.add(new CharInfo(tp.getUnicode(), x, y, fs, fn, bold, colorHex));
        }
        super.writeString(text, positions);
    }

    public List<LineInfo> getLines() {
        return this.lines;
    }

    public static List<LineInfo> extract(PDDocument doc, int page) throws IOException {
        PdfFontSizeAnalyzer s = new PdfFontSizeAnalyzer();
        s.setStartPage(page);
        s.setEndPage(page);
        s.writeText(doc, new OutputStreamWriter(OutputStream.nullOutputStream()));
        return s.getLines();
    }

    public static class CharInfo {
        public final String text;
        public final float x;
        public final float y;
        public final float fontSizePt;
        public final String fontName;
        public final boolean bold;
        public final String colorHex;

        public CharInfo(String t, float x, float y, float fs, String fn, boolean bold, String colorHex) {
            this.text = t;
            this.x = x;
            this.y = y;
            this.fontSizePt = fs;
            this.fontName = fn;
            this.bold = bold;
            this.colorHex = colorHex;
        }
    }

    public static class LineInfo {
        public final List<CharInfo> chars = new ArrayList<CharInfo>();

        public String getText() {
            return this.chars.stream().map(c -> c.text).collect(Collectors.joining());
        }

        public float avgFont() {
            return (float)this.chars.stream().mapToDouble(c -> c.fontSizePt).average().orElse(0.0);
        }

        public float y() {
            return this.chars.isEmpty() ? 0.0f : this.chars.get((int)0).y;
        }

        public boolean isBold() {
            return this.chars.stream().filter(c -> c.text.trim().length() > 0).anyMatch(c -> c.bold);
        }

        public float left() {
            return this.chars.stream().map(c -> Float.valueOf(c.x)).min(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
        }

        public float right() {
            return this.chars.stream().map(c -> Float.valueOf(c.x)).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
        }

        public boolean isCentered(float pageWidth) {
            float margin = 20.0f;
            float mid = (this.left() + this.right()) / 2.0f;
            return mid > pageWidth * 0.45f && mid < pageWidth * 0.55f && Math.abs(this.left()) > margin && pageWidth - this.right() > margin;
        }

        public String dominantColorHex() {
            return this.chars.stream().filter(c -> c.colorHex != null).collect(Collectors.groupingBy(c -> c.colorHex, Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        }
    }
}

