/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.smil;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import kr.co.goms.epub.solution.dialogs.SmilViewerDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SmilParser {
    public static List<SmilViewerDialog.SmilEntry> parse(File smilFile) {
        ArrayList<SmilViewerDialog.SmilEntry> list = new ArrayList<SmilViewerDialog.SmilEntry>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(smilFile);
            NodeList parList = doc.getElementsByTagName("par");
            int i = 0;
            while (i < parList.getLength()) {
                Element par = (Element)parList.item(i);
                Element text = (Element)par.getElementsByTagName("text").item(0);
                Element audio = (Element)par.getElementsByTagName("audio").item(0);
                String[] textParts = text.getAttribute("src").split("#");
                String textId = textParts.length > 1 ? textParts[1] : "";
                String audioPath = new File(smilFile.getParentFile(), audio.getAttribute("src")).getAbsolutePath();
                list.add(new SmilViewerDialog.SmilEntry(textId, audioPath));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

