/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.smil;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import kr.co.goms.epub.managers.ContentOpfManager;
import kr.co.goms.epub.solution.tts.TtsUsageTracker;
import kr.co.goms.epub.solution.ui.PageElement;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.utils.GoogleTtsUtil;
import kr.co.goms.epub.solution.utils.XHTMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmilWriter {
    private final File smilFile;
    private final String xhtmlFileName;
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("0.000");

    public SmilWriter(String smilFilePath, String xhtmlFileName) {
        this.smilFile = new File(smilFilePath);
        this.xhtmlFileName = xhtmlFileName;
    }

    public void addOrUpdatePar(String elementId, String audioFilePath) throws Exception {
        Element body;
        Document doc;
        if (this.smilFile.exists()) {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.smilFile);
            body = (Element)doc.getElementsByTagName("body").item(0);
        } else {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element smil = doc.createElement("smil");
            smil.setAttribute("xmlns", "http://www.w3.org/ns/SMIL");
            smil.setAttribute("xmlns:epub", "http://www.idpf.org/2007/ops");
            smil.setAttribute("version", "3.0");
            doc.appendChild(smil);
            body = doc.createElement("body");
            smil.appendChild(body);
        }
        NodeList parList = body.getElementsByTagName("par");
        int i = 0;
        while (i < parList.getLength()) {
            Element textElem;
            Element par = (Element)parList.item(i);
            Node textNode = par.getElementsByTagName("text").item(0);
            if (textNode instanceof Element && (textElem = (Element)textNode).getAttribute("src").contains("#" + elementId)) {
                body.removeChild(par);
                break;
            }
            ++i;
        }
        Element par = doc.createElement("par");
        Element text = doc.createElement("text");
        text.setAttribute("src", this.xhtmlFileName + "#" + elementId);
        par.appendChild(text);
        Element audio = doc.createElement("audio");
        audio.setAttribute("src", audioFilePath);
        par.appendChild(audio);
        body.appendChild(par);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        Throwable throwable = null;
        Object var11_13 = null;
        try (FileOutputStream out = new FileOutputStream(this.smilFile);){
            transformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void convertAllChapters(String xhtmlFolderPath) {
        File dir = new File(xhtmlFolderPath);
        File[] files = dir.listFiles((d, name) -> name.endsWith(".xhtml"));
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String chapterId = file.getName().replace(".xhtml", "");
            List<PageElement> list = XHTMLParser.parseXhtml(file);
            SmilWriter writer = new SmilWriter(xhtmlFolderPath + "/../Smil/" + chapterId + ".smil", "Text/" + file.getName());
            for (PageElement el : list) {
                String text = el.getContent();
                if (!TtsUsageTracker.canConvert(text.length())) continue;
                String mp3File = "Audio/" + el.getId() + ".mp3";
                try {
                    GoogleTtsUtil.synthesizeToFile(text, xhtmlFolderPath + "/../" + mp3File, GoogleTtsUtil.VoiceGender.NEUTRAL);
                    TtsUsageTracker.addCount(text.length());
                    writer.addOrUpdatePar(el.getId(), mp3File);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static File[] getAllChapters() {
        File dir = new File(EpubBuildUtil.getProjectOEBPSSubFolder("Audio"));
        File[] files = dir.listFiles((d, name) -> name.endsWith(".xhtml"));
        return files;
    }

    public static void generateSmilFilesFromAudio() throws Exception {
        File audioDir = new File(EpubBuildUtil.getProjectAudioPath());
        if (!audioDir.exists() || !audioDir.isDirectory()) {
            return;
        }
        File[] files = audioDir.listFiles((dir, name) -> name.matches("chapter\\d+_(p|h[1-6]|img)_\\d+\\.mp3"));
        if (files == null) {
            return;
        }
        HashMap<String, List> chapterMap = new HashMap<String, List>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f2 = fileArray[n2];
            String name2 = f2.getName();
            int underscore = name2.indexOf("_");
            String chapterBase = name2.substring(0, underscore);
            chapterMap.computeIfAbsent(chapterBase, k -> new ArrayList()).add(f2);
            ++n2;
        }
        Pattern pattern = Pattern.compile("_(p|h[1-6]|img)_([0-9]+)\\.mp3$");
        for (String chapter : chapterMap.keySet()) {
            List mp3Files = (List)chapterMap.get(chapter);
            mp3Files.sort(Comparator.comparingInt(f -> {
                Matcher matcher = pattern.matcher(f.getName());
                if (matcher.find()) {
                    return Integer.parseInt(matcher.group(2));
                }
                return Integer.MAX_VALUE;
            }));
            SmilWriter.createSmilFile(chapter, mp3Files);
        }
    }

    public static void createSmilFile(String chapter, List<File> mp3Files) throws Exception {
        String smilPath = EpubBuildUtil.getProjectOEBPSSubFolder("Smil") + "/" + chapter + ".smil";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document smilDoc = builder.newDocument();
        Element smil = smilDoc.createElement("smil");
        smil.setAttribute("xmlns", "http://www.w3.org/ns/SMIL");
        smil.setAttribute("xmlns:epub", "http://www.idpf.org/2007/ops");
        smil.setAttribute("version", "3.0");
        smilDoc.appendChild(smil);
        Element body = smilDoc.createElement("body");
        smil.appendChild(body);
        Element seq = smilDoc.createElement("seq");
        seq.setAttribute("id", "seq_" + chapter);
        seq.setAttributeNS("http://www.idpf.org/2007/ops", "epub:textref", "../Text/" + chapter + ".xhtml#body");
        body.appendChild(seq);
        double totalDuration = 0.0;
        for (File f : mp3Files) {
            String id = f.getName().replace(".mp3", "");
            double duration = SmilWriter.getMp3DurationInSeconds(f);
            totalDuration += duration;
            String clipEnd = TIME_FORMAT.format(duration);
            Element par = smilDoc.createElement("par");
            Element text = smilDoc.createElement("text");
            text.setAttribute("src", "../Text/" + chapter + ".xhtml#" + id);
            par.appendChild(text);
            Element audio = smilDoc.createElement("audio");
            audio.setAttribute("src", "../Audio/" + f.getName());
            audio.setAttribute("clipBegin", "0.000");
            audio.setAttribute("clipEnd", clipEnd);
            par.appendChild(audio);
            seq.appendChild(par);
        }
        String totalDurationStr = TIME_FORMAT.format(totalDuration);
        ContentOpfManager.getInstance().updateMetadata(chapter, totalDurationStr);
        SmilWriter.saveDocument(smilDoc, smilPath);
    }

    public static void processAllAuthorAndChapters(ChapterProcessingCallback callback) throws Exception {
        File audioRoot = new File(EpubBuildUtil.getProjectOEBPSSubFolder("Audio"));
        if (!audioRoot.exists()) {
            System.out.println("\u2705 Audio \ud3f4\ub354\uc5c6\uc74c");
            return;
        }
        Map<String, List<File>> authorMp3Map = SmilWriter.collectAuthorMp3Files(audioRoot);
        Map<String, List<File>> chapterMp3Map = SmilWriter.collectChapterMp3Files(audioRoot);
        HashMap<String, List> mergedMap = new HashMap<String, List>();
        for (Map.Entry<String, List<File>> entry : authorMp3Map.entrySet()) {
            mergedMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        for (Map.Entry<String, List<File>> entry : chapterMp3Map.entrySet()) {
            mergedMap.computeIfAbsent(entry.getKey(), k -> new ArrayList()).addAll((Collection)entry.getValue());
        }
        for (String chapter : mergedMap.keySet()) {
            List mp3Files = (List)mergedMap.get(chapter);
            SmilWriter.createSmilFile(chapter, mp3Files);
            SmilWriter.updateOpf(chapter, mp3Files);
            if (callback == null) continue;
            callback.onChapterProcessed(chapter, mp3Files);
        }
        if (callback != null) {
            callback.onComplite();
        }
    }

    private static Map<String, List<File>> collectAuthorMp3Files(File audioRoot) {
        TreeMap<String, List<File>> map = new TreeMap<String, List<File>>();
        Pattern mp3FilePattern = Pattern.compile("^(author)_((p|li|h[1-6]|img))_(\\d+)\\.mp3$");
        File[] fileArray = Objects.requireNonNull(audioRoot.listFiles());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f2 = fileArray[n2];
            String name = f2.getName();
            Matcher matcher = mp3FilePattern.matcher(name);
            if (matcher.matches()) {
                String chapter = matcher.group(1);
                map.computeIfAbsent(chapter, k -> new ArrayList()).add(f2);
            }
            ++n2;
        }
        for (List list : map.values()) {
            list.sort(Comparator.comparingInt(f -> {
                Matcher m = mp3FilePattern.matcher(f.getName());
                if (m.matches()) {
                    try {
                        return Integer.parseInt(m.group(4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return Integer.MAX_VALUE;
                    }
                }
                return Integer.MAX_VALUE;
            }));
        }
        return map;
    }

    private static Map<String, List<File>> collectChapterMp3Files(File audioRoot) {
        TreeMap<String, List<File>> map = new TreeMap<String, List<File>>();
        Pattern mp3FilePattern = Pattern.compile("^(chapter\\d+)_((p|li|h[1-6]|img))_(\\d+)\\.mp3$");
        File[] fileArray = Objects.requireNonNull(audioRoot.listFiles());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f2 = fileArray[n2];
            String name = f2.getName();
            Matcher matcher = mp3FilePattern.matcher(name);
            if (matcher.matches()) {
                String chapter = matcher.group(1);
                map.computeIfAbsent(chapter, k -> new ArrayList()).add(f2);
            }
            ++n2;
        }
        for (List list : map.values()) {
            list.sort(Comparator.comparingInt(f -> {
                Matcher m = mp3FilePattern.matcher(f.getName());
                if (m.matches()) {
                    try {
                        return Integer.parseInt(m.group(4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return Integer.MAX_VALUE;
                    }
                }
                return Integer.MAX_VALUE;
            }));
        }
        return map;
    }

    public List<File> findMp3FilesForChapter(String chapter) {
        System.out.println("findMp3FilesForChapter : " + chapter);
        File audioDir = new File(EpubBuildUtil.getProjectOEBPSSubFolder("Audio"));
        if (!audioDir.exists() || !audioDir.isDirectory()) {
            return Collections.emptyList();
        }
        Pattern pattern = Pattern.compile(Pattern.quote(chapter) + "_(p|li|h[1-6]|img)_([0-9]+)\\.mp3");
        File[] matchedFiles = audioDir.listFiles((dir, name) -> pattern.matcher(name).matches());
        if (matchedFiles == null) {
            return Collections.emptyList();
        }
        System.out.println("matchedFiles.length : " + matchedFiles.length);
        List<File> sorted = Arrays.asList(matchedFiles);
        sorted.sort(Comparator.comparingInt(f -> {
            Matcher matcher = pattern.matcher(f.getName());
            if (matcher.find()) {
                try {
                    return Integer.parseInt(matcher.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    return Integer.MAX_VALUE;
                }
            }
            return Integer.MAX_VALUE;
        }));
        return sorted;
    }

    public static void updateOpf(String chapter, List<File> mp3Files) throws Exception {
        String contentOpf = EpubBuildUtil.getProjectOEBPSContentOpfFile();
        File opfFile = new File(contentOpf);
        System.out.println("\u2705 opfFile.getAbsolutePath() : " + opfFile.getAbsolutePath());
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(opfFile);
        Node manifest = doc.getElementsByTagName("manifest").item(0);
        doc.getElementsByTagName("spine").item(0);
        for (File mp3 : mp3Files) {
            String id = mp3.getName().replace(".mp3", "");
            SmilWriter.addItemIfMissing(doc, manifest, "Audio/" + mp3.getName(), id + "_mp3", "audio/mpeg");
        }
        SmilWriter.addItemIfMissing(doc, manifest, "Smil/" + chapter + ".smil", chapter + "_smil", "application/smil+xml");
        String textId = chapter;
        SmilWriter.updateItemWithOverlay(doc, textId, chapter + "_smil");
        SmilWriter.saveDocument(doc, contentOpf);
    }

    private static void addItemIfMissing(Document doc, Node manifest, String href, String id, String mediaType) {
        NodeList items = doc.getElementsByTagName("item");
        int i = 0;
        while (i < items.getLength()) {
            Element e = (Element)items.item(i);
            if (href.equals(e.getAttribute("href"))) {
                return;
            }
            ++i;
        }
        Element item = doc.createElement("item");
        item.setAttribute("id", id);
        item.setAttribute("href", href);
        item.setAttribute("media-type", mediaType);
        manifest.appendChild(item);
    }

    private static void updateItemWithOverlay(Document doc, String xhtmlId, String overlayId) {
        NodeList items = doc.getElementsByTagName("item");
        int i = 0;
        while (i < items.getLength()) {
            Element e = (Element)items.item(i);
            if (e.getAttribute("href").equals("Text/" + xhtmlId + ".xhtml")) {
                e.setAttribute("media-overlay", overlayId);
            }
            ++i;
        }
    }

    private static double getMp3DurationInSeconds(File mp3File) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(mp3File));){
            Bitstream bitstream = new Bitstream((InputStream)in);
            Header header = bitstream.readFrame();
            int size = (int)mp3File.length();
            return (double)header.total_ms(size) / 1000.0;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void saveDocument(Document doc, String outPath) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
        String xmlContent = stringWriter.toString();
        String cleanedXml = Arrays.stream(xmlContent.split("\n")).filter(line -> !line.trim().isEmpty()).collect(Collectors.joining("\n"));
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outPath), StandardCharsets.UTF_8));){
            writer.write(cleanedXml);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static interface ChapterProcessingCallback {
        public void onChapterProcessed(String var1, List<File> var2);

        public void onComplite();
    }
}

