/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.dialogs;

import kr.co.goms.epub.solution.preferences.ColorPreference;
import kr.co.goms.epub.solution.utils.EpubColorUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class ColorPaletteDialog
extends Dialog {
    private float[] currentHSV = new float[]{0.0f, 1.0f, 1.0f};
    private Scale hueScale;
    private Canvas pickerCanvas;
    private Composite previewBox;
    private Label infoLabel;
    private final Shell parentShell;
    private final ColorSelectedCallback callback;
    private Color backgroundColor;

    public ColorPaletteDialog(Shell parent, ColorSelectedCallback callback) {
        super(parent);
        this.parentShell = parent;
        this.callback = callback;
        this.backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
    }

    public int open() {
        Shell shell = new Shell(this.parentShell, 67680);
        shell.setText("\uceec\ub7ec \uc120\ud0dd");
        shell.setLayout((Layout)new GridLayout(2, false));
        shell.setBackground(this.backgroundColor);
        int[] result = new int[]{1};
        this.createHueSlider((Composite)shell);
        this.createSVPicker((Composite)shell);
        this.createPreview((Composite)shell);
        this.createRecentColors((Composite)shell);
        this.createButtons((Composite)shell);
        shell.pack();
        shell.open();
        Display display = this.parentShell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result[0];
    }

    private void createHueSlider(Composite parent) {
        Label hue = new Label(parent, 0);
        hue.setText("Hue:");
        hue.setBackground(this.backgroundColor);
        this.hueScale = new Scale(parent, 256);
        this.hueScale.setMaximum(360);
        this.hueScale.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hueScale.setSelection((int)this.currentHSV[0]);
        this.hueScale.addListener(13, e -> {
            this.currentHSV[0] = this.hueScale.getSelection();
            this.pickerCanvas.redraw();
            this.updatePreview(this.previewBox, this.infoLabel);
        });
        this.hueScale.setBackground(this.backgroundColor);
    }

    private void createSVPicker(Composite parent) {
        Label sv = new Label(parent, 0);
        sv.setText("Saturation/Value:");
        sv.setBackground(this.backgroundColor);
        this.pickerCanvas = new Canvas(parent, 2048);
        this.pickerCanvas.setLayoutData((Object)new GridData(200, 200));
        this.pickerCanvas.addPaintListener(e -> {
            GC gc = e.gc;
            int y = 0;
            while (y < 200) {
                int x = 0;
                while (x < 200) {
                    float s = (float)x / 199.0f;
                    float v = 1.0f - (float)y / 199.0f;
                    float[] hsv = new float[]{this.currentHSV[0], s, v};
                    RGB rgb = EpubColorUtil.hsvToRGB(hsv);
                    gc.setForeground(new Color((Device)parent.getDisplay(), rgb));
                    gc.drawPoint(x, y);
                    ++x;
                }
                ++y;
            }
        });
        this.pickerCanvas.addListener(3, e -> {
            this.currentHSV[1] = (float)e.x / 199.0f;
            this.currentHSV[2] = 1.0f - (float)e.y / 199.0f;
            this.updatePreview(this.previewBox, this.infoLabel);
        });
    }

    private void createPreview(Composite parent) {
        Label preview = new Label(parent, 0);
        preview.setText("\ubbf8\ub9ac\ubcf4\uae30:");
        preview.setBackground(this.backgroundColor);
        this.previewBox = new Composite(parent, 2048);
        this.previewBox.setLayoutData((Object)new GridData(100, 40));
        this.updatePreview(this.previewBox, null);
        this.infoLabel = new Label(parent, 0);
        this.infoLabel.setBackground(this.backgroundColor);
        this.infoLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.updatePreview(this.previewBox, this.infoLabel);
    }

    private void updatePreview(Composite preview, Label info) {
        RGB rgb = EpubColorUtil.hsvToRGB(this.currentHSV);
        preview.setBackground(new Color((Device)preview.getDisplay(), rgb));
        if (info != null) {
            info.setText(String.format("HSV: %.1f, %.2f, %.2f  |  RGB: %d, %d, %d", Float.valueOf(this.currentHSV[0]), Float.valueOf(this.currentHSV[1]), Float.valueOf(this.currentHSV[2]), rgb.red, rgb.green, rgb.blue));
        }
    }

    private void createRecentColors(Composite parent) {
        Label latestColor = new Label(parent, 0);
        latestColor.setText("\ucd5c\uadfc \uc0c9\uc0c1:");
        latestColor.setBackground(this.backgroundColor);
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        container.setLayout((Layout)new RowLayout(256));
        for (float[] hsv : ColorPreference.getRecentColors()) {
            RGB rgb = EpubColorUtil.hsvToRGB(hsv);
            Button btn = new Button(container, 8);
            btn.setLayoutData((Object)new RowData(24, 24));
            Color color = new Color((Device)parent.getDisplay(), rgb);
            btn.setBackground(color);
            btn.setText("");
            btn.addListener(13, e -> {
                System.arraycopy(hsv, 0, this.currentHSV, 0, 3);
                this.hueScale.setSelection((int)this.currentHSV[0]);
                this.pickerCanvas.redraw();
                this.updatePreview(this.previewBox, this.infoLabel);
            });
        }
    }

    private void createButtons(Composite parent) {
        Composite btns = new Composite(parent, 0);
        btns.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false, 2, 1));
        btns.setLayout((Layout)new RowLayout());
        btns.setBackground(this.backgroundColor);
        Button ok = new Button(btns, 8);
        ok.setText("\ud655\uc778");
        ok.addListener(13, e -> {
            ColorPreference.saveColor(this.currentHSV);
            this.callback.onColorSelected(this.currentHSV);
            parent.getShell().dispose();
        });
        Button cancel = new Button(btns, 8);
        cancel.setText("\ucde8\uc18c");
        cancel.addListener(13, e -> parent.getShell().dispose());
    }

    private RGB convertHSVtoRGB(float[] hsv) {
        return EpubColorUtil.hsvToRgb(hsv[0], hsv[1], hsv[2]);
    }

    private String rgbToHex(RGB rgb) {
        return String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
    }

    public static interface ColorSelectedCallback {
        public void onColorSelected(float[] var1);
    }
}

