/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ImageSelectDialog
extends TitleAreaDialog {
    private Text imagePathText;
    private Button browseBtn;
    private Spinner widthSpinner;
    private Text descText;
    private Button figcaptionCheck;
    private Button coverCheck;
    private Button radiusCheck;
    private String imagePath = "";
    private int widthPercent = 100;
    private String description = "";
    private boolean useFigcaption = false;
    private boolean coverImage = false;
    private boolean radiusImage = false;

    public ImageSelectDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\uc774\ubbf8\uc9c0 \uc0bd\uc785");
        newShell.setMinimumSize(640, 420);
    }

    protected boolean isResizable() {
        return false;
    }

    public void create() {
        super.create();
        this.setTitle("\uc774\ubbf8\uc9c0 \uc0bd\uc785");
        this.setMessage("\uc774\ubbf8\uc9c0 \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uace0 \ud3ed/\uc124\uba85/\uc635\uc158\uc744 \uc9c0\uc815\ud558\uc138\uc694.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 10;
        gl.marginHeight = 10;
        gl.verticalSpacing = 8;
        gl.horizontalSpacing = 8;
        container.setLayout((Layout)gl);
        Label l1 = new Label(container, 0);
        l1.setText("\uc774\ubbf8\uc9c0 \ud30c\uc77c");
        l1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.imagePathText = new Text(container, 2048);
        this.imagePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.browseBtn = new Button(container, 8);
        this.browseBtn.setText("\ucc3e\uae30...");
        this.browseBtn.addListener(13, e -> {
            FileDialog fd = new FileDialog(this.getShell(), 4096);
            fd.setFilterExtensions(new String[]{"*.png;*.jpg;*.jpeg;*.gif;*.webp;*.svg", "*.*"});
            String sel = fd.open();
            if (sel != null) {
                this.imagePathText.setText(sel);
            }
        });
        Label l2 = new Label(container, 0);
        l2.setText("\ud3ed(%)");
        l2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.widthSpinner = new Spinner(container, 2048);
        this.widthSpinner.setMinimum(1);
        this.widthSpinner.setMaximum(100);
        this.widthSpinner.setSelection(100);
        this.widthSpinner.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        new Label(container, 0);
        Label l3 = new Label(container, 0);
        l3.setText("\uc124\uba85(alt)");
        l3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.descText = new Text(container, 2048);
        GridData gdDesc = new GridData(4, 0x1000000, true, false);
        gdDesc.horizontalSpan = 2;
        this.descText.setLayoutData((Object)gdDesc);
        Label l4 = new Label(container, 0);
        l4.setText("figcaption \ucd94\uac00");
        this.figcaptionCheck = new Button(container, 32);
        this.figcaptionCheck.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        new Label(container, 0);
        Label l5 = new Label(container, 0);
        l5.setText("\ud45c\uc9c0(cover) \uc774\ubbf8\uc9c0");
        this.coverCheck = new Button(container, 32);
        this.coverCheck.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        new Label(container, 0);
        Label l6 = new Label(container, 0);
        l6.setText("Radius \uc801\uc6a9");
        this.radiusCheck = new Button(container, 32);
        this.radiusCheck.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        new Label(container, 0);
        Dialog.applyDialogFont((Control)container);
        return area;
    }

    protected void okPressed() {
        this.imagePath = this.safe(this.imagePathText.getText());
        this.widthPercent = this.widthSpinner.getSelection();
        this.description = this.safe(this.descText.getText());
        this.useFigcaption = this.figcaptionCheck.getSelection();
        this.coverImage = this.coverCheck.getSelection();
        this.radiusImage = this.radiusCheck.getSelection();
        if (this.imagePath.isEmpty()) {
            this.setErrorMessage("\uc774\ubbf8\uc9c0 \ud30c\uc77c\uc744 \uc120\ud0dd\ud574 \uc8fc\uc138\uc694.");
            return;
        }
        super.okPressed();
    }

    private String safe(String s) {
        return s == null ? "" : s.trim();
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public int getWidthPercent() {
        return this.widthPercent;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isUseFigcaption() {
        return this.useFigcaption;
    }

    public boolean isCoverImage() {
        return this.coverImage;
    }

    public boolean isRadiusImage() {
        return this.radiusImage;
    }
}

