/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Inject;
import java.io.File;
import kr.co.goms.epub.managers.PdfManager;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ConvertPdfHandler {
    @Inject
    EPartService partService;
    @Inject
    UISynchronize ui;

    @Execute
    public void execute(Shell parentShell, IEclipseContext parentContext) {
        System.out.println("EPub ConvertPdfHandler");
        FileDialog dialog = new FileDialog(parentShell, 4096);
        dialog.setFilterExtensions(new String[]{"*.pdf"});
        dialog.setText("PDF \ud30c\uc77c \uc120\ud0dd");
        String selectedPath = dialog.open();
        if (selectedPath == null) {
            return;
        }
        String textPath = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
        String imagePath = EpubBuildUtil.getProjectOEBPSSubFolder("Images");
        File pdfFile = new File(selectedPath);
        File targetTextDir = new File(textPath);
        File targetImagesDir = new File(imagePath);
        try {
            this.convertWithProgressDialog(pdfFile, targetTextDir, targetImagesDir, this.partService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void convertWithProgressDialog(File pdfFile, File targetTextDir, File targetImagesDir, EPartService partService) {
        Shell shell = Display.getDefault().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, monitor -> {
                monitor.beginTask("PDF \ubcc0\ud658 \uc911...", -1);
                try {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        PdfManager.getInstance().convert(pdfFile, targetTextDir, targetImagesDir);
                        this.ui.asyncExec(() -> {});
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

