/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kr.co.goms.epub.solution.utils.ContentOpfUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateLoiHandler {
    @Execute
    public void execute(Shell shell, IEclipseContext parentContext) {
        System.out.println("EPub CreateIoiHandler");
        String oebpsTextFolder = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
        File folder = new File(oebpsTextFolder);
        System.out.println("folder : " + folder.getPath());
        File[] xhtmlFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".xhtml"));
        if (xhtmlFiles == null || xhtmlFiles.length == 0) {
            MessageDialog.openInformation((Shell)shell, (String)"\uc548\ub0b4", (String)"XHTML \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        Arrays.sort(xhtmlFiles, Comparator.comparingInt(f -> {
            String name = f.getName();
            if (name.equals("cover.xhtml")) {
                return 1;
            }
            if (name.equals("nav.xhtml")) {
                return 2;
            }
            if (name.equals("loi.xhtml")) {
                return 3;
            }
            if (name.equals("author.xhtml")) {
                return 4;
            }
            if (name.startsWith("chapter")) {
                String numberPart = name.replaceAll("[^0-9]", "");
                try {
                    return 100 + Integer.parseInt(numberPart);
                }
                catch (NumberFormatException numberFormatException) {
                    return Integer.MAX_VALUE;
                }
            }
            return Integer.MAX_VALUE;
        }));
        Set usedImages = Collections.synchronizedSet(new HashSet());
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        try {
            progressDialog.run(true, true, monitor -> {
                monitor.beginTask("\uc774\ubbf8\uc9c0 \ubaa9\ucc28 \uc0dd\uc131 \uc911...", xhtmlFiles.length);
                StringBuilder listItems = new StringBuilder();
                File[] fileArray2 = xhtmlFiles;
                int n = xhtmlFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray2[n2];
                    if (monitor.isCanceled()) break;
                    monitor.subTask(file2.getName());
                    try {
                        StringBuilder item = this.createLoiXhtml(file2, usedImages);
                        listItems.append((CharSequence)item);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"\ucc98\ub9ac \uc2e4\ud328", (String)(file2.getName() + " \ucc98\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd:\n" + e.getMessage())));
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
                this.saveIoiXhtml(shell, listItems, folder);
                File opfFile = new File(folder.getParentFile(), "content.opf");
                try {
                    this.updateContentOpfWithImages(opfFile.toPath(), usedImages);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"OPF \uc5c5\ub370\uc774\ud2b8 \uc2e4\ud328", (String)("content.opf \uac31\uc2e0 \uc911 \uc624\ub958:\n" + e.getMessage())));
                }
            });
            MessageDialog.openInformation((Shell)shell, (String)"\uc644\ub8cc", (String)"\uc774\ubbf8\uc9c0 \ubaa9\ucc28 \uc0dd\uc131 \uc644\ub8cc!");
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)("\ucc98\ub9ac \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4:\n" + e.getMessage()));
        }
    }

    private StringBuilder createLoiXhtml(File file, Set<String> usedImages) throws IOException {
        StringBuilder listItems = new StringBuilder();
        Document doc = Jsoup.parse((File)file, (String)"UTF-8");
        Elements images = doc.select("img[id][alt]");
        for (org.jsoup.nodes.Element img : images) {
            String id = img.attr("id");
            String alt = img.attr("alt");
            if ("cover".equalsIgnoreCase(id)) {
                alt = "\ud45c\uc9c0";
            }
            if (id.isEmpty() || alt.isEmpty()) continue;
            listItems.append("                <li>\n").append("                    <a href=\"../Text/").append(file.getName()).append("#").append(id).append("\">").append(alt).append("</a>\n").append("                </li>\n");
        }
        for (org.jsoup.nodes.Element img : doc.select("img[src]")) {
            String ext;
            String src = img.attr("src");
            String name = CreateLoiHandler.extractFileName(src);
            if (name == null || name.isEmpty() || !(ext = CreateLoiHandler.getExtension(name).toLowerCase(Locale.ROOT)).equals("jpg") && !ext.equals("jpeg") && !ext.equals("png")) continue;
            usedImages.add(name);
        }
        return listItems;
    }

    private void saveIoiXhtml(Shell shell, StringBuilder listItems, File targetFolder) {
        String loiTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:epub=\"http://www.idpf.org/2007/ops\" xml:lang=\"ko\" lang=\"ko\">\n<head>\n    <title>\uc774\ubbf8\uc9c0 \ubaa9\ucc28</title>\n    <meta charset=\"utf-8\" />\n    <link href=\"../Styles/nav.css\" type=\"text/css\" rel=\"stylesheet\"/>\n</head>\n<body id=\"body\" style=\"background-color: #E9E3DB; position: relative;\">\n    <nav epub:type=\"loi\" id=\"loi\">\n        <h1 id=\"loi0001\" class=\"loi_toc\">\uc774\ubbf8\uc9c0 \ubaa9\ucc28</h1>\n        <ol>\n\t\t\t%s\n        </ol>\n    </nav>\n</body>\n</html>\n";
        String finalContent = String.format(loiTemplate, listItems.toString());
        try {
            File loiFile = new File(targetFolder, "loi.xhtml");
            Files.writeString(loiFile.toPath(), (CharSequence)finalContent, StandardCharsets.UTF_8, new OpenOption[0]);
            ContentOpfUtil.applyOpf(shell, loiFile.getName(), "\uc774\ubbf8\uc9c0\ubaa9\ucc28 \uc0dd\uc131\uc644\ub8cc", false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateContentOpfWithImages(Path opfPath, Set<String> usedImageFiles) throws Exception {
        org.w3c.dom.Document opfDoc;
        if (usedImageFiles == null || usedImageFiles.isEmpty()) {
            return;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Throwable throwable = null;
        Object var7_7 = null;
        try (FileInputStream in = new FileInputStream(opfPath.toFile());){
            opfDoc = db.parse(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Element root = opfDoc.getDocumentElement();
        Element manifestEl = CreateLoiHandler.findFirstByLocalName(root, "manifest");
        if (manifestEl == null) {
            throw new IllegalStateException("<manifest> not found in OPF");
        }
        HashSet<Object> existingHrefs = new HashSet<Object>();
        HashSet<Object> existingIds = new HashSet<Object>();
        NodeList items = manifestEl.getElementsByTagNameNS("*", "item");
        int i = 0;
        while (i < items.getLength()) {
            Element it = (Element)items.item(i);
            String href = it.getAttribute("href");
            String id = it.getAttribute("id");
            if (!href.isEmpty()) {
                existingHrefs.add(href);
            }
            if (!id.isEmpty()) {
                existingIds.add(id);
            }
            ++i;
        }
        ArrayList<Element> toAppend = new ArrayList<Element>();
        for (String fileName : usedImageFiles) {
            String extLower = CreateLoiHandler.getExtension(fileName).toLowerCase(Locale.ROOT);
            if (!extLower.equals("jpg") && !extLower.equals("jpeg") && !extLower.equals("png")) continue;
            String normalizedExt = extLower.equals("jpg") ? "jpeg" : extLower;
            String href = "Images/" + fileName;
            String id = CreateLoiHandler.stripExtension(fileName) + "_" + normalizedExt;
            if (existingHrefs.contains(href) || existingIds.contains(id)) continue;
            String prefix = manifestEl.getPrefix();
            String ns = manifestEl.getNamespaceURI();
            Element newItem = ns == null ? opfDoc.createElement("item") : (prefix == null ? opfDoc.createElementNS(ns, "item") : opfDoc.createElementNS(ns, prefix + ":item"));
            newItem.setAttribute("href", href);
            newItem.setAttribute("id", id);
            newItem.setAttribute("media-type", "image/" + normalizedExt);
            toAppend.add(newItem);
            existingHrefs.add(href);
            existingIds.add(id);
        }
        if (!toAppend.isEmpty()) {
            for (Element el : toAppend) {
                manifestEl.appendChild(el);
            }
            CreateLoiHandler.writeXml(opfDoc, opfPath.toFile());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String extractFileName(String src) {
        String path;
        block3: {
            try {
                String clean = src.split("\\?")[0].split("#")[0];
                if (!clean.matches("^[a-zA-Z][a-zA-Z0-9+.-]*:.*")) int idx;
                return (idx = (clean = clean.replace('\\', '/')).lastIndexOf(47)) >= 0 ? clean.substring(idx + 1) : clean;
                URI uri = URI.create(clean);
                path = uri.getPath();
                if (path != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        String decoded = URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        int idx = decoded.lastIndexOf(47);
        return idx >= 0 ? decoded.substring(idx + 1) : decoded;
    }

    private static String getExtension(String name) {
        int dot = name.lastIndexOf(46);
        return dot >= 0 && dot < name.length() - 1 ? name.substring(dot + 1) : "";
    }

    private static String stripExtension(String name) {
        int dot = name.lastIndexOf(46);
        return dot >= 0 ? name.substring(0, dot) : name;
    }

    private static Element findFirstByLocalName(Element root, String local) {
        if (root == null) {
            return null;
        }
        if (local.equals(root.getLocalName()) || local.equals(root.getNodeName())) {
            return root;
        }
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element found;
            Node n = children.item(i);
            if (n instanceof Element && (found = CreateLoiHandler.findFirstByLocalName((Element)n, local)) != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    private static void removeWhitespaceTextNodes(Node node) {
        if (node == null) {
            return;
        }
        NodeList children = node.getChildNodes();
        ArrayList<Node> whitespaceNodes = new ArrayList<Node>();
        int i = 0;
        while (i < children.getLength()) {
            Node c = children.item(i);
            if (c.getNodeType() == 3) {
                String txt = c.getNodeValue();
                if (txt != null && txt.trim().isEmpty()) {
                    whitespaceNodes.add(c);
                }
            } else {
                CreateLoiHandler.removeWhitespaceTextNodes(c);
            }
            ++i;
        }
        for (Node w : whitespaceNodes) {
            node.removeChild(w);
        }
    }

    private static void writeXml(org.w3c.dom.Document doc, File out) throws TransformerException, IOException {
        CreateLoiHandler.removeWhitespaceTextNodes(doc.getDocumentElement());
        doc.normalizeDocument();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer tr = tf.newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tr.setOutputProperty("encoding", "UTF-8");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("omit-xml-declaration", "no");
        System.setProperty("line.separator", "\n");
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream os = new FileOutputStream(out);){
            tr.transform(new DOMSource(doc), new StreamResult(os));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

