/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Comparator;
import kr.co.goms.epub.solution.utils.ContentOpfUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class CreateLotHandler {
    @Execute
    public void execute(Shell shell, IEclipseContext parentContext) {
        System.out.println("EPub CreateIotHandler");
        String oebpsTextFolder = EpubBuildUtil.getProjectOEBPSSubFolder("Text");
        File folder = new File(oebpsTextFolder);
        File[] xhtmlFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".xhtml"));
        if (xhtmlFiles == null || xhtmlFiles.length == 0) {
            MessageDialog.openInformation((Shell)shell, (String)"\uc548\ub0b4", (String)"XHTML \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        Arrays.sort(xhtmlFiles, Comparator.comparingInt(f -> {
            String name = f.getName();
            if (name.equals("cover.xhtml")) {
                return 1;
            }
            if (name.equals("nav.xhtml")) {
                return 2;
            }
            if (name.equals("loi.xhtml")) {
                return 3;
            }
            if (name.equals("author.xhtml")) {
                return 4;
            }
            if (name.startsWith("chapter")) {
                String numberPart = name.replaceAll("[^0-9]", "");
                try {
                    return 100 + Integer.parseInt(numberPart);
                }
                catch (NumberFormatException numberFormatException) {
                    return Integer.MAX_VALUE;
                }
            }
            return Integer.MAX_VALUE;
        }));
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        try {
            progressDialog.run(true, true, monitor -> {
                monitor.beginTask("\ud45c \ubaa9\ucc28 \uc0dd\uc131 \uc911...", xhtmlFiles.length);
                StringBuilder listItems = new StringBuilder();
                File[] fileArray2 = xhtmlFiles;
                int n = xhtmlFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray2[n2];
                    if (monitor.isCanceled()) break;
                    monitor.subTask(file2.getName());
                    try {
                        StringBuilder item = this.createLotXhtml(file2);
                        listItems.append((CharSequence)item);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"\ucc98\ub9ac \uc2e4\ud328", (String)(file2.getName() + " \ucc98\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd:\n" + e.getMessage())));
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
                this.saveIotXhtml(shell, listItems, folder);
            });
            MessageDialog.openInformation((Shell)shell, (String)"\uc644\ub8cc", (String)"\ud45c \ubaa9\ucc28 \uc0dd\uc131 \uc644\ub8cc!");
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)("\ucc98\ub9ac \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4:\n" + e.getMessage()));
        }
    }

    private StringBuilder createLotXhtml(File file) throws IOException {
        StringBuilder listItems = new StringBuilder();
        Document doc = Jsoup.parse((File)file, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        Elements tables = doc.select("table[id]");
        for (Element table : tables) {
            String caption;
            String id = table.attr("id");
            Element captionEl = table.selectFirst("caption");
            String string = caption = captionEl != null ? captionEl.text().trim() : "";
            if (id.isEmpty() || caption.isEmpty()) continue;
            listItems.append("                <li>\n").append("                    <a href=\"../Text/").append(file.getName()).append("#").append(id).append("\">").append(CreateLotHandler.escapeXml(caption)).append("</a>\n").append("                </li>\n");
        }
        return listItems;
    }

    private void saveIotXhtml(Shell shell, StringBuilder listItems, File targetFolder) {
        String loiTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:epub=\"http://www.idpf.org/2007/ops\" xml:lang=\"ko\" lang=\"ko\">\n<head>\n    <title>\ud45c \ubaa9\ucc28</title>\n    <meta charset=\"utf-8\" />\n    <link href=\"../Styles/nav.css\" type=\"text/css\" rel=\"stylesheet\"/>\n</head>\n<body id=\"body\" style=\"background-color: #E9E3DB; position: relative;\">\n    <nav epub:type=\"lot\" id=\"lot\">\n        <h1 id=\"loi0001\" class=\"loi_toc\">\ud45c \ubaa9\ucc28</h1>\n        <ol>\n\t\t\t%s\n        </ol>\n    </nav>\n</body>\n</html>\n";
        String finalContent = String.format(loiTemplate, listItems.toString());
        try {
            File loiFile = new File(targetFolder, "lot.xhtml");
            Files.writeString(loiFile.toPath(), (CharSequence)finalContent, StandardCharsets.UTF_8, new OpenOption[0]);
            ContentOpfUtil.applyOpf(shell, loiFile.getName(), "\uc774\ubbf8\uc9c0\ubaa9\ucc28 \uc0dd\uc131\uc644\ub8cc", false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String escapeXml(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

