/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.solution.dialogs.ImageSelectDialog;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class InsertImageAtCaretHandler {
    @Inject
    @Optional
    private SourceViewer sourceViewer;
    @Inject
    @Optional
    private IEventBroker eventBroker;

    @CanExecute
    public boolean canExecute(EPartService ps, @Optional SourceViewer injectedSV) {
        MPart active = ps.getActivePart();
        if (active == null) {
            return false;
        }
        SourceViewer sv = injectedSV;
        if (sv == null && active.getContext() != null) {
            sv = (SourceViewer)active.getContext().get(SourceViewer.class);
        }
        if (sv == null) {
            return false;
        }
        Object f = active.getTransientData().get("currentFile");
        return f instanceof IFile;
    }

    @Execute
    public void execute(Shell shell, EPartService partService, @Optional SourceViewer injectedSV) {
        IEclipseContext partCtx;
        MPart activePart = partService.getActivePart();
        if (activePart == null) {
            InsertImageAtCaretHandler.msg(shell, "\ud65c\uc131 \ud3b8\uc9d1\uae30\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        SourceViewer sourceViewer = injectedSV;
        if (sourceViewer == null && (partCtx = activePart.getContext()) != null) {
            sourceViewer = (SourceViewer)partCtx.get(SourceViewer.class);
        }
        if (sourceViewer == null) {
            InsertImageAtCaretHandler.msg(shell, "SourceViewer\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc5d0\ub514\ud130\uc5d0\uc11c context.set(SourceViewer.class, viewer) \ud588\ub294\uc9c0 \ud655\uc778\ud558\uc138\uc694.");
            return;
        }
        Object tf = activePart.getTransientData().get("currentFile");
        if (!(tf instanceof IFile)) {
            InsertImageAtCaretHandler.msg(shell, "\ud604\uc7ac \ud30c\uc77c(IFile)\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. part.getTransientData().put(\"currentFile\", iFile) \uc124\uc815\uc744 \ud655\uc778\ud558\uc138\uc694.");
            return;
        }
        IFile currentFile = (IFile)tf;
        ImageSelectDialog dlg = new ImageSelectDialog(shell);
        if (dlg.open() != 0) {
            return;
        }
        try {
            IProject project = currentFile.getProject();
            IFolder imagesFolder = project.getFolder("OEBPS/Images");
            InsertImageAtCaretHandler.ensureFolder(imagesFolder);
            File src = new File(dlg.getImagePath());
            if (!src.exists()) {
                InsertImageAtCaretHandler.msg(shell, "\uc120\ud0dd\ud55c \uc774\ubbf8\uc9c0 \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                return;
            }
            String ext = InsertImageAtCaretHandler.getExtension(src.getName());
            String baseName = InsertImageAtCaretHandler.getBaseName(src.getName());
            String targetName = dlg.isCoverImage() ? InsertImageAtCaretHandler.uniqueName(imagesFolder, "cover", ext) : InsertImageAtCaretHandler.uniqueName(imagesFolder, baseName, ext);
            IFile dstFile = imagesFolder.getFile(targetName);
            Throwable throwable = null;
            Object var17_19 = null;
            try (FileInputStream in = new FileInputStream(src);){
                if (dstFile.exists()) {
                    dstFile.setContents((InputStream)in, true, true, null);
                } else {
                    dstFile.create((InputStream)in, true, null);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String srcAttr = "../Images/" + targetName;
            String fileName = currentFile.getName();
            String chapterBase = InsertImageAtCaretHandler.deriveChapterBase(fileName);
            String docText = sourceViewer.getDocument().get();
            int imgIndex = InsertImageAtCaretHandler.nextImageIndex(docText, chapterBase);
            String imgId = chapterBase + "_img_" + imgIndex;
            String html = InsertImageAtCaretHandler.buildFigureHtml(srcAttr, dlg.getWidthPercent(), dlg.getDescription(), dlg.isUseFigcaption(), dlg.isCoverImage(), dlg.isRadiusImage(), imgId);
            IDocument doc = sourceViewer.getDocument();
            int offset = sourceViewer.widgetOffset2ModelOffset(sourceViewer.getTextWidget().getCaretOffset());
            doc.replace(offset, 0, "\n" + html + "\n");
            String href = imagesFolder.getProjectRelativePath().append(dstFile.getName()).toString().substring("OEBPS/".length());
            String id = dstFile.getName().replaceAll("[^a-zA-Z0-9\uac00-\ud7a3]", "_");
            String mediaType = OpfNcxUpdater.getMediaType(dstFile.getName());
            boolean isXhtml = dstFile.getName().toLowerCase().endsWith(".xhtml");
            boolean addToScripted = false;
            boolean addToLinearNo = false;
            OpfNcxUpdater.addFileToOpf(project.getFile("OEBPS/content.opf"), id, href, mediaType, isXhtml, addToScripted, addToLinearNo);
            EpubPartManager.getInstance().refreshProjectExplorer(partService, dstFile.getName());
        }
        catch (Exception e) {
            InsertImageAtCaretHandler.msg(shell, "\uc774\ubbf8\uc9c0 \uc0bd\uc785 \uc911 \uc624\ub958: " + e.getMessage());
        }
    }

    private static void msg(Shell shell, String m) {
        MessageBox mb = new MessageBox(shell, 34);
        mb.setText("Insert Figure");
        mb.setMessage(m);
        mb.open();
    }

    private static void ensureFolder(IFolder folder) throws CoreException {
        if (folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            InsertImageAtCaretHandler.ensureFolder((IFolder)parent);
        }
        if (parent instanceof IProject && !((IProject)parent).isOpen()) {
            ((IProject)parent).open(null);
        }
        folder.create(true, true, null);
    }

    private static String buildFigureHtml(String src, int widthPercent, String desc, boolean useFigcaption, boolean isCover, boolean isRadius, String nonCoverImgId) {
        String safeAlt = InsertImageAtCaretHandler.esc(desc);
        StringBuilder sb = new StringBuilder();
        sb.append("<figure>\n");
        sb.append("  <img ");
        if (isCover) {
            sb.append("id=\"cover\" role=\"doc-cover\" aria-label=\"\ud45c\uc9c0\" ");
        } else {
            sb.append("id=\"").append(InsertImageAtCaretHandler.escapeAttr(nonCoverImgId)).append("\" role=\"img\" ");
        }
        if (isRadius) {
            sb.append("class=\"radius-img\" ");
        }
        sb.append("src=\"").append(InsertImageAtCaretHandler.escAttr(src)).append("\" ");
        sb.append("alt=\"").append(safeAlt).append("\" ");
        sb.append("style=\"width:").append(widthPercent).append("%;\"/>\n");
        if (useFigcaption) {
            sb.append("  <figcaption>").append(InsertImageAtCaretHandler.esc(desc)).append("</figcaption>\n");
        }
        sb.append("</figure>");
        return sb.toString();
    }

    private static String getExtension(String name) {
        int dot = name.lastIndexOf(46);
        return dot >= 0 && dot < name.length() - 1 ? name.substring(dot + 1).toLowerCase() : "";
    }

    private static String getBaseName(String name) {
        int dot = name.lastIndexOf(46);
        return dot >= 0 ? name.substring(0, dot) : name;
    }

    private static String escapeAttr(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String deriveChapterBase(String fileName) {
        int dot = fileName.indexOf(46);
        String base = dot > 0 ? fileName.substring(0, dot) : fileName;
        return base.toLowerCase().startsWith("chapter") ? base : "chapter";
    }

    private static int nextImageIndex(String docText, String chapterBase) {
        Pattern p = Pattern.compile(Pattern.quote(chapterBase) + "_img_(\\d+)");
        Matcher m = p.matcher(docText);
        int max = 0;
        while (m.find()) {
            try {
                int n = Integer.parseInt(m.group(1));
                if (n <= max) continue;
                max = n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max + 1;
    }

    private static String esc(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String escAttr(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    private static String uniqueName(IFolder folder, String base, String ext) throws CoreException {
        String cleanBase = base.replaceAll("[^a-zA-Z0-9._-]", "_");
        String candidate = cleanBase + (String)(ext.isEmpty() ? "" : "." + ext);
        int i = 2;
        while (folder.getFile(candidate).exists()) {
            candidate = cleanBase + "_" + i + (String)(ext.isEmpty() ? "" : "." + ext);
            ++i;
        }
        return candidate;
    }
}

