/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import kr.co.goms.epub.solution.parts.ProjectExplorerPart;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class NewProjectOpenHandler {
    @Inject
    EPartService partService;

    @Execute
    public void execute(Shell shell) {
        DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
        dialog.setText("\ud504\ub85c\uc81d\ud2b8 \ud3f4\ub354 \uc120\ud0dd");
        dialog.setMessage("\uae30\uc874 \ud3f4\ub354\ub97c \uc120\ud0dd\ud558\uac70\ub098 \uc0c8 \ud3f4\ub354 \uc774\ub984\uc744 \uc785\ub825\ud558\uc138\uc694.");
        String selectedPath = dialog.open();
        if (selectedPath != null) {
            boolean created;
            File projectDir = new File(selectedPath);
            if (!projectDir.exists() && !(created = projectDir.mkdirs())) {
                this.showError(shell, "\ud3f4\ub354\ub97c \uc0dd\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + selectedPath);
                return;
            }
            this.openProject(projectDir);
        }
    }

    private void showError(Shell shell, String message) {
        MessageBox box = new MessageBox(shell, 33);
        box.setMessage(message);
        box.setText("\uc624\ub958");
        box.open();
    }

    private void openProject(File projectDir) {
        Object object;
        System.out.println("\uc120\ud0dd\ud55c \ud504\ub85c\uc81d\ud2b8 \ud3f4\ub354: " + projectDir.getAbsolutePath());
        System.out.println("\uc120\ud0dd\ud55c \ud504\ub85c\uc81d\ud2b8 \ud3f4\ub354: " + projectDir.getName());
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        try {
            prefs.put("ebook_project_name", projectDir.getName());
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        String projectName = prefs.get("ebook_project_name", "GomsBook");
        System.out.println("\uc801\uc6a9\ub41c \ud604\uc7ac \ud504\ub85c\uc81d\ud2b8 \ud3f4\ub354: " + projectName);
        this.createProjectFile(projectDir);
        MPart part = this.partService.findPart("kr.co.goms.epub.solution.parts.projectexplorer");
        if (part != null && (object = part.getObject()) instanceof ProjectExplorerPart) {
            ProjectExplorerPart explorerPart = (ProjectExplorerPart)object;
            explorerPart.resetProjectName();
        }
    }

    private void createProjectFile(File projectDir) {
        File textDir;
        File styleDir;
        File smilDir;
        File imagesDir;
        File fontDir;
        File audioDir;
        File contentOpf;
        File oebpsDir;
        Object writer;
        File containerXml;
        File metaInfDir;
        Object writer2;
        String projectFile = ".project";
        File dotProjectFile = new File(projectDir, projectFile);
        String projectName = projectDir.getName();
        if (!dotProjectFile.exists()) {
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n  <name>" + projectName + "</name>\n  <comment></comment>\n  <projects></projects>\n  <buildSpec>\n    <buildCommand>\n      <name>org.eclipse.jdt.core.javabuilder</name>\n      <arguments>\n      </arguments>\n    </buildCommand>\n    <buildCommand>\n      <name>org.eclipse.pde.ManifestBuilder</name>\n      <arguments>\n      </arguments>\n    </buildCommand>\n    <buildCommand>\n      <name>org.eclipse.pde.SchemaBuilder</name>\n      <arguments>\n      </arguments>\n    </buildCommand>\n  </buildSpec>\n  <natures>\n    <nature>org.eclipse.pde.PluginNature</nature>\n    <nature>org.eclipse.jdt.core.javanature</nature>\n  </natures>\n</projectDescription>";
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    writer2 = new FileWriter(dotProjectFile);
                    try {
                        ((Writer)writer2).write(xml);
                    }
                    finally {
                        if (writer2 != null) {
                            ((OutputStreamWriter)writer2).close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(metaInfDir = new File(projectDir, "META-INF")).exists()) {
            metaInfDir.mkdirs();
        }
        if (!(containerXml = new File(metaInfDir, "container.xml")).exists()) {
            String containerContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<container version=\"1.0\" xmlns=\"urn:oasis:names:tc:opendocument:xmlns:container\">\n  <rootfiles>\n    <rootfile full-path=\"OEBPS/content.opf\" media-type=\"application/oebps-package+xml\"/>\n  </rootfiles>\n</container>\n";
            try {
                writer2 = null;
                Object var9_14 = null;
                try {
                    writer = new FileWriter(containerXml);
                    try {
                        ((Writer)writer).write(containerContent);
                    }
                    finally {
                        if (writer != null) {
                            ((OutputStreamWriter)writer).close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (writer2 == null) {
                        writer2 = throwable;
                    } else if (writer2 != throwable) {
                        ((Throwable)writer2).addSuppressed(throwable);
                    }
                    throw writer2;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(oebpsDir = new File(projectDir, "OEBPS")).exists()) {
            oebpsDir.mkdirs();
        }
        if (!(contentOpf = new File(oebpsDir, "content.opf")).exists()) {
            String opfContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<package xmlns=\"http://www.idpf.org/2007/opf\" version=\"3.0\" unique-identifier=\"BookId\" version=\"3.0\" xml:lang=\"ko\">\n  <metadata xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:opf=\"http://www.idpf.org/2007/opf\">\n    <dc:title>EPUB Title</dc:title>\n    <dc:creator>\uacf0\uc2a4</dc:creator>\n    <dc:publisher>\uacf0\uc2a4\ubd81</dc:publisher>\n    <dc:date>2025-11-28</dc:date>\n    <dc:identifier id=\"BookId\">urn:isbn:1234567891011</dc:identifier>\n    <dc:source>urn:isbn:1234567891011</dc:source>\n    <dc:language>ko</dc:language>\n    <meta property=\"dcterms:modified\">2025-08-15T12:50:44Z</meta>\n    <meta property=\"schema:accessMode\">textual</meta>\n    <meta property=\"schema:accessMode\">visual</meta>\n    <meta property=\"schema:accessModeSufficient\">textual,visual</meta>\n    <meta property=\"schema:accessibilityFeature\">alternativeText</meta>\n    <meta property=\"schema:accessibilityFeature\">tableOfContents</meta>\n    <meta property=\"schema:accessibilityFeature\">structuralNavigation</meta>\n    <meta property=\"schema:accessibilityHazard\">noMotionSimulationHazard</meta>\n    <meta property=\"schema:accessibilityHazard\">noSoundHazard</meta>\n    <meta property=\"schema:accessibilitySummary\">\uc774 \uc804\uc790\ucc45\uc740 \uad6c\uc870\uc801 \ud0d0\uc0c9 \ubc0f \ud14d\uc2a4\ud2b8 \uae30\ubc18 \uc811\uadfc\uc774 \uac00\ub2a5\ud569\ub2c8\ub2e4.</meta>\n    <meta content=\"1.0.0\" name=\"GomsBookEditor Version\"/>\n    <meta content=\"cover_jpg\" name=\"cover\"/>\n  </metadata>\n  <manifest>\n  </manifest>\n  <spine>\n  </spine>\n  <guide>\n    <reference href=\"Text/cover.xhtml\" title=\"Cover\" type=\"cover\"/>\n  </guide>\n</package>\n";
            try {
                writer = null;
                Object var11_19 = null;
                try (FileWriter writer3 = new FileWriter(contentOpf);){
                    writer3.write(opfContent);
                }
                catch (Throwable throwable) {
                    if (writer == null) {
                        writer = throwable;
                    } else if (writer != throwable) {
                        ((Throwable)writer).addSuppressed(throwable);
                    }
                    throw writer;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(audioDir = new File(oebpsDir, "Audio")).exists()) {
            audioDir.mkdirs();
        }
        if (!(fontDir = new File(oebpsDir, "Fonts")).exists()) {
            fontDir.mkdirs();
        }
        if (!(imagesDir = new File(oebpsDir, "Images")).exists()) {
            imagesDir.mkdirs();
        }
        if (!(smilDir = new File(oebpsDir, "Smil")).exists()) {
            smilDir.mkdirs();
        }
        if (!(styleDir = new File(oebpsDir, "Styles")).exists()) {
            styleDir.mkdirs();
        }
        if (!(textDir = new File(oebpsDir, "Text")).exists()) {
            textDir.mkdirs();
        }
        this.registProject(projectDir, projectName);
    }

    private void registProject(File projectDir, String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            try {
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(projectDir.getAbsolutePath() + "/.project"));
                project.create(description, null);
                project.open(null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

