/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import kr.co.goms.epub.solution.preferences.QuizPreference;
import kr.co.goms.epub.solution.quiz.QuizConfig;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class NewXhtmlFileHandler {
    @Inject
    IEventBroker eventBroker;

    @Execute
    public void run(Shell shell, @Optional @Named(value="org.eclipse.ui.selection") Object selection) throws Exception {
        InputDialog cd;
        IProject project = null;
        if (selection instanceof IResource) {
            IResource r = (IResource)selection;
            project = r.getProject();
        }
        if (project == null) {
            MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)"\ud504\ub85c\uc81d\ud2b8\ub97c \ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.");
            return;
        }
        IFolder textFolder = EpubBuildUtil.getTextFolder(project);
        if (!textFolder.exists()) {
            textFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        String[] tplLabels = new String[]{"\ud45c\uc9c0(Cover)", "\ucc55\ud130(Chapter)", "\ud034\uc988(1\ubb38\uc81c)", "\ud034\uc988(2\ubb38\uc81c \ud55c \ud398\uc774\uc9c0)", "\ube48 \ubb38\uc11c(Blank)"};
        EpubBuildUtil.TemplateType[] tplMap = new EpubBuildUtil.TemplateType[]{EpubBuildUtil.TemplateType.COVER, EpubBuildUtil.TemplateType.CHAPTER, EpubBuildUtil.TemplateType.QUIZ, EpubBuildUtil.TemplateType.BLANK};
        ListDialog tdlg = new ListDialog(shell);
        tdlg.setTitle("\ud15c\ud50c\ub9bf \uc120\ud0dd");
        tdlg.setMessage("\uc0dd\uc131\ud560 \ubb38\uc11c \ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
        tdlg.setAddCancelButton(true);
        tdlg.setInput((Object)tplLabels);
        tdlg.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        tdlg.setLabelProvider((ILabelProvider)new LabelProvider());
        if (tdlg.open() != 0 || tdlg.getResult() == null || tdlg.getResult().length == 0) {
            return;
        }
        int tplIdx = Arrays.asList(tplLabels).indexOf((String)tdlg.getResult()[0]);
        EpubBuildUtil.TemplateType chosenTpl = tplMap[tplIdx];
        String[] styleLabels = new String[]{"\ud074\ub798\uc2dd(Classic)", "\ubaa8\ub358(Modern)"};
        EpubBuildUtil.DesignStyle[] styleMap = new EpubBuildUtil.DesignStyle[]{EpubBuildUtil.DesignStyle.CLASSIC, EpubBuildUtil.DesignStyle.MODERN};
        ListDialog sdlg = new ListDialog(shell);
        sdlg.setTitle("\uc2a4\ud0c0\uc77c \uc120\ud0dd");
        sdlg.setMessage("\ubb38\uc11c \uc2a4\ud0c0\uc77c\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
        sdlg.setAddCancelButton(true);
        sdlg.setInput((Object)styleLabels);
        sdlg.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        sdlg.setLabelProvider((ILabelProvider)new LabelProvider());
        if (sdlg.open() != 0 || sdlg.getResult() == null || sdlg.getResult().length == 0) {
            return;
        }
        int styleIdx = Arrays.asList(styleLabels).indexOf((String)sdlg.getResult()[0]);
        EpubBuildUtil.DesignStyle chosenStyle = styleMap[styleIdx];
        IInputValidator validator = name -> {
            if (name == null || name.trim().isEmpty()) {
                return "\ud30c\uc77c\uba85\uc744 \uc785\ub825\ud558\uc138\uc694.";
            }
            String n = EpubBuildUtil.ensureXhtmlExt(name);
            if (!n.matches("[A-Za-z0-9_\\-\\.]+\\.xhtml")) {
                return "\uc601\ubb38/\uc22b\uc790/._-\ub9cc \ud5c8\uc6a9, .xhtml \ud655\uc7a5\uc790 \ud544\uc694";
            }
            if (textFolder.getFile(n).exists()) {
                return "\uac19\uc740 \uc774\ub984\uc758 \ud30c\uc77c\uc774 \uc774\ubbf8 \uc788\uc2b5\ub2c8\ub2e4.";
            }
            return null;
        };
        String suggest = switch (chosenTpl) {
            case EpubBuildUtil.TemplateType.COVER -> "cover.xhtml";
            case EpubBuildUtil.TemplateType.CHAPTER -> "chapter1.xhtml";
            case EpubBuildUtil.TemplateType.QUIZ -> "quiz.xhtml";
            default -> "new.xhtml";
        };
        InputDialog ndlg = new InputDialog(shell, "\uc0c8 XHTML \ud30c\uc77c", "\ud30c\uc77c\uba85\uc744 \uc785\ub825\ud558\uc138\uc694", suggest, validator);
        if (ndlg.open() != 0) {
            return;
        }
        String fileName = EpubBuildUtil.ensureXhtmlExt(ndlg.getValue());
        String titleOrNum = null;
        if (chosenTpl == EpubBuildUtil.TemplateType.CHAPTER && (cd = new InputDialog(shell, "\ucc55\ud130 \uc81c\ubaa9/\ubc88\ud638", "\ucc55\ud130 \uc81c\ubaa9(\ub610\ub294 \ubc88\ud638)\uc744 \uc785\ub825\ud558\uc138\uc694.", "Chapter 1", null)).open() == 0) {
            titleOrNum = cd.getValue();
        }
        IFile file = textFolder.getFile(fileName);
        Throwable throwable = null;
        Object var23_25 = null;
        try (InputStream is = EpubBuildUtil.template(chosenTpl, chosenStyle, titleOrNum);){
            file.create(is, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        textFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        boolean addToSpine = chosenTpl != EpubBuildUtil.TemplateType.COVER;
        boolean scripted = false;
        boolean linearNo = false;
        EpubBuildUtil.addToOpfIfXhtml(project, fileName, addToSpine, scripted, linearNo);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("file", file);
        data.put("path", file.getLocation() != null ? file.getLocation().toOSString() : null);
        this.eventBroker.post("gomsbook/preview/refresh", data);
        MessageDialog.openInformation((Shell)shell, (String)"\uc644\ub8cc", (String)("\ud30c\uc77c \uc0dd\uc131: " + String.valueOf(file.getFullPath())));
    }

    @CanExecute
    public boolean canExec(@Optional @Named(value="org.eclipse.ui.selection") Object selection) {
        return selection instanceof IResource;
    }

    private QuizConfig loadInitialQuizConfigFromPrefs() {
        String json;
        if (!QuizPreference.rememberLast() || (json = QuizPreference.lastConfigJson()) == null || !json.isBlank()) {
            // empty if block
        }
        int q = QuizPreference.numQuestions();
        int c = QuizPreference.numChoices();
        return QuizConfig.sample(q, c);
    }

    private void maybeSaveLastQuizConfigToPrefs(QuizConfig cfg) {
        if (!QuizPreference.rememberLast()) {
            return;
        }
        try {
            String jsonLite = "{\"questions\":" + cfg.questions.size() + ",\"choices\":" + (cfg.questions.isEmpty() ? 0 : cfg.questions.get((int)0).choices.size()) + "}";
            QuizPreference.saveLastConfigJson(jsonLite);
        }
        catch (Exception exception) {}
    }
}

