/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class PublishEpubHandler {
    @Execute
    public void execute(Shell parentShell, IEclipseContext parentContext) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        boolean autoUpdate = prefs.getBoolean("urnUuidGeneration", false);
        String projectName = prefs.get("ebook_project_name", "GomsBook");
        String projectPath = prefs.get("ebook_project_folder", "C:\\1004.GomsBook\\01.EPub");
        String publishPath = prefs.get("ebook_publish_folder", "C:\\1004.GomsBook\\02.Publish");
        String projectFullPath = projectPath + "/" + projectName;
        String publishFullPath = publishPath + "/" + projectName;
        System.out.println("autoUpdate : " + autoUpdate);
        System.out.println("projectName : " + projectName);
        System.out.println("projectPath : " + projectPath);
        System.out.println("projectFullPath : " + projectFullPath);
        System.out.println("publishPath : " + publishPath);
        System.out.println("publishFullPath : " + publishFullPath);
        try {
            Path projectPathObj = Paths.get(projectFullPath, new String[0]);
            String projectFolderName = projectPathObj.getFileName().toString();
            String timeStamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddssmm"));
            String epubFileName = projectFolderName + "-" + timeStamp + ".epub";
            Path publishDir = Paths.get(publishFullPath, new String[0]);
            Files.createDirectories(publishDir, new FileAttribute[0]);
            Path publishEpubPath = publishDir.resolve(epubFileName);
            this.createEpub(projectFullPath, publishEpubPath);
            MessageDialog.openInformation((Shell)parentShell, (String)"EPUB \uc0dd\uc131 \uc644\ub8cc", (String)("EPUB \ud30c\uc77c \uc0dd\uc131 \uc644\ub8cc:\n" + publishEpubPath.toString()));
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)parentShell, (String)"EPUB \uc0dd\uc131 \uc624\ub958", (String)("\uc624\ub958 \ubc1c\uc0dd:\n" + e.getMessage()));
        }
    }

    private void createEpub(String sourceDirPath, Path publishEpubPath) throws IOException {
        Path sourceDir = Paths.get(sourceDirPath, new String[0]);
        Path tempZip = Files.createTempFile("epub_temp", ".zip", new FileAttribute[0]);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(tempZip, new OpenOption[0]));){
            byte[] mimeBytes = "application/epub+zip".getBytes(StandardCharsets.US_ASCII);
            ZipEntry mimetypeEntry = new ZipEntry("mimetype");
            mimetypeEntry.setMethod(0);
            mimetypeEntry.setSize(mimeBytes.length);
            mimetypeEntry.setCompressedSize(mimeBytes.length);
            CRC32 crc = new CRC32();
            crc.update(mimeBytes);
            mimetypeEntry.setCrc(crc.getValue());
            zipOut.putNextEntry(mimetypeEntry);
            zipOut.write(mimeBytes);
            zipOut.closeEntry();
            Files.walk(sourceDir, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path2 -> {
                String relPath = sourceDir.relativize((Path)path2).toString().replace("\\", "/");
                return !relPath.equals("mimetype");
            }).filter(path2 -> {
                String relPath = sourceDir.relativize((Path)path2).toString().replace("\\", "/");
                return !relPath.equals(".project");
            }).forEach(path2 -> {
                try {
                    String entryName = sourceDir.relativize((Path)path2).toString().replace("\\", "/");
                    ZipEntry entry = new ZipEntry(entryName);
                    zipOut.putNextEntry(entry);
                    Files.copy(path2, zipOut);
                    zipOut.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Files.copy(tempZip, publishEpubPath, StandardCopyOption.REPLACE_EXISTING);
        Files.deleteIfExists(tempZip);
    }
}

