/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import jakarta.inject.Named;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ResourceImportHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, EPartService partService) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL zipUrl = bundle.getEntry("resources/resource.zip");
        if (zipUrl == null) {
            MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)"\ubc88\ub4e4\uc5d0 ZIP \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        URL fileUrl = null;
        try {
            fileUrl = FileLocator.toFileURL((URL)zipUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File zipFile = new File(fileUrl.getPath());
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        String projectFolderPath = prefs.get("ebook_project_folder", "C:\\1004.GomsBook\\01.EPub");
        String projectFolderName = prefs.get("ebook_project_name", "GomsBook");
        String projectFullPath = projectFolderPath + "/" + projectFolderName;
        String workspacePath = projectFolderPath + "\\" + projectFolderName;
        System.out.println("\ud83d\udcc4 projectFolderPath: " + projectFolderPath);
        System.out.println("\ud83d\udcc4 projectFolderName: " + projectFolderName);
        System.out.println("\ud83d\udcc4 projectFullPath: " + projectFullPath);
        System.out.println("\ud83d\udcc4 workspacePath: " + workspacePath);
        File destDir = new File(projectFullPath);
        this.unzip(zipFile.getAbsolutePath(), destDir.getAbsolutePath(), shell);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("epubtest03");
        try {
            IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation((IPath)new Path(workspacePath));
            if (!project.exists()) {
                project.create(desc, null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            System.out.println("\ud83d\udcc4 project.toString(): " + project.toString());
            partService.showPart("kr.co.goms.epub.solution.parts.projectexplorer", EPartService.PartState.ACTIVATE);
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            System.out.println("\ud83d\udcc4 e.toString(): " + e.toString());
            e.printStackTrace();
        }
        partService.showPart("kr.co.goms.epub.solution.parts.projectexplorer", EPartService.PartState.ACTIVATE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzip(String zipFilePath, String destDir, Shell shell) {
        boolean[] overwriteAll = new boolean[1];
        boolean[] skipAll = new boolean[1];
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath));){
                block19: while (true) {
                    ZipEntry entry;
                    if ((entry = zis.getNextEntry()) == null) {
                        return;
                    }
                    File newFile = new File(destDir, entry.getName());
                    if (entry.isDirectory()) {
                        newFile.mkdirs();
                        continue;
                    }
                    new File(newFile.getParent()).mkdirs();
                    if (newFile.exists()) {
                        if (skipAll[0]) continue;
                        if (!overwriteAll[0]) {
                            String[] options = new String[]{"\ub36e\uc5b4\uc4f0\uae30", "\uac74\ub108\ub6f0\uae30", "\ubaa8\ub450 \ub36e\uc5b4\uc4f0\uae30", "\ubaa8\ub450 \uac74\ub108\ub6f0\uae30", "\ucde8\uc18c"};
                            MessageDialog dialog = new MessageDialog(shell, "\ud30c\uc77c \ucda9\ub3cc", null, "\ud30c\uc77c\uc774 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4:\n" + newFile.getName() + "\n\uc5b4\ub5bb\uac8c \ucc98\ub9ac\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?", 3, options, 0);
                            int choice = dialog.open();
                            switch (choice) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    continue block19;
                                }
                                case 2: {
                                    overwriteAll[0] = true;
                                    break;
                                }
                                case 3: {
                                    skipAll[0] = true;
                                    continue block19;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }
                    Throwable throwable2 = null;
                    Object var12_16 = null;
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        byte[] buffer = new byte[4096];
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                    zis.closeEntry();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

