/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveCoverImageHandler {
    @Execute
    public void execute(EPartService partService, EModelService modelService, MApplication application) {
        FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        dialog.setText("Select File to Add");
        String selectedPath = dialog.open();
        if (selectedPath == null) {
            return;
        }
        File sourceFile = new File(selectedPath);
        if (!sourceFile.exists()) {
            return;
        }
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFolder iFolder = iProject.getFolder("OEBPS/Images");
        IFile destFile = iFolder.getFile((IPath)new Path(sourceFile.getName()));
        try {
            if (destFile.exists()) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"File Exists", (String)("\ud30c\uc77c\uc774 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4: " + destFile.getName()));
                return;
            }
            Throwable throwable = null;
            Object var12_14 = null;
            try (FileInputStream fis = new FileInputStream(sourceFile);){
                destFile.create((InputStream)fis, true, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String href = iFolder.getProjectRelativePath().append(destFile.getName()).toString().substring("OEBPS/".length());
            String id = destFile.getName().replaceAll("[^a-zA-Z0-9\uac00-\ud7a3]", "_");
            boolean isXhtml = destFile.getName().toLowerCase().endsWith(".xhtml");
            boolean addToScripted = isXhtml;
            boolean addToLinearNo = false;
            OpfNcxUpdater.addFileToOpf(iProject.getFile("OEBPS/content.opf"), id, href, OpfNcxUpdater.getMediaType(destFile.getName()), isXhtml, addToScripted, addToLinearNo);
            EpubPartManager.getInstance().refreshProjectExplorer(partService, destFile.getName());
        }
        catch (IOException | CoreException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("\ud30c\uc77c \ubcf5\uc0ac \uc2e4\ud328: " + e.toString()));
        }
    }
}

