/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.handlers.table;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.solution.handlers.table.HtmlTableOps;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DuplicateTableBelowHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        HtmlTableOps.TableContext ctx;
        IDocument doc;
        IWorkbenchPart part;
        Shell shell;
        block6: {
            shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            part = HandlerUtil.getActivePart((ExecutionEvent)event);
            SourceViewer viewer = (SourceViewer)part.getSite().getService(SourceViewer.class);
            if (viewer == null || viewer.getDocument() == null) {
                MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)"SourceViewer\ub97c \ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.");
                return null;
            }
            int caret = viewer.widgetOffset2ModelOffset(viewer.getTextWidget().getCaretOffset());
            doc = viewer.getDocument();
            ctx = HtmlTableOps.locateTableAtCaret(doc, caret);
            if (ctx != null) break block6;
            MessageDialog.openInformation((Shell)shell, (String)"\ud45c \uc544\ub2d8", (String)"\ucee4\uc11c\uac00 \ud45c(<table>) \ub0b4\ubd80\uc5d0 \uc788\uc5b4\uc57c \ud569\ub2c8\ub2e4.");
            return null;
        }
        try {
            MPart mpart = (MPart)part.getSite().getService(MPart.class);
            Object tf = null;
            if (mpart != null) {
                tf = mpart.getTransientData().get("currentFile");
            }
            String baseName = "table";
            if (tf instanceof IFile) {
                String name = ((IFile)tf).getName();
                int dot = name.lastIndexOf(46);
                baseName = dot > 0 ? name.substring(0, dot) : name;
            }
            String docText = doc.get();
            int maxIdx = DuplicateTableBelowHandler.findMaxTableIndex(docText, baseName);
            String newId = baseName + "_table_" + (maxIdx + 1);
            String tableHtml = doc.get(ctx.tableStart, ctx.tableEnd - ctx.tableStart);
            String tableWithNewId = DuplicateTableBelowHandler.ensureTableId(tableHtml, newId);
            doc.replace(ctx.tableEnd, 0, "\n" + tableWithNewId + "\n");
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"\uc2e4\ud328", (String)("\ud45c \ubcf5\uc81c \uc911 \uc624\ub958: " + e.getMessage()));
        }
        return null;
    }

    private static int findMaxTableIndex(String text, String base) {
        Pattern p = Pattern.compile("<table[^>]*\\bid\\s*=\\s*\"" + Pattern.quote(base) + "_table_(\\d+)\"", 34);
        Matcher m = p.matcher(text);
        int max = 0;
        while (m.find()) {
            try {
                int n = Integer.parseInt(m.group(1));
                if (n <= max) continue;
                max = n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max;
    }

    private static String ensureTableId(String tableHtml, String newId) {
        int gt = tableHtml.indexOf(62);
        if (gt < 0) {
            return tableHtml;
        }
        String open = tableHtml.substring(0, gt + 1);
        String rest = tableHtml.substring(gt + 1);
        Pattern idAttr = Pattern.compile("(?i)\\bid\\s*=\\s*\"([^\"]*)\"");
        Matcher m = idAttr.matcher(open);
        if (m.find()) {
            String replaced = m.replaceFirst("id=\"" + Matcher.quoteReplacement(newId) + "\"");
            return replaced + rest;
        }
        String openTrim = open.trim();
        if (openTrim.regionMatches(true, 0, "<table", 0, 6)) {
            int insertPos = open.indexOf("<table") + 6;
            String prefix = open.substring(0, insertPos);
            Object suffix = open.substring(insertPos);
            if (!((String)suffix).startsWith(" ")) {
                suffix = " " + (String)suffix;
            }
            String withId = prefix + ((String)suffix).replaceFirst("\\s*", " id=\"" + Matcher.quoteReplacement(newId) + "\" ");
            return withId + rest;
        }
        return open.replaceFirst("(?i)<table", "<table id=\"" + Matcher.quoteReplacement(newId) + "\"") + rest;
    }
}

