/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.lifecycle;

import java.io.IOException;
import kr.co.goms.epub.managers.SplashManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class EpubE4Application
extends E4Application {
    private Shell splashShell;
    private ProgressBar progressBar;
    private Label messageLabel;
    private final IResourceChangeListener closeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResource resource;
            if (event.getType() == 2 && (resource = event.getResource()) instanceof IProject) {
                IProject project = (IProject)resource;
                System.out.println("\ud83d\udd34 Project is closing: " + project.getName());
                EpubE4Application.this.stopOllama();
            }
        }
    };

    public Object start(IApplicationContext applicationContext) throws Exception {
        System.out.println("\ud83d\udfe2 EpubE4Application started");
        Display display = new Display();
        this.createSplash(display);
        SplashManager.getInstance().setSplashApp(this);
        Object result = super.start(applicationContext);
        this.closeSplash();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.closeListener, 2);
        if (!display.isDisposed()) {
            display.dispose();
        }
        return result;
    }

    private void createSplash(Display display) {
        this.splashShell = new Shell(display, 16392);
        Image splashImage = new Image((Device)display, ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("splash.png"));
        int width = splashImage.getBounds().width;
        int height = splashImage.getBounds().height;
        this.splashShell.setSize(width, height);
        Label splashLabel = new Label((Composite)this.splashShell, 0);
        splashLabel.setImage(splashImage);
        splashLabel.setBounds(0, 0, width, height);
        this.progressBar = new ProgressBar((Composite)this.splashShell, 0);
        this.progressBar.setBounds(10, height - 40, width - 20, 20);
        this.messageLabel = new Label((Composite)this.splashShell, 0);
        this.messageLabel.setBounds(10, height - 70, width - 20, 20);
        this.splashShell.open();
    }

    public void setProgress(int value) {
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setSelection(value);
            this.splashShell.update();
        }
    }

    public void setMessage(String message) {
        if (this.messageLabel != null && !this.messageLabel.isDisposed()) {
            this.messageLabel.setText(message);
            this.splashShell.update();
        }
    }

    private void closeSplash() {
        if (this.splashShell != null && !this.splashShell.isDisposed()) {
            this.splashShell.dispose();
        }
    }

    public void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.closeListener);
        System.out.println("\ud83d\udd3b EpubE4Application stopped");
        super.stop();
    }

    private void stopOllama() {
        try {
            ProcessBuilder builder = new ProcessBuilder("ollama", "stop");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            int exit = process.waitFor();
            System.out.println("\u2705 Ollama stopped. Exit code: " + exit);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}

