/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.lifecycle;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.wizard.InstallWizard;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MyLifeCycle {
    @PostContextCreate
    public void afterContext(IEclipseContext ctx, Display display) {
        display.asyncExec(() -> {
            IThemeEngine engine = (IThemeEngine)ctx.get(IThemeEngine.class);
            if (engine != null) {
                engine.setTheme("org.eclipse.e4.ui.css.theme.e4_dark", true);
            }
        });
    }

    @PostConstruct
    public void postContextCreate(IEclipseContext ctx, Display display) {
        Shell shell = Display.getDefault().getActiveShell();
        if (shell == null) {
            shell = new Shell(Display.getDefault());
        }
        if (!this.isAlreadyInstalled()) {
            WizardDialog dialog = new WizardDialog(shell, (IWizard)new InstallWizard());
            int result = dialog.open();
            if (result == 0) {
                System.out.println("\uc124\uce58 \uc644\ub8cc");
            } else {
                ctx.dispose();
            }
        } else {
            System.out.println("MyLifeCycle > \uc774\ubbf8 \uc124\uce58\ub428");
            this.checkLicense(ctx, shell);
        }
    }

    private boolean isAlreadyInstalled() {
        Path installPath = this.loadInstallPathFromPreferences();
        return Files.exists(installPath.resolve("install.status"), new LinkOption[0]);
    }

    private Path loadInstallPathFromPreferences() {
        Path installPath = Path.of("C:\\1004.GomsBook\\01.EPub", new String[0]);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        String pProjectPath = prefs.get("ebook_project_folder", "C:\\1004.GomsBook\\01.EPub");
        if (pProjectPath != null) {
            installPath = Path.of(pProjectPath, new String[0]);
        }
        return installPath;
    }

    private void checkLicense(final IEclipseContext context, Shell shell) {
        String installPath = EpubPreferenceManager.getInstance().getProjectPath();
        File licFile = new File(installPath, "gomsbook.lic");
        String str = null;
        try {
            str = Files.readString(licFile.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("lic : " + str);
        String[] licArray = str.split("\\|");
        System.out.println("lic len : " + licArray.length);
        String licenseKey = licArray[0];
        String licenseEmail = licArray[1];
        String licenseDeviceId = licArray[2];
        String licenseProductId = "GOMSBOOK_PRO";
        int responseVerifyCode = CommonUtil.verifyLicenseFromServer(licenseKey, licenseEmail, licenseDeviceId, licenseProductId);
        System.out.println("responseVerifyCode : " + responseVerifyCode);
        if (responseVerifyCode != 200) {
            String responseVerifyMessage = "\ub77c\uc774\uc120\uc2a4 \uac80\uc99d \uc2e4\ud328\uc785\ub2c8\ub2e4. \uc62c\ubc14\ub978 \ub77c\uc774\uc120\uc2a4\ub97c \ub123\uc5b4\uc8fc\uc138\uc694";
            if (responseVerifyCode == 302) {
                responseVerifyMessage = "\ud574\ub2f9 \ub77c\uc774\uc120\uc2a4\uac00 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
            } else if (responseVerifyCode == 303) {
                responseVerifyMessage = "\ud574\ub2f9 \ub77c\uc774\uc120\uc2a4\uc758 \uc774\uba54\uc77c\uc774 \ud2c0\ub9bd\ub2c8\ub2e4.";
            } else if (responseVerifyCode == 304) {
                responseVerifyMessage = "\ud574\ub2f9 \ub77c\uc774\uc120\uc2a4\uc758 \ub514\ubc14\uc774\uc2a4\uac12\uc774 \ud2c0\ub9bd\ub2c8\ub2e4.";
            } else if (responseVerifyCode == 305) {
                responseVerifyMessage = "\ud574\ub2f9 \ub77c\uc774\uc120\uc2a4\uc758 \uc81c\ud488\uac12\uc774 \ud2c0\ub9bd\ub2c8\ub2e4.";
            }
            CommonUtil.showMessageBoxAndCallback(shell, responseVerifyMessage, new CommonUtil.MessageCallback(){

                @Override
                public void callback() {
                    context.dispose();
                }
            });
        }
    }
}

