/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.pages;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.ui.TemplateItem;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.utils.ResourceUtil;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

@Creatable
public class EpubPublishInfoSettingPage {
    private Preferences prefs;
    private Composite rightContainer;
    private StackLayout rightStack;
    private Composite publishForm;
    private Composite xhtmlForm;
    private Label menuPublishInfo;
    private Label menuXhtmlInfo;
    private Color white;
    private Color menuHover;
    private Color menuSelected;
    private Color menuNormalBg;
    private Font menuFont;
    private Color previewColor;
    private Text bookTitleText;
    private Text publishingHouseNameText;
    private Text publisherNameText;
    private Text publishingHouseAddrText;
    private Text publishingHouseTelText;
    private Text publishingHouseEmailText;
    private Text isbnText;
    private Text publishDateText;
    private Text backgroundColor;
    private Browser browser;
    private TemplateItem selectedTemplateItem;
    ModifyListener[] modifyHolder = new ModifyListener[1];
    @Inject
    Shell shell;

    @PostConstruct
    public void createControls(Composite parent) {
        this.prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftTreeViewer((Composite)sashForm);
        this.createRightForm((Composite)sashForm);
        this.createPreview((Composite)sashForm);
        sashForm.setWeights(new int[]{15, 35, 50});
    }

    private void createLeftTreeViewer(Composite parent) {
        Color white;
        Composite left = new Composite(parent, 2048);
        left.setLayout((Layout)new GridLayout());
        Display display = parent.getDisplay();
        this.menuNormalBg = white = display.getSystemColor(1);
        this.menuHover = new Color((Device)display, 240, 245, 250);
        this.menuSelected = new Color((Device)display, 220, 235, 250);
        this.menuFont = new Font((Device)display, "Segoe UI", 10, 1);
        left.setBackground(white);
        this.menuPublishInfo = new Label(left, 0);
        this.menuPublishInfo.setText("\ucd9c\ud310\uc815\ubcf4");
        this.styleAsMenu(this.menuPublishInfo);
        this.menuXhtmlInfo = new Label(left, 0);
        this.menuXhtmlInfo.setText("\ud398\uc774\uc9c0\uc124\uc815");
        this.styleAsMenu(this.menuXhtmlInfo);
        this.attachMenuBehavior(this.menuPublishInfo, () -> this.showRight("publish"));
        this.attachMenuBehavior(this.menuXhtmlInfo, () -> this.showRight("xhtml"));
        this.selectMenu(this.menuPublishInfo);
        this.showRight("publish");
        left.addListener(12, e -> {
            if (this.menuHover != null && !this.menuHover.isDisposed()) {
                this.menuHover.dispose();
            }
            if (this.menuSelected != null && !this.menuSelected.isDisposed()) {
                this.menuSelected.dispose();
            }
            if (this.menuFont != null && !this.menuFont.isDisposed()) {
                this.menuFont.dispose();
            }
        });
    }

    private void styleAsMenu(Label lbl) {
        lbl.setBackground(this.menuNormalBg);
        lbl.setFont(this.menuFont);
        lbl.setCursor(lbl.getDisplay().getSystemCursor(21));
        GridData gd = new GridData(4, 128, true, false);
        gd.verticalIndent = 6;
        gd.horizontalIndent = 8;
        lbl.setLayoutData((Object)gd);
    }

    private void attachMenuBehavior(final Label lbl, final Runnable onClick) {
        lbl.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (lbl.getData("selected") != Boolean.TRUE) {
                    lbl.setBackground(EpubPublishInfoSettingPage.this.menuHover);
                }
            }

            public void mouseExit(MouseEvent e) {
                if (lbl.getData("selected") != Boolean.TRUE) {
                    lbl.setBackground(EpubPublishInfoSettingPage.this.menuNormalBg);
                }
            }
        });
        lbl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                EpubPublishInfoSettingPage.this.selectMenu(lbl);
                onClick.run();
            }
        });
    }

    private void selectMenu(Label selected) {
        Label[] labelArray = new Label[]{this.menuPublishInfo, this.menuXhtmlInfo};
        int n = labelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Label lbl = labelArray[n2];
            if (lbl != null && !lbl.isDisposed()) {
                lbl.setData("selected", (Object)Boolean.FALSE);
                lbl.setBackground(this.menuNormalBg);
            }
            ++n2;
        }
        selected.setData("selected", (Object)Boolean.TRUE);
        selected.setBackground(this.menuSelected);
    }

    private void showRight(String key) {
        if (this.rightContainer == null || this.rightContainer.isDisposed()) {
            return;
        }
        switch (key) {
            case "publish": {
                this.rightStack.topControl = this.publishForm;
                break;
            }
            case "xhtml": {
                this.rightStack.topControl = this.xhtmlForm;
            }
        }
        this.rightContainer.layout(true, true);
    }

    private void createRightForm(Composite parent) {
        this.rightContainer = new Composite(parent, 0);
        this.rightStack = new StackLayout();
        this.rightContainer.setLayout((Layout)this.rightStack);
        this.publishForm = this.createPublishForm(this.rightContainer);
        this.xhtmlForm = this.createXhtmlForm(this.rightContainer);
        this.rightStack.topControl = this.publishForm;
        this.rightContainer.layout(true, true);
    }

    private Composite createPublishForm(Composite parent) {
        Color backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setBackground(backgroundColor);
        Label bookTitleLabel = new Label(container, 0);
        bookTitleLabel.setText("\ucc45\uc81c\ubaa9");
        bookTitleLabel.setBackground(backgroundColor);
        this.bookTitleText = new Text(container, 2048);
        this.bookTitleText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.bookTitleText.setText(EpubPreferenceManager.getInstance().getProjectBookTitle());
        this.bookTitleText.addModifyListener(e -> this.showPreview());
        Label publishingHouseLabel = new Label(container, 0);
        publishingHouseLabel.setText("\ucd9c\ud310\uc0ac");
        publishingHouseLabel.setBackground(backgroundColor);
        this.publishingHouseNameText = new Text(container, 2048);
        this.publishingHouseNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publishingHouseNameText.setText(EpubPreferenceManager.getInstance().getProjectPublishingHouseName());
        this.publishingHouseNameText.addModifyListener(e -> this.showPreview());
        Label publisherNameLabel = new Label(container, 0);
        publisherNameLabel.setText("\ubc1c\ud589\uc778");
        publisherNameLabel.setBackground(backgroundColor);
        this.publisherNameText = new Text(container, 2048);
        this.publisherNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publisherNameText.setText(EpubPreferenceManager.getInstance().getProjectPublisherName());
        this.publisherNameText.addModifyListener(e -> this.showPreview());
        Label publishingHouseAddrLabel = new Label(container, 0);
        publishingHouseAddrLabel.setText("\uc8fc\uc18c");
        publishingHouseAddrLabel.setBackground(backgroundColor);
        this.publishingHouseAddrText = new Text(container, 2048);
        this.publishingHouseAddrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publishingHouseAddrText.setText(EpubPreferenceManager.getInstance().getProjectPublishingHouseAddr());
        this.publishingHouseAddrText.addModifyListener(e -> this.showPreview());
        Label publishingHouseTelLebel = new Label(container, 0);
        publishingHouseTelLebel.setText("\uc804\ud654");
        publishingHouseTelLebel.setBackground(backgroundColor);
        this.publishingHouseTelText = new Text(container, 2048);
        this.publishingHouseTelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publishingHouseTelText.setText(EpubPreferenceManager.getInstance().getProjectPublishingHouseTel());
        this.publishingHouseTelText.addModifyListener(e -> this.showPreview());
        Label publishingHouseEmailLebel = new Label(container, 0);
        publishingHouseEmailLebel.setText("\uc774\uba54\uc77c");
        publishingHouseEmailLebel.setBackground(backgroundColor);
        this.publishingHouseEmailText = new Text(container, 2048);
        this.publishingHouseEmailText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publishingHouseEmailText.setText(EpubPreferenceManager.getInstance().getProjectPublishingHouseEmail());
        this.publishingHouseEmailText.addModifyListener(e -> this.showPreview());
        Label isbnLebel = new Label(container, 0);
        isbnLebel.setText("ISBN");
        isbnLebel.setBackground(backgroundColor);
        this.isbnText = new Text(container, 2048);
        this.isbnText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.isbnText.setText(EpubPreferenceManager.getInstance().getProjectPublishingISBN());
        this.isbnText.addModifyListener(e -> this.showPreview());
        Label publishDateLebel = new Label(container, 0);
        publishDateLebel.setText("\ubc1c\ud589\uc77c");
        publishDateLebel.setBackground(backgroundColor);
        this.publishDateText = new Text(container, 2048);
        this.publishDateText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.publishDateText.setText(EpubPreferenceManager.getInstance().getProjectPublishingDate());
        this.publishDateText.setMessage("yyyy-MM-dd");
        this.modifyHolder[0] = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EpubPublishInfoSettingPage.this.publishDateText.removeModifyListener(EpubPublishInfoSettingPage.this.modifyHolder[0]);
                String raw = EpubPublishInfoSettingPage.this.publishDateText.getText().replaceAll("[^\\d]", "");
                StringBuilder formatted = new StringBuilder();
                if (raw.length() > 4) {
                    formatted.append(raw.substring(0, 4)).append("-");
                    if (raw.length() > 6) {
                        formatted.append(raw.substring(4, 6)).append("-");
                        formatted.append(raw.substring(6, Math.min(8, raw.length())));
                    } else {
                        formatted.append(raw.substring(4));
                    }
                } else {
                    formatted.append(raw);
                }
                String formattedText = formatted.toString();
                EpubPublishInfoSettingPage.this.publishDateText.setText(formattedText);
                EpubPublishInfoSettingPage.this.publishDateText.setSelection(formatted.length());
                EpubPublishInfoSettingPage.this.publishDateText.addModifyListener(EpubPublishInfoSettingPage.this.modifyHolder[0]);
                boolean valid = false;
                if (formattedText.matches("\\d{4}-\\d{2}-\\d{2}")) {
                    try {
                        LocalDate.parse(formattedText, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        valid = true;
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        valid = false;
                    }
                }
                EpubPublishInfoSettingPage.this.publishDateText.setForeground(Display.getCurrent().getSystemColor(valid ? 2 : 3));
                EpubPublishInfoSettingPage.this.showPreview();
            }
        };
        this.publishDateText.addModifyListener(this.modifyHolder[0]);
        DateTime publishDatePicker = new DateTime(container, 2084);
        GridData pickerLayout = new GridData(16384, 0x1000000, false, false);
        pickerLayout.widthHint = 20;
        publishDatePicker.setLayoutData((Object)pickerLayout);
        publishDatePicker.addListener(13, e -> {
            int year = publishDatePicker.getYear();
            int month = publishDatePicker.getMonth() + 1;
            int day = publishDatePicker.getDay();
            LocalDate selectedDate = LocalDate.of(year, month, day);
            String formatted = selectedDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            this.publishDateText.setText(formatted);
        });
        Button previewBtn = new Button(container, 8);
        previewBtn.setText("\ubbf8\ub9ac\ubcf4\uae30");
        previewBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        previewBtn.addListener(13, e -> this.showPreview());
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        Button saveBtn = new Button(container, 8);
        saveBtn.setText("\uc800\uc7a5");
        GridData btnData = new GridData();
        btnData.horizontalSpan = 2;
        btnData.horizontalAlignment = 131072;
        saveBtn.setLayoutData((Object)btnData);
        saveBtn.addListener(13, e -> this.savePublishInfo());
        return container;
    }

    private Composite createXhtmlForm(Composite parent) {
        Color bgColor = new Color((Device)parent.getDisplay(), 235, 240, 250);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setBackground(bgColor);
        Label bgLabel = new Label(container, 0);
        bgLabel.setText("\ubc30\uacbd\uc0c9 (#RRGGBB)");
        bgLabel.setBackground(bgColor);
        Text txtBgColor = new Text(container, 2048);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        txtBgColor.setLayoutData((Object)gd2);
        Button btnPick = new Button(container, 8);
        btnPick.setText("\uc120\ud0dd...");
        Label previewLabel = new Label(container, 0);
        previewLabel.setText("\ubbf8\ub9ac\ubcf4\uae30");
        previewLabel.setBackground(bgColor);
        Label preview = new Label(container, 2048);
        GridData gdPreview = new GridData(4, 0x1000000, true, false);
        gdPreview.horizontalSpan = 2;
        gdPreview.heightHint = 28;
        preview.setLayoutData((Object)gdPreview);
        preview.setText("  ");
        preview.setToolTipText("\ud074\ub9ad\ud558\uc5ec \uc0c9\uc0c1 \uc120\ud0dd");
        Button previewBtn = new Button(container, 8);
        previewBtn.setText("\ubbf8\ub9ac\ubcf4\uae30");
        previewBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        previewBtn.addListener(13, e -> this.showPreview());
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        Button saveBtn = new Button(container, 8);
        saveBtn.setText("\uc800\uc7a5");
        GridData btnData = new GridData();
        btnData.horizontalSpan = 2;
        btnData.horizontalAlignment = 131072;
        saveBtn.setLayoutData((Object)btnData);
        saveBtn.addListener(13, e -> this.savePublishInfo());
        String initial = EpubPreferenceManager.getInstance().get("page.color.bg", "#E6F0FF");
        txtBgColor.setText(initial);
        this.applyPreviewColor(preview, initial);
        txtBgColor.addModifyListener(e -> {
            String hex = txtBgColor.getText().trim();
            this.applyPreviewColor(preview, hex);
        });
        Listener openPicker = ev -> {
            String chosen = this.openColorDialogGetHex(container.getShell(), txtBgColor.getText().trim());
            if (chosen != null) {
                txtBgColor.setText(chosen);
                EpubPreferenceManager.getInstance().put("page.color.bg", chosen);
            }
        };
        btnPick.addListener(13, openPicker);
        preview.addListener(3, openPicker);
        txtBgColor.setToolTipText("#RRGGBB \ud615\uc2dd (\uc608: #1E90FF)");
        btnPick.setToolTipText("\uc0c9\uc0c1 \uc120\ud0dd \ub300\ud654\uc0c1\uc790 \uc5f4\uae30");
        container.addListener(12, e -> {
            Color bg = container.getBackground();
            if (bg != null && !bg.isDisposed()) {
                bg.dispose();
            }
        });
        return container;
    }

    private void createPreview(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(container, 2048);
        GridData browserData = new GridData(4, 4, true, true, 2, 1);
        this.browser.setLayoutData((Object)browserData);
        this.browser.setText("<p>\ucd9c\ud310\uc0ac \uc815\ubcf4\ub97c \uc785\ub825\ud558\uace0, \ubbf8\ub9ac\ubcf4\uae30 \ubc84\ud2bc\uc744 \ub20c\ub7ec\uc8fc\uc138\uc694.</p>");
        this.applyPreviewBackground(EpubPreferenceManager.getInstance().get("page.color.bg", "#ffffff"));
    }

    private void showPreview() {
        System.out.println("showPreview()");
        String fileName = "publisher_template1.xhtml";
        String displayName = "\ud15c\ud50c\ub9bf1-\uae30\ubcf8\ud615";
        String categoryName = "publish";
        this.selectedTemplateItem = new TemplateItem(fileName, displayName, categoryName);
        if (this.selectedTemplateItem == null) {
            this.browser.setText("<p>\uba3c\uc800 \ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uc138\uc694.</p>");
            return;
        }
        System.out.println("fileName : " + fileName);
        if (fileName == null) {
            this.browser.setText("<p>\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ud15c\ud50c\ub9bf\uc785\ub2c8\ub2e4.</p>");
            return;
        }
        String bookTitle = this.bookTitleText.getText().trim();
        String publishingHouse = this.publishingHouseNameText.getText().trim();
        String publisherName = this.publisherNameText.getText().trim();
        String publishingHouseAddr = this.publishingHouseAddrText.getText().trim();
        String publishingHouseTel = this.publishingHouseTelText.getText().trim();
        String publishingHouseEmail = this.publishingHouseEmailText.getText().trim();
        String isbn = this.isbnText.getText().trim();
        String publishDate = this.publishDateText.getText().trim();
        String templateHtml = ResourceUtil.loadFromBundle("resources/templates/publisher", fileName);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("\ucc45\uc81c\ubaa9", bookTitle);
        values.put("\ucd9c\ud310\uc0ac", publishingHouse);
        values.put("\ubc1c\ud589\uc778", publisherName == null ? "" : publisherName);
        values.put("\uc8fc\uc18c", publishingHouseAddr);
        values.put("\uc804\ud654", publishingHouseTel);
        values.put("\uc774\uba54\uc77c", publishingHouseEmail);
        values.put("ISBN", isbn);
        values.put("\ubc1c\ud589\uc77c", publishDate);
        String renderedHtml = CommonUtil.replaceVariables(templateHtml, values);
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String resultHtmlContent = CommonUtil.changeStylePath(projectFullPath, renderedHtml);
        String hexBgColor = EpubPreferenceManager.getInstance().get("page.color.bg", "#ffffff");
        System.out.println("showPreview() hexBgColor : " + hexBgColor);
        resultHtmlContent = this.applyPreviewBackgroundColor(hexBgColor, resultHtmlContent);
        this.browser.setText(resultHtmlContent);
    }

    private void savePublishInfo() {
        String bookTitle = this.bookTitleText.getText().trim();
        String publishingHouseName = this.publishingHouseNameText.getText().trim();
        String publisherName = this.publisherNameText.getText().trim();
        String publishingHouseAddr = this.publishingHouseAddrText.getText().trim();
        String publishingHouseTel = this.publishingHouseTelText.getText().trim();
        String publishingHouseEmail = this.publishingHouseEmailText.getText().trim();
        String publishISBN = this.isbnText.getText().trim();
        String publishDate = this.publishDateText.getText().trim();
        boolean valid = false;
        if (publishDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            try {
                LocalDate.parse(publishDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                valid = true;
            }
            catch (DateTimeParseException dateTimeParseException) {
                valid = false;
            }
        }
        if (!valid) {
            CommonUtil.showMessageBox(this.shell, "\ub0a0\uc9dc\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            return;
        }
        EpubPreferenceManager.getInstance().put("ebook_project_book_title", bookTitle);
        EpubPreferenceManager.getInstance().put("ebook_project_publish_house_name", publishingHouseName);
        EpubPreferenceManager.getInstance().put("ebook_project_publisher_name", publisherName);
        EpubPreferenceManager.getInstance().put("ebook_project_publish_house_addr", publishingHouseAddr);
        EpubPreferenceManager.getInstance().put("ebook_project_publish_house_tel", publishingHouseTel);
        EpubPreferenceManager.getInstance().put("ebook_project_publish_house_email", publishingHouseEmail);
        EpubPreferenceManager.getInstance().put("ebook_project_publish_isbn", publishISBN);
        EpubPreferenceManager.getInstance().put("ebook_project_publish_date", publishDate);
        String hexBgColor = EpubPreferenceManager.getInstance().get("page.color.bg", "#ffffff");
        String style1CSS = EpubBuildUtil.getProjectOEBPSCSSFile("style1.css");
        String navCSS = EpubBuildUtil.getProjectOEBPSCSSFile("nav.css");
        String quizCSS = EpubBuildUtil.getProjectOEBPSCSSFile("quiz.css");
        Path styleCSSFile = Path.of(style1CSS, new String[0]);
        Path navCSSFile = Path.of(navCSS, new String[0]);
        Path quizCSSFile = Path.of(quizCSS, new String[0]);
        try {
            EpubPublishInfoSettingPage.updateBackgroundColor(styleCSSFile, hexBgColor);
            EpubPublishInfoSettingPage.updateBackgroundColor(navCSSFile, hexBgColor);
            EpubPublishInfoSettingPage.updateBackgroundColor(quizCSSFile, hexBgColor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private RGB parseHexToRGB(String hex) {
        if (hex == null) {
            return null;
        }
        String s = hex.trim();
        if (!s.matches("^#([A-Fa-f0-9]{6})$")) {
            return null;
        }
        int r = Integer.parseInt(s.substring(1, 3), 16);
        int g = Integer.parseInt(s.substring(3, 5), 16);
        int b = Integer.parseInt(s.substring(5, 7), 16);
        return new RGB(r, g, b);
    }

    private String rgbToHex(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return String.format("#%02X%02X%02X", rgb.red, rgb.green, rgb.blue);
    }

    private void applyPreviewColor(Label preview, String hex) {
        RGB rgb = this.parseHexToRGB(hex);
        Display d = preview.getDisplay();
        if (rgb != null) {
            if (this.previewColor != null && !this.previewColor.isDisposed()) {
                this.previewColor.dispose();
            }
            this.previewColor = new Color((Device)d, rgb);
            EpubPreferenceManager.getInstance().put("page.color.bg", this.rgbToHex(rgb));
            preview.setBackground(this.previewColor);
            preview.setText("  " + this.rgbToHex(rgb));
            preview.setForeground(d.getSystemColor(2));
            preview.setToolTipText("\ubc30\uacbd\uc0c9: " + this.rgbToHex(rgb));
        } else {
            preview.setBackground(d.getSystemColor(1));
            preview.setForeground(d.getSystemColor(3));
            preview.setText("  \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0c9\uc0c1 (#RRGGBB)");
            preview.setToolTipText("\uc608: #1E90FF");
        }
    }

    private String openColorDialogGetHex(Shell parentShell, String currentHex) {
        RGB picked;
        ColorDialog dlg = new ColorDialog(parentShell);
        RGB cur = this.parseHexToRGB(currentHex);
        if (cur != null) {
            dlg.setRGB(cur);
        }
        if ((picked = dlg.open()) == null) {
            return null;
        }
        return this.rgbToHex(picked);
    }

    private boolean isValidHex(String hex) {
        return hex != null && hex.trim().matches("^#([A-Fa-f0-9]{6})$");
    }

    private void applyPreviewBackground(String hex) {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        String color = this.isValidHex(hex) ? hex : "#FFFFFF";
        String js = "try { document.documentElement.style.setProperty('--background-color', '" + color + "'); } catch(e) { console.error(e); }";
        this.browser.execute(js);
    }

    private String applyPreviewBackgroundColor(String hexColor, String resultHtmlContent) {
        String style = "<style>:root { --background-color: " + hexColor + "; }</style>";
        resultHtmlContent = resultHtmlContent.replace("</head>", style + "</head>");
        return resultHtmlContent;
    }

    public static void updateBackgroundColor(Path cssFile, String newHex) throws IOException {
        if (!((String)newHex).startsWith("#")) {
            newHex = "#" + (String)newHex;
        }
        String content = Files.readString(cssFile, StandardCharsets.UTF_8);
        String updated = content.replaceAll("--background-color:\\s*#[0-9a-fA-F]{6};", "--background-color: " + (String)newHex + ";");
        Files.writeString(cssFile, (CharSequence)updated, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

