/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.pages;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.providers.TemplateTreeItemContentProvider;
import kr.co.goms.epub.solution.ui.TemplateItem;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import kr.co.goms.epub.solution.utils.ResourceUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.service.prefs.Preferences;

public class PublisherTemplateEditorPage {
    private Text bookTitleText;
    private Text authorText;
    private Text publishingHouseText;
    private Text publisherNameText;
    private Text publishingHouseAddrText;
    private Text publishingHouseTelText;
    private Text publishingHouseEmailText;
    private Text isbnText;
    private Text publishInfoText;
    private TreeViewer treeViewer;
    private Browser browser;
    Preferences prefs;
    private List<TemplateItem> templateList;
    private TemplateItem selectedTemplateItem;
    @Inject
    private Shell shell;

    @PostConstruct
    public void createControls(Composite parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent composite cannot be null");
        }
        this.prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftTreeViewer((Composite)sashForm);
        this.createRightForm((Composite)sashForm);
        this.createPreview((Composite)sashForm);
        sashForm.setWeights(new int[]{25, 35, 40});
    }

    private void createLeftTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2052);
        this.templateList = ResourceUtil.getTemplateFolderList("publisher");
        this.treeViewer.setContentProvider((IContentProvider)new TemplateTreeItemContentProvider());
        this.treeViewer.setInput(this.templateList);
        this.treeViewer.addSelectionChangedListener(event -> {
            ITreeSelection selection = this.treeViewer.getStructuredSelection();
            this.selectedTemplateItem = (TemplateItem)selection.getFirstElement();
            System.out.println("\uc120\ud0dd\ud55c \ud15c\ud50c\ub9bf : " + this.selectedTemplateItem.displayName);
            this.showPreview();
        });
    }

    private void createRightForm(Composite parent) {
        Color backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setBackground(backgroundColor);
        Label bookTitleLabel = new Label(container, 0);
        bookTitleLabel.setText("\ucc45\uc81c\ubaa9");
        bookTitleLabel.setBackground(backgroundColor);
        this.bookTitleText = new Text(container, 2048);
        this.bookTitleText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.bookTitleText.setText(EpubPreferenceManager.getInstance().getProjectBookTitle());
        this.bookTitleText.addModifyListener(e -> this.showPreview());
        Label authorLabel = new Label(container, 0);
        authorLabel.setText("\uc791\uac00\uba85");
        authorLabel.setBackground(backgroundColor);
        this.authorText = new Text(container, 2048);
        this.authorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.authorText.setText(EpubPreferenceManager.getInstance().getProjectBookTitle());
        this.authorText.addModifyListener(e -> this.showPreview());
        Label publishingHouseLabel = new Label(container, 0);
        publishingHouseLabel.setText("\ucd9c\ud310\uc0ac");
        publishingHouseLabel.setBackground(backgroundColor);
        this.publishingHouseText = new Text(container, 2048);
        this.publishingHouseText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publishingHouseText.setText(EpubPreferenceManager.getInstance().getProjectPublishingHouseName());
        this.publishingHouseText.addModifyListener(e -> this.showPreview());
        Label publisherNameLabel = new Label(container, 0);
        publisherNameLabel.setText("\ubc1c\ud589\uc778");
        publisherNameLabel.setBackground(backgroundColor);
        this.publisherNameText = new Text(container, 2048);
        this.publisherNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publisherNameText.setText(EpubPreferenceManager.getInstance().getProjectPublisherName());
        this.publisherNameText.addModifyListener(e -> this.showPreview());
        Label publishingHouseAddrLabel = new Label(container, 0);
        publishingHouseAddrLabel.setText("\uc8fc\uc18c");
        publishingHouseAddrLabel.setBackground(backgroundColor);
        this.publishingHouseAddrText = new Text(container, 2048);
        this.publishingHouseAddrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publishingHouseAddrText.setText(EpubPreferenceManager.getInstance().getProjectPublishingHouseAddr());
        this.publishingHouseAddrText.addModifyListener(e -> this.showPreview());
        Label publishingHouseTelLebel = new Label(container, 0);
        publishingHouseTelLebel.setText("\uc804\ud654");
        publishingHouseTelLebel.setBackground(backgroundColor);
        this.publishingHouseTelText = new Text(container, 2048);
        this.publishingHouseTelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publishingHouseTelText.setText(EpubPreferenceManager.getInstance().getProjectPublishingHouseTel());
        this.publishingHouseTelText.addModifyListener(e -> this.showPreview());
        Label publishingHouseEmailLebel = new Label(container, 0);
        publishingHouseEmailLebel.setText("\uc774\uba54\uc77c");
        publishingHouseEmailLebel.setBackground(backgroundColor);
        this.publishingHouseEmailText = new Text(container, 2048);
        this.publishingHouseEmailText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publishingHouseEmailText.setText(EpubPreferenceManager.getInstance().getProjectPublishingHouseEmail());
        this.publishingHouseEmailText.addModifyListener(e -> this.showPreview());
        Label isbnLebel = new Label(container, 0);
        isbnLebel.setText("ISBN");
        isbnLebel.setBackground(backgroundColor);
        this.isbnText = new Text(container, 2048);
        this.isbnText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.isbnText.addModifyListener(e -> this.showPreview());
        Label publishDateLebel = new Label(container, 0);
        publishDateLebel.setText("\ucd9c\ud310\ub4f1\ub85d");
        publishDateLebel.setBackground(backgroundColor);
        this.publishInfoText = new Text(container, 2048);
        this.publishInfoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.publishInfoText.addModifyListener(e -> this.showPreview());
        Button previewBtn = new Button(container, 8);
        previewBtn.setText("\ubbf8\ub9ac\ubcf4\uae30");
        previewBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        previewBtn.addListener(13, e -> this.showPreview());
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        Button saveBtn = new Button(container, 8);
        saveBtn.setText("\uc800\uc7a5");
        GridData btnData = new GridData();
        btnData.horizontalSpan = 2;
        btnData.horizontalAlignment = 131072;
        saveBtn.setLayoutData((Object)btnData);
        saveBtn.addListener(13, e -> this.saveXHTML());
    }

    private void createPreview(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(container, 2048);
        GridData browserData = new GridData(4, 4, true, true, 2, 1);
        this.browser.setLayoutData((Object)browserData);
        this.browser.setText("<p>\ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uace0 \ubbf8\ub9ac\ubcf4\uae30 \ubc84\ud2bc\uc744 \ub20c\ub7ec\uc8fc\uc138\uc694.</p>");
    }

    private void showPreview() {
        System.out.println("showPreview()");
        if (this.selectedTemplateItem == null) {
            this.browser.setText("<p>\uba3c\uc800 \ud15c\ud50c\ub9bf\uc744 \uc120\ud0dd\ud558\uc138\uc694.</p>");
            return;
        }
        String fileName = this.selectedTemplateItem.fileName;
        System.out.println("fileName : " + fileName);
        if (fileName == null) {
            this.browser.setText("<p>\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ud15c\ud50c\ub9bf\uc785\ub2c8\ub2e4.</p>");
            return;
        }
        String bookTitle = this.bookTitleText.getText().trim();
        String authorTitle = this.authorText.getText().trim();
        String publishingHouse = this.publishingHouseText.getText().trim();
        String publisherName = this.publisherNameText.getText().trim();
        String publishingHouseAddr = this.publishingHouseAddrText.getText().trim();
        String publishingHouseTel = this.publishingHouseTelText.getText().trim();
        String publishingHouseEmail = this.publishingHouseEmailText.getText().trim();
        String isbn = this.isbnText.getText().trim();
        String publishInfo = this.publishInfoText.getText().trim();
        String templateHtml = ResourceUtil.loadFromBundle("resources/templates/publisher", fileName);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("\ucc45\uc81c\ubaa9", bookTitle);
        values.put("\uc791\uac00\uba85", authorTitle);
        values.put("\ucd9c\ud310\uc0ac", publishingHouse);
        values.put("\ubc1c\ud589\uc778", publisherName == null ? "" : publisherName);
        values.put("\uc8fc\uc18c", publishingHouseAddr);
        values.put("\uc804\ud654", publishingHouseTel);
        values.put("\uc774\uba54\uc77c", publishingHouseEmail);
        values.put("ISBN", isbn);
        values.put("\ucd9c\ud310\ub4f1\ub85d", publishInfo);
        String renderedHtml = this.replaceVariables(templateHtml, values);
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String resultHtmlContent = this.changeStylePath(projectFullPath, renderedHtml);
        this.browser.setText(resultHtmlContent);
    }

    private void saveXHTML() {
        System.out.println("saveXHTML()");
        String bookTitle = this.bookTitleText.getText().trim();
        String authorTitle = this.authorText.getText().trim();
        String publishingHouse = this.publishingHouseText.getText().trim();
        String publisherName = this.publisherNameText.getText().trim();
        String publishingHouseAddr = this.publishingHouseAddrText.getText().trim();
        String publishingHouseTel = this.publishingHouseTelText.getText().trim();
        String publishingHouseEmail = this.publishingHouseEmailText.getText().trim();
        String isbn = this.isbnText.getText().trim();
        String publishInfo = this.publishInfoText.getText().trim();
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        TemplateItem selectedTemplate = null;
        if (selection != null && !selection.isEmpty()) {
            selectedTemplate = (TemplateItem)selection.getFirstElement();
        } else {
            Object data;
            TreeItem[] items = this.treeViewer.getTree().getItems();
            if (items.length > 0 && (data = items[0].getData()) instanceof String) {
                selectedTemplate = (TemplateItem)data;
                this.treeViewer.setSelection((ISelection)new StructuredSelection(data));
            }
        }
        if (selectedTemplate == null) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.templateList.size()) {
            if (this.templateList.get(i).equals(selectedTemplate)) {
                index = i + 1;
                break;
            }
            ++i;
        }
        String templateFileName = "publisher_template" + index + ".xhtml";
        System.out.println("\uc800\uc790\ud15c\ud50c\ub9bf\uba85 : " + templateFileName);
        try {
            String xhtmlContent = ResourceUtil.loadFromBundle("resources/templates/publisher", templateFileName);
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("\ucc45\uc81c\ubaa9", bookTitle);
            values.put("\uc791\uac00\uba85", authorTitle);
            values.put("\ucd9c\ud310\uc0ac", publishingHouse);
            values.put("\ubc1c\ud589\uc778", publisherName == null ? "" : publisherName);
            values.put("\uc8fc\uc18c", publishingHouseAddr);
            values.put("\uc804\ud654", publishingHouseTel);
            values.put("\uc774\uba54\uc77c", publishingHouseEmail);
            values.put("ISBN", isbn);
            values.put("\ucd9c\ud310\ub4f1\ub85d", publishInfo);
            xhtmlContent = this.replaceVariables(xhtmlContent, values);
            xhtmlContent = xhtmlContent.replace("<p><p>", "<p>").replace("</p></p>", "</p>");
            Path outputDir = Paths.get(EpubBuildUtil.getProjectFullPath(), "OEBPS", "Text");
            Files.createDirectories(outputDir, new FileAttribute[0]);
            long count = Files.list(outputDir).filter(p -> p.getFileName().toString().startsWith("publisher") && p.toString().endsWith(".xhtml")).count();
            String fileName = "publisher.xhtml";
            if (count == 0L) {
                fileName = "publisher.xhtml";
                Files.writeString(outputDir.resolve(fileName), (CharSequence)xhtmlContent, StandardCharsets.UTF_8, new OpenOption[0]);
                String message = fileName + " \ud30c\uc77c\uc774 \uc0dd\uc131\ub418\uc5c8\uc2b5\ub2c8\ub2e4. Project Explorer Reload \ud6c4 \ud655\uc778 \ubd80\ud0c1\ub4dc\ub9bd\ub2c8\ub2e4.";
                this.applyOpf(this.shell, fileName, message);
            } else {
                fileName = String.format("publisher%d.xhtml", count + 1L);
                this.openMessage(this.shell, outputDir, fileName, xhtmlContent);
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.shell, (String)"\uc624\ub958", (String)e.getMessage());
        }
    }

    private void openMessage(Shell parentShell, Path outputDir, String fileName, String xhtmlContent) {
        MessageBox messageBox = new MessageBox(parentShell, 452);
        messageBox.setText("\ud30c\uc77c \uc874\uc7ac");
        messageBox.setMessage("publisher.xhtml\uc774 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4.\n\ub36e\uc5b4\uc4f0\uc2dc\uaca0\uc2b5\ub2c8\uae4c? (\uc544\ub2c8\uc624 \uc120\ud0dd \uc2dc publisher2.xhtml \uc0dd\uc131)");
        int response = messageBox.open();
        Path targetPath = outputDir.resolve(fileName);
        Object message = "";
        if (response == 64) {
            fileName = "publisher.xhtml";
            targetPath = outputDir.resolve(fileName);
            try {
                Files.writeString(targetPath, (CharSequence)xhtmlContent, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ResourceUtil.createXhtmlFile(outputDir, fileName, xhtmlContent);
            message = fileName + " \ud30c\uc77c\uc774 \ub36e\uc5b4\uc4f0\uae30\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
            CommonUtil.showMessageBox(this.shell, (String)message);
        } else if (response == 128) {
            ResourceUtil.createXhtmlFile(outputDir, fileName, xhtmlContent);
            message = fileName + " \ud30c\uc77c\uc774 \uc0dd\uc131\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
            this.applyOpf(this.shell, fileName, (String)message);
        }
    }

    private void applyOpf(Shell shell, String fileName, String message) {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        boolean isXhtml = true;
        boolean addToScripted = true;
        boolean addToLinearNo = true;
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Text");
        String href = iFolder.getProjectRelativePath().append(fileName).toString().substring("OEBPS/".length());
        String id = fileName.replaceAll("[^a-zA-Z0-9]", "_");
        OpfNcxUpdater.addFileToOpf(iFolder.getProject().getFile("OEBPS/content.opf"), id, href, OpfNcxUpdater.getMediaType(fileName), isXhtml, addToScripted, addToLinearNo);
        CommonUtil.showMessageBox(shell, message);
    }

    private String replaceVariables(String template, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            Object value = entry.getValue();
            if ("\uba85\uc5b8".equals(entry.getKey()) && !((String)value).isEmpty()) {
                value = "\u201c" + entry.getValue() + "\u201d";
            }
            template = template.replace("${" + entry.getKey() + "}", (CharSequence)value);
        }
        return template;
    }

    public static String convertNewlinesToParagraphs(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String[] lines = text.split("\\r?\\n");
        StringBuilder html = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().isEmpty()) {
                html.append("<p>").append(PublisherTemplateEditorPage.escapeHtml(line)).append("</p>");
            }
            ++n2;
        }
        return html.toString();
    }

    public static String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private String changeStylePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Styles/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String styleFileName = matcher.group(1);
            File styleFile = new File(projectFullPath, "OEBPS/Styles/" + styleFileName);
            String styleUri = styleFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(styleUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    private String changeImagePath(String projectFullPath, String htmlContent) {
        Pattern pattern = Pattern.compile("\\.\\./Images/([^\"'>]+)");
        Matcher matcher = pattern.matcher(htmlContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String imageFileName = matcher.group(1);
            File imageFile = new File(projectFullPath, "OEBPS/Images/" + imageFileName);
            String imageUri = imageFile.toURI().toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(imageUri));
        }
        matcher.appendTail(sb);
        String resultHtmlContent = sb.toString();
        return resultHtmlContent;
    }

    private String processImageBase64(String xhtml, String imagePath) {
        String finalHtml = "";
        if (imagePath != null) {
            String mimeType = ResourceUtil.getMimeType(imagePath);
            String base64Image = ResourceUtil.encodeImageToBase64(imagePath);
            if (base64Image != null) {
                String base64Src = "data:" + mimeType + ";base64," + base64Image;
                finalHtml = xhtml.replace("${\uc774\ubbf8\uc9c0\uacbd\ub85c}", base64Src);
                System.out.println(finalHtml);
            }
        }
        return finalHtml;
    }
}

