/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.pages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jakarta.annotation.PostConstruct;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import kr.co.goms.epub.solution.providers.TableLabelProvider;
import kr.co.goms.epub.solution.ui.QuoteItem;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class QuoteEditorPage {
    private TreeViewer treeViewer;
    private TableViewer tableViewer;
    private Color backgroundColor;
    private Text quoteText;
    private Map<String, List<String>> quotesMap;
    private QuoteSelectedCallback quoteSelectedCallback;
    private boolean sortAscending = true;
    private Text searchText;
    private List<QuoteItem> allQuotes = new ArrayList<QuoteItem>();
    Shell shell;

    @PostConstruct
    public void createControls(Composite parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent composite cannot be null");
        }
        this.shell = parent.getShell();
        parent.setLayout((Layout)new FillLayout());
        this.backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.quotesMap = this.getQuotesData();
        this.createLeftTreeViewer((Composite)sashForm, this.quotesMap);
        this.createRightForm((Composite)sashForm);
        this.selectQuoteView((Composite)sashForm);
        sashForm.setWeights(new int[]{18, 38, 44});
        sashForm.addDisposeListener(e -> this.quotesMap.clear());
    }

    private void createLeftTreeViewer(Composite parent, Map<String, List<String>> quotesMap) {
        this.treeViewer = new TreeViewer(parent, 2052);
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Map) {
                    return ((Map)inputElement).keySet().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setInput(quotesMap);
        this.treeViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                String category = (String)selection.getFirstElement();
                this.updateTable(category);
            }
        });
    }

    private void createRightForm(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.searchText = new Text(container, 2944);
        this.searchText.setMessage("\uba85\uc5b8 \uac80\uc0c9...");
        this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchText.addModifyListener(e -> this.applyFilter());
        this.tableViewer = new TableViewer(container, 68096);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderBackground(this.backgroundColor);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        String[] titles = new String[]{"No", "\uba85\uc5b8"};
        int[] widths = new int[]{50, 350};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            column.setResizable(false);
            column.setMoveable(false);
            ++i;
        }
        List<String> quotes = this.getQuotesByCategory("happiness");
        this.allQuotes = new ArrayList<QuoteItem>();
        int i2 = 0;
        while (i2 < quotes.size()) {
            this.allQuotes.add(new QuoteItem(i2 + 1, quotes.get(i2)));
            ++i2;
        }
        this.tableViewer.setInput(this.allQuotes);
        this.tableViewer.addSelectionChangedListener(event -> {
            Object selected;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof QuoteItem) {
                QuoteItem quoteItem = (QuoteItem)selected;
                System.out.println("Row \ud074\ub9ad\ub428 - Quote: " + quoteItem.getQuote());
                this.quoteText.setText(quoteItem.getQuote());
                this.quoteSelectedCallback.onQuoteSelected(quoteItem.getQuote());
            }
        });
    }

    private void selectQuoteView(Composite parent) {
        FontData[] fontData;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        SashForm sashForm = new SashForm(container, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite header = new Composite((Composite)sashForm, 0);
        header.setLayout((Layout)new FillLayout());
        Label headerText = new Label(header, 64);
        headerText.setText("\uba85\uc5b8");
        FontData[] fontDataArray = fontData = headerText.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(14);
            fd.setStyle(1);
            ++n2;
        }
        Font boldFont = new Font((Device)Display.getCurrent(), fontData);
        headerText.setFont(boldFont);
        headerText.addDisposeListener(e -> boldFont.dispose());
        Composite top = new Composite((Composite)sashForm, 0);
        top.setLayout((Layout)new FillLayout());
        this.quoteText = new Text(top, 2114);
        GridData quoteData = new GridData(4, 4, true, true);
        quoteData.widthHint = 600;
        this.quoteText.setLayoutData((Object)quoteData);
        Composite bottom = new Composite((Composite)sashForm, 0);
        bottom.setLayout((Layout)new FillLayout());
        Composite buttonComposite = new Composite(bottom, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 10;
        rowLayout.center = true;
        buttonComposite.setLayout((Layout)rowLayout);
        Button copyBtn = new Button(buttonComposite, 8);
        copyBtn.setText("\uba85\uc5b8\ubcf5\uc0ac");
        copyBtn.addListener(13, e -> {
            if (!this.quoteText.getText().isEmpty()) {
                this.copyQuote(this.quoteText.getText());
            }
        });
        Button randomBtn = new Button(buttonComposite, 8);
        randomBtn.setText("\ub79c\ub364");
        randomBtn.addListener(13, e -> {
            String randomQuote = QuoteEditorPage.getRandomQuote(this.quotesMap);
            this.quoteText.setText(randomQuote);
            if (!randomQuote.isEmpty()) {
                this.copyQuote(randomQuote);
            }
        });
        Button confirmBtn = new Button(buttonComposite, 8);
        confirmBtn.setText("\ud655\uc778");
        confirmBtn.addListener(13, e -> this.shell.dispose());
        sashForm.setWeights(new int[]{4, 26, 70});
    }

    private void updateTable(String category) {
        List<String> quotes = this.getQuotesByCategory(category);
        ArrayList<QuoteItem> items = new ArrayList<QuoteItem>();
        int i = 0;
        while (i < quotes.size()) {
            items.add(new QuoteItem(i + 1, quotes.get(i)));
            ++i;
        }
        this.tableViewer.setInput(items);
    }

    private Map<String, List<String>> getQuotesData() {
        HashMap<String, List<String>> quotesMap = new HashMap<String, List<String>>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = this.getClass().getResourceAsStream("/resources/quotes.json");){
                if (in == null) {
                    System.err.println("quotes.json not found");
                    return quotesMap;
                }
                String jsonData = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                JsonObject obj = JsonParser.parseString((String)jsonData).getAsJsonObject();
                for (String key : obj.keySet()) {
                    JsonArray arr = obj.getAsJsonArray(key);
                    ArrayList<String> quotes = new ArrayList<String>();
                    for (JsonElement el : arr) {
                        quotes.add(el.getAsString());
                    }
                    quotesMap.put(key, quotes);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return quotesMap;
    }

    private List<String> getQuotesCategory(Map<String, List<String>> quotesMap) {
        ArrayList<String> categories = new ArrayList<String>(quotesMap.keySet());
        for (String category : categories) {
            System.out.println("\uce74\ud14c\uace0\ub9ac: " + category);
        }
        return categories;
    }

    public List<String> getQuotesByCategory(String category) {
        Map<String, List<String>> quotesMap = this.getQuotesData();
        return quotesMap.getOrDefault(category, Collections.emptyList());
    }

    private void copyQuote(String selectedText) {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        clipboard.setContents(new Object[]{selectedText}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    public static String getRandomQuote(Map<String, List<String>> quotesMap) {
        Random random;
        if (quotesMap == null || quotesMap.isEmpty()) {
            return null;
        }
        ArrayList<String> categories = new ArrayList<String>(quotesMap.keySet());
        String randomCategory = (String)categories.get((random = new Random()).nextInt(categories.size()));
        List<String> quotes = quotesMap.get(randomCategory);
        if (quotes == null || quotes.isEmpty()) {
            return null;
        }
        String randomQuote = quotes.get(random.nextInt(quotes.size()));
        return randomQuote;
    }

    public void setQuoteSelectCallback(QuoteSelectedCallback callback) {
        this.quoteSelectedCallback = callback;
    }

    private void applyFilter() {
        String keyword = this.searchText.getText().trim().toLowerCase();
        List filtered = this.allQuotes.stream().filter(quote -> quote.getQuote().toLowerCase().contains(keyword)).collect(Collectors.toList());
        this.tableViewer.setInput(filtered);
    }

    public static interface QuoteSelectedCallback {
        public void onQuoteSelected(String var1);
    }
}

